import json

import socket
import time

 
def control_packet(charging_current_amps: float):
    # Limit current values
    charging_current_amps = min(charging_current_amps, 10)
    charging_current_amps = max(charging_current_amps, -20)
    
    cmd_packet = {}
    cmd_packet["dis_A"] = abs(min(charging_current_amps, 0))
    cmd_packet["cha_A"] = max(charging_current_amps, 0)
    cmd_packet["sup_on"] = charging_current_amps >= 0
    cmd_packet["load_on"] = charging_current_amps < 0
    return cmd_packet

 
 
 
def set_setpoint(charging_current_amps: float):
    HOST = "127.0.0.1"  # The server's hostname or IP address
    PORT = 5020  # The port used by the server
    
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        s.connect((HOST, PORT))
        data_str = json.dumps(control_packet(charging_current_amps))
        s.sendall(f'{data_str}\r\n'.encode(encoding="utf-8"))
        data = s.recv(1024).decode()
    
    voltage = float(data.split(',')[1].split(':')[1].strip())
    current = float(data.split(',')[2].split(':')[1].strip())
    
    return voltage, current
    
     
    #print(f"Received {data!r}")
    
   

def read_voltage():
    set_setpoint(0)
    (v, c) = set_setpoint(0)
    return v



v_min = 2.7
v_max = 4.2





def go_to_voltage(target_voltage: float, countdown_max: int=100):
    kp = 1.5
    ki = 0.20
    integral_state = 0
    integral_last_act = time.time()
    cur_voltage = read_voltage()
    
    countdown = countdown_max
    
    while True:
        now = time.time()
        err = target_voltage - cur_voltage
        integral_state = integral_state + err*(now-integral_last_act)
        current_action = err * kp + integral_state*ki
        
        integral_last_act = now
        
        (cur_voltage, cur_current) = set_setpoint(current_action)
        (cur_voltage, cur_current) = set_setpoint(current_action)
        (cur_voltage, cur_current) = set_setpoint(current_action)
        
        print('')
        print('*************')
        print(f'Actuated setpoint: {current_action} A')
        print(f'Current voltage: {cur_voltage} V')
        print(f'Target voltage: {target_voltage} V')
        time.sleep(1)
        if abs(cur_current) <= 0.6:
            countdown = countdown - 1
            print(f"Counting down: {countdown}")
        else:
            countdown = countdown_max
            
        if countdown <= 0:
            break


def charge_at_for(charging_current_amps: float, duration_s: float):
    print("")
    print(f"Charge at {charging_current_amps:.1f} for {duration_s}~seconds.")
    set_setpoint(charging_current_amps)
    time.sleep(duration_s)
    
    
    

'''
def charge_at_for(charging_current_amps: float, duration_s: float):
    print(f"Charge at {charging_current_amps:.1f} A for {duration_s} seconds.")
    global Ah
    global t_sec
    Ah = Ah + charging_current_amps * duration_s/3600.
    t_sec = t_sec + duration_s
    print(f"Residual charge: {Ah:.1f} Ah")
    print(f"Time: {t_sec} seconds")
    #set_setpoint(charging_current_amps)
    #time.sleep(duration_s)
'''
    



go_to_voltage(3.60, 180)
charge_at_for(10, 120)
charge_at_for(-15, 250)
charge_at_for(-5, 100)
charge_at_for(9, 300)
charge_at_for(-10, 50)
charge_at_for(0, 300)


#go_to_voltage(3.5, 180)
#charge_at_for(10, 120)
#charge_at_for(-20, 70)
#charge_at_for(-15, 90)
#charge_at_for(10, 200)
#charge_at_for(-20, 120)
#charge_at_for(0, 300)


go_to_voltage(4, 180)





