import json

import socket
import time

 
def control_packet(charging_current_amps: float):
    # Limit current values
    charging_current_amps = min(charging_current_amps, 10)
    charging_current_amps = max(charging_current_amps, -20)
    
    cmd_packet = {}
    cmd_packet["dis_A"] = abs(min(charging_current_amps, 0))
    cmd_packet["cha_A"] = max(charging_current_amps, 0)
    cmd_packet["sup_on"] = charging_current_amps >= 0
    cmd_packet["load_on"] = charging_current_amps < 0
    return cmd_packet

 
 
 
def set_setpoint(charging_current_amps: float):
    HOST = "127.0.0.1"  # The server's hostname or IP address
    PORT = 5020  # The port used by the server
    
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        s.connect((HOST, PORT))
        data_str = json.dumps(control_packet(charging_current_amps))
        s.sendall(f'{data_str}\r\n'.encode(encoding="utf-8"))
        data = s.recv(1024).decode()
    
    voltage = float(data.split(',')[1].split(':')[1].strip())
    current = float(data.split(',')[2].split(':')[1].strip())
    
    return voltage, current
    
     
    #print(f"Received {data!r}")
    
   

def read_voltage():
    set_setpoint(0)
    (v, c) = set_setpoint(0)
    return v



v_min = 2.7
v_max = 4.2





def go_to_voltage(target_voltage: float, countdown_max: int=100):
    kp = 1
    ki = 0.1
    integral_state = 0
    integral_last_act = time.time()
    cur_voltage = read_voltage()
    
    countdown = countdown_max
    
    while True:
        now = time.time()
        err = target_voltage - cur_voltage
        integral_state = integral_state + err*(now-integral_last_act)
        current_action = err * kp + integral_state*ki
        
        integral_last_act = now
        
        (cur_voltage, cur_current) = set_setpoint(current_action)
        (cur_voltage, cur_current) = set_setpoint(current_action)
        (cur_voltage, cur_current) = set_setpoint(current_action)
        
        print('')
        print('*************')
        print(f'Actuated setpoint: {current_action} A')
        print(f'Current voltage: {cur_voltage} V')
        print(f'Target voltage: {target_voltage} V')
        time.sleep(1)
        if abs(cur_current) < 0.5:
            countdown = countdown - 1
            print(f"Counting down: {countdown}")
        else:
            countdown = countdown_max
            
        if countdown <= 0:
            break



perc = [i/10 for i in list(range (1, 10))]
voltages = [p*(v_max - v_min) + v_min for p in perc]

for v in voltages:
    go_to_voltage(v, 400)






