/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import ViolinStrings.Strings;
import uchicago.src.sim.parameter.rpl.CompilerException;
import uchicago.src.sim.parameter.rpl.Node;
import uchicago.src.sim.parameter.rpl.RPLCompiler;
import uchicago.src.sim.parameter.rpl.RPLObject;
import uchicago.src.sim.parameter.rpl.RPLParser;
import uchicago.src.sim.parameter.rpl.RPLParserTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected RPLParser parser;
    protected int beginLine;
    protected int endLine;
    protected int beginColumn;
    protected int endColumn;
    Object info;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(RPLParser rPLParser, int n) {
        this(n);
        this.parser = rPLParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return RPLParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public void setString(String string, int n) {
        this.info = this.parseString(string, n);
    }

    public String parseString(String string, int n) {
        String string2 = string.substring(n, string.length() - n);
        string2 = Strings.change((String)string2, (String)"\\n", (String)"\n");
        string2 = Strings.change((String)string2, (String)"\\\"", (String)"\"");
        string2 = Strings.change((String)string2, (String)"\\t", (String)"\t");
        string2 = Strings.change((String)string2, (String)"\\r", (String)"\r");
        return string2;
    }

    public void setInteger(String string, int n) {
        if (string.endsWith("L") || string.endsWith("l")) {
            string = string.substring(0, string.length() - 1);
            try {
                this.setInfo(Long.valueOf(string, n));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Error creating long value";
                this.throwError(string2, numberFormatException);
            }
        } else {
            long l;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            if (n3 - n2 > 11) {
                this.throwError("Integer literal too large");
            }
            if ((l = Long.valueOf(string, n).longValue()) > 0xFFFFFFFFL || n == 10 && l > Integer.MAX_VALUE) {
                this.throwError("Integer literal too large");
            }
            this.setInfo(new Integer((int)l));
        }
    }

    public void setFloat(String string) {
        if (string.endsWith("F") || string.endsWith("f")) {
            string = string.substring(0, string.length() - 1);
            try {
                this.setInfo(Float.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Error creating float value";
                this.throwError(string2, numberFormatException);
            }
        } else {
            this.setInfo(Double.valueOf(string));
        }
    }

    public RPLObject getValue() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not" + " support getValue()");
    }

    public void preProcess(RPLCompiler rPLCompiler) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not" + " support compile()");
    }

    public void compile(RPLCompiler rPLCompiler) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not" + " support compile(RPLCompiler)");
    }

    protected void throwError(String string) {
        throw new CompilerException("Error at line " + this.endLine + " " + string);
    }

    protected void throwError(String string, Exception exception) {
        throw new CompilerException("Error at line " + this.endLine + " " + string, exception);
    }
}

