/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.io.PrintStream;
import java.io.PrintWriter;

public class CompilerException
extends RuntimeException {
    private Exception ex;
    private String message;
    private String fileName;
    private String code;
    private int line;

    public CompilerException(String string, Exception exception) {
        this.ex = exception;
        this.message = string;
    }

    public CompilerException(String string) {
        this.message = string;
    }

    public void resetMessage(String string) {
        this.message = string;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    private String formatMessage() {
        StringBuffer stringBuffer = new StringBuffer("File: ");
        stringBuffer.append(this.fileName);
        stringBuffer.append(", line: ");
        stringBuffer.append(this.line);
        stringBuffer.append("\nCompiler Error: ");
        stringBuffer.append(this.message);
        stringBuffer.append("\n  ");
        stringBuffer.append(this.code);
        return stringBuffer.toString();
    }

    public void printSuperStackTrace() {
        super.printStackTrace(System.err);
    }

    public void printStackTrace() {
        System.out.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace(printWriter);
        }
    }

    public String getMessage() {
        if (this.ex != null) {
            return this.formatMessage() + "\n" + this.ex.getMessage();
        }
        return this.formatMessage();
    }
}

