/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.list.IntArrayList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.SimUtilities;

public class PajekNetReader {
    private BufferedReader reader;
    private ArrayList nodeList = new ArrayList();
    private IntArrayList xCoordList = new IntArrayList();
    private IntArrayList yCoordList = new IntArrayList();

    public PajekNetReader(String string) {
        try {
            this.reader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            SimUtilities.showError("Error reading network file: " + string, iOException);
            System.exit(0);
        }
    }

    public List getNetwork(Class clazz, Class clazz2) throws IOException {
        int n = 0;
        this.nodeList.clear();
        this.xCoordList.clear();
        this.yCoordList.clear();
        n = this.parseHeader(this.reader.readLine());
        for (int i = 1; i <= n; ++i) {
            this.parseNode(clazz, this.reader.readLine().trim(), i);
        }
        String string = this.reader.readLine().trim();
        String string2 = "";
        if (string.equals("*Arcs")) {
            string2 = this.reader.readLine().trim();
            while (string2 != null && !string2.equals("*Edges") && !string2.equals("")) {
                this.parseArc(clazz2, string2.trim());
                string2 = this.reader.readLine();
            }
        }
        if (string.equals("*Edges") || string2 != null && string2.equals("*Edges")) {
            string2 = this.reader.readLine().trim();
            while (string2 != null && !string2.equals("")) {
                this.parseEdge(clazz2, string2.trim());
                string2 = this.reader.readLine();
            }
        }
        return this.nodeList;
    }

    public List getDrawableNetwork(Class clazz, Class clazz2, int n, int n2) throws IOException {
        int n3 = 0;
        this.nodeList.clear();
        this.xCoordList.clear();
        this.yCoordList.clear();
        n3 = this.parseHeader(this.reader.readLine());
        for (int i = 1; i <= n3; ++i) {
            this.parseDrawableNode(clazz, n, n2, this.reader.readLine().trim(), i);
        }
        String string = this.reader.readLine().trim();
        String string2 = "";
        if (string.equals("*Arcs")) {
            string2 = this.reader.readLine().trim();
            while (string2 != null && !string2.equals("*Edges")) {
                this.parseArc(clazz2, string2.trim());
                string2 = this.reader.readLine();
            }
        }
        if (string.equals("*Edges") || string2 != null && string2.equals("*Edges")) {
            string2 = this.reader.readLine().trim();
            while (string2 != null && !string2.equals("")) {
                this.parseEdge(clazz2, string2.trim());
                string2 = this.reader.readLine();
            }
        }
        return this.nodeList;
    }

    private int parseHeader(String string) throws IOException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        if (stringTokenizer.countTokens() == 2) {
            if (stringTokenizer.nextToken().equals("*Vertices")) {
                try {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    SimUtilities.showError("Unable to parse number of Vertices: ", numberFormatException);
                }
            } else {
                SimUtilities.showError("File must begin with \"*Vertices:\" ", new IOException("Unable to Parse .net file"));
            }
        } else {
            SimUtilities.showError("Wrong number of entries in first line of file", new IOException("Unable to Parse .net file"));
        }
        return n;
    }

    private void parseNode(Class clazz, String string, int n) throws IOException {
        String string2 = "";
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        if (stringTokenizer.countTokens() < 2) {
            SimUtilities.showError("Line " + n + "is missing entries", new IOException("Unable to Parse .net file"));
        } else {
            String string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
            try {
                n2 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n2 != n) {
                    SimUtilities.showError("Vertex line numbers must be in sequence: ", new IOException("Unable to Parse .net file"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                SimUtilities.showError("Each vertex must be proceeded by an integer line number: ", numberFormatException);
            }
        }
        try {
            Node node = (Node)clazz.newInstance();
            node.setNodeLabel(string2);
            this.nodeList.add(node);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error instantiating nodes", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error instantiating nodes", instantiationException);
        }
    }

    private void parseArc(Class clazz, String string) throws IOException {
        double d = 1.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 2) {
            SimUtilities.showError("An Arc is missing entries", new IOException("Unable to Parse .net file"));
        } else {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                if (stringTokenizer.hasMoreTokens()) {
                    d = Double.parseDouble(stringTokenizer.nextToken());
                }
                try {
                    Node node = (Node)this.nodeList.get(n);
                    Node node2 = (Node)this.nodeList.get(n2);
                    Edge edge = (Edge)clazz.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node2);
                    edge.setStrength(d);
                    node.addOutEdge(edge);
                    node2.addInEdge(edge);
                }
                catch (IllegalAccessException illegalAccessException) {
                    SimUtilities.showError("Error instantiating Edge", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    SimUtilities.showError("Error instantiating Edge", instantiationException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                SimUtilities.showError("Problem with Arc entries", numberFormatException);
            }
        }
    }

    private void parseEdge(Class clazz, String string) {
        double d = 1.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 2) {
            SimUtilities.showError("An Edge is missing entries", new IOException("Unable to Parse .net file"));
        } else {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                if (stringTokenizer.hasMoreTokens()) {
                    d = Double.parseDouble(stringTokenizer.nextToken());
                }
                try {
                    Node node = (Node)this.nodeList.get(n);
                    Node node2 = (Node)this.nodeList.get(n2);
                    Edge edge = (Edge)clazz.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node2);
                    edge.setStrength(d);
                    node.addOutEdge(edge);
                    node2.addInEdge(edge);
                    Edge edge2 = (Edge)clazz.newInstance();
                    edge2.setFrom(node2);
                    edge2.setTo(node);
                    edge2.setStrength(d);
                    node2.addOutEdge(edge2);
                    node.addInEdge(edge2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    SimUtilities.showError("Error instantiating Edge", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    SimUtilities.showError("Error instantiating Edge", instantiationException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                SimUtilities.showError("Problem with Edge entries", numberFormatException);
            }
        }
    }

    private void parseDrawableNode(Class clazz, int n, int n2, String string, int n3) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        String string2 = "";
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        if (stringTokenizer.countTokens() < 3) {
            SimUtilities.showError("Line " + n3 + "is missing entries", new IOException("Unable to Parse .net file"));
        } else {
            String string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
            try {
                n4 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n4 != n3) {
                    SimUtilities.showError("Vertex line numbers must be in sequence: ", new IOException("Unable to Parse .net file"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                SimUtilities.showError("Each vertex must be proceeded by an integer line number: ", numberFormatException);
            }
            stringTokenizer2 = new StringTokenizer(string4, " ");
            if (stringTokenizer2.countTokens() < 2) {
                SimUtilities.showError("Line " + n3 + "is missing entries", new IOException("Unable to Parse .net file"));
            } else {
                try {
                    d = Double.parseDouble(stringTokenizer2.nextToken());
                    d2 = Double.parseDouble(stringTokenizer2.nextToken());
                    d = Math.round(d * (double)n);
                    d2 = Math.round(d2 * (double)n2);
                }
                catch (NumberFormatException numberFormatException) {
                    SimUtilities.showError("Error reading .net file, unable to parse coordinates: ", numberFormatException);
                }
            }
        }
        try {
            Node node = (Node)clazz.newInstance();
            node.setNodeLabel(string2);
            this.nodeList.add(node);
            this.xCoordList.add((int)d);
            this.yCoordList.add((int)d2);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error instantiating Drawable node", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error instantiating Drawable node", instantiationException);
        }
    }

    public int[] getXY(Node node) {
        int[] nArray = new int[]{0, 0};
        int n = this.nodeList.indexOf(node);
        if (n != -1 && this.xCoordList.size() > 0) {
            nArray[0] = this.xCoordList.get(n);
            nArray[1] = this.yCoordList.get(n);
        }
        return nArray;
    }
}

