/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.network.PairHash;

class ConvertorUtil {
    ConvertorUtil() {
    }

    public Hashtable makeEdges(Hashtable hashtable, Vector vector, Class clazz) throws IllegalAccessException, InstantiationException {
        for (int i = 0; i < vector.size(); ++i) {
            AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(i);
            String string = adjacencyMatrix.getMatrixLabel();
            for (int j = 0; j < hashtable.size(); ++j) {
                Node node = (Node)hashtable.get(new Integer(j));
                for (int k = 0; k < adjacencyMatrix.rows(); ++k) {
                    double d = adjacencyMatrix.get(j, k);
                    if (d == 0.0) continue;
                    Node node2 = (Node)hashtable.get(new Integer(k));
                    Edge edge = (Edge)clazz.newInstance();
                    edge.setType(string);
                    edge.setFrom(node);
                    edge.setTo(node2);
                    edge.setStrength(d);
                    node.addOutEdge(edge);
                    node2.addInEdge(edge);
                }
            }
        }
        return hashtable;
    }

    public PairHash makeNodes(AdjacencyMatrix adjacencyMatrix, Class clazz) throws IllegalAccessException, InstantiationException {
        List list = adjacencyMatrix.getLabels();
        Hashtable<Integer, Node> hashtable = new Hashtable<Integer, Node>(adjacencyMatrix.rows());
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(adjacencyMatrix.rows());
        boolean bl = false;
        if (list.size() != 0) {
            if (list.size() != adjacencyMatrix.rows()) {
                throw new IllegalArgumentException("Number of matrix labels not equal to number of matrix rows");
            }
            bl = true;
        }
        for (int i = 0; i < adjacencyMatrix.rows(); ++i) {
            Node node = (Node)clazz.newInstance();
            Integer n = new Integer(i);
            hashtable.put(n, node);
            if (!bl) continue;
            node.setNodeLabel((String)list.get(i));
            hashtable2.put(node.getNodeLabel(), n);
        }
        return new PairHash(hashtable, hashtable2);
    }

    public boolean labelCheck(Vector vector) {
        if (vector.size() > 1) {
            List list = ((AdjacencyMatrix)vector.get(0)).getLabels();
            for (int i = 1; i < vector.size(); ++i) {
                List list2 = ((AdjacencyMatrix)vector.get(i)).getLabels();
                if (list2.size() != list.size()) {
                    return false;
                }
                for (int j = 0; j < list.size(); ++j) {
                    String string;
                    String string2 = (String)list.get(j);
                    if (string2.equals(string = (String)list2.get(j))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

