/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uchicago.src.sim.engine.Controller;
import uchicago.src.sim.gui.CircleIcon;
import uchicago.src.sim.gui.LegendIcon;
import uchicago.src.sim.gui.SquareIcon;

public class Legend {
    public static final int SQUARE = 0;
    public static final int CIRCLE = 1;
    private ArrayList legends = new ArrayList();
    private JFrame frame;
    private String title = "";
    private JPanel p;

    public Legend(String string) {
        this.title = string;
    }

    public void addLegend(String string, int n, Color color, boolean bl) {
        this.addLegend(string, n, color, bl, 16, 16);
    }

    public void addLegend(String string, int n, Color color, boolean bl, int n2, int n3) {
        LegendIcon legendIcon = null;
        switch (n) {
            case 0: {
                legendIcon = new SquareIcon(n2, n3, color, bl);
                break;
            }
            case 1: {
                legendIcon = new CircleIcon(n2, n3, color, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized legend label type");
            }
        }
        JLabel jLabel = new JLabel(string, legendIcon, 2);
        jLabel.setForeground(Color.black);
        jLabel.setIconTextGap(16);
        this.legends.add(jLabel);
    }

    private void layout() {
        GridLayout gridLayout = new GridLayout(this.legends.size(), 1);
        gridLayout.setVgap(5);
        this.p = new JPanel(gridLayout);
        for (int i = 0; i < this.legends.size(); ++i) {
            this.p.add((JLabel)this.legends.get(i));
        }
    }

    public void display() {
        if (this.frame == null) {
            this.frame = new JFrame(this.title);
            this.frame.setIconImage(new ImageIcon(Controller.class.getResource("/uchicago/src/sim/images/RepastSmall.gif")).getImage());
            this.layout();
            Container container = this.frame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.p, "Center");
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void dispose() {
        this.frame.dispose();
    }
}

