/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.util.ArrayList;
import javax.swing.Icon;
import uchicago.src.sim.analysis.AbstractChartModel;
import uchicago.src.sim.analysis.ChartSourceFactory;
import uchicago.src.sim.analysis.OpenSequenceGraph;
import uchicago.src.sim.analysis.SequenceSource;
import uchicago.src.sim.analysis.plot.OpenGraph;
import uchicago.src.sim.engine.SimModel;

public class SequenceChartModel
extends AbstractChartModel {
    private String type = "OpenSequenceGraph";

    public SequenceChartModel(SimModel simModel) {
        super(simModel);
    }

    public AbstractChartModel copy() {
        SequenceChartModel sequenceChartModel = new SequenceChartModel(this.simModel);
        sequenceChartModel.type = this.type;
        return this.copy(sequenceChartModel);
    }

    public String getType() {
        return this.type;
    }

    public ArrayList getModelDataSources() {
        return ChartSourceFactory.createSequenceSources(this.simModel);
    }

    public Icon getIcon() {
        return AbstractChartModel.SEQUENCE_ICON;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<ChartModel type=\"SequenceChart\" ");
        stringBuffer.append(super.getXML());
        stringBuffer.append("\n");
        stringBuffer.append("</ChartModel>");
        return stringBuffer.toString();
    }

    public OpenGraph createChart() {
        OpenSequenceGraph openSequenceGraph = new OpenSequenceGraph(this.title, this.simModel);
        openSequenceGraph.setAxisTitles(this.xAxisTitle, this.yAxisTitle);
        openSequenceGraph.setXIncrement(this.xRangeIncr);
        openSequenceGraph.setXRange(this.xRangeMin, this.xRangeMax);
        openSequenceGraph.setYIncrement(this.yRangeIncr);
        openSequenceGraph.setYRange(this.yRangeMin, this.yRangeMax);
        for (int i = 0; i < this.dataSources.size(); ++i) {
            SequenceSource sequenceSource = (SequenceSource)this.dataSources.get(i);
            openSequenceGraph.createSequence(sequenceSource.getName(), sequenceSource.getColor(), sequenceSource.getMarkStyle(), sequenceSource.getFeedFrom(), sequenceSource.getMethodName());
        }
        return openSequenceGraph;
    }
}

