/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import layout.TableLayout;
import uchicago.src.guiUtils.ColorChooserPopup;
import uchicago.src.guiUtils.ColorIcon;
import uchicago.src.sim.analysis.AbstractChartModel;
import uchicago.src.sim.analysis.ChartGuiPanel;
import uchicago.src.sim.analysis.GuiChartDataSource;
import uchicago.src.sim.analysis.MarkListRenderer;
import uchicago.src.sim.analysis.SequenceSource;

public class DataSourcePropPanel
extends JPanel
implements ChartGuiPanel {
    private AbstractChartModel model;
    private int curListIndex = -1;
    private Color color;
    JTextField txtName = new JTextField("A Sequence");
    JComboBox cmbMarkStyle;
    JButton btnColor = new JButton();
    JList lstSources = new JList();
    private static final int ICON_SIZE = 14;

    public DataSourcePropPanel() {
        this.lstSources.setModel(new DefaultListModel());
        this.setBorder(BorderFactory.createTitledBorder("Sequence Display Properties"));
        this.btnColor.setIcon(new ColorIcon(Color.blue, 14));
        Object[] objectArray = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9)};
        this.cmbMarkStyle = new JComboBox<Object>(objectArray);
        this.cmbMarkStyle.setRenderer(new MarkListRenderer());
        int n = 5;
        int n2 = 8;
        int n3 = 8;
        int n4 = this.txtName.getPreferredSize().height;
        double[][] dArrayArray = new double[][]{{n, 0.5, n2, 0.25, n2, 0.25, n}, {n3, n4, n4, n3, n4, this.btnColor.getPreferredSize().height, 0.5, 0.5, n3}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)new JScrollPane(this.lstSources), "1, 1, 1, 7");
        this.add((Component)new JLabel("Name:"), "3, 1, 5, 1");
        this.add((Component)this.txtName, "3, 2, 5, 2");
        this.add((Component)new JLabel("Color:"), "3, 4");
        this.add((Component)this.btnColor, "3, 5");
        this.add((Component)new JLabel("Mark Style:"), "5, 4");
        this.add((Component)this.cmbMarkStyle, "5, 5");
        this.lstSources.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setText(((GuiChartDataSource)object).getFullName());
                return jLabel;
            }
        });
        this.addListeners();
    }

    public void addListeners() {
        this.lstSources.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object object;
                    if (DataSourcePropPanel.this.curListIndex != -1) {
                        object = (DefaultListModel)DataSourcePropPanel.this.lstSources.getModel();
                        SequenceSource sequenceSource = (SequenceSource)((DefaultListModel)object).getElementAt(DataSourcePropPanel.this.curListIndex);
                        sequenceSource.setName(DataSourcePropPanel.this.txtName.getText());
                    }
                    DataSourcePropPanel.this.curListIndex = DataSourcePropPanel.this.lstSources.getSelectedIndex();
                    object = (SequenceSource)DataSourcePropPanel.this.lstSources.getSelectedValue();
                    if (object != null) {
                        DataSourcePropPanel.this.btnColor.setIcon(new ColorIcon(((SequenceSource)object).getColor(), 14));
                        DataSourcePropPanel.this.txtName.setText(((SequenceSource)object).getName());
                        DataSourcePropPanel.this.cmbMarkStyle.setSelectedItem(new Integer(((SequenceSource)object).getMarkStyle()));
                    }
                }
            }
        });
        this.btnColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ColorChooserPopup colorChooserPopup = new ColorChooserPopup();
                colorChooserPopup.addColorChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        DataSourcePropPanel.this.color = colorChooserPopup.getColor();
                        (this).DataSourcePropPanel.this.btnColor.setIcon(new ColorIcon(DataSourcePropPanel.this.color, 14));
                        if (DataSourcePropPanel.this.curListIndex != -1) {
                            DefaultListModel defaultListModel = (DefaultListModel)(this).DataSourcePropPanel.this.lstSources.getModel();
                            SequenceSource sequenceSource = (SequenceSource)defaultListModel.getElementAt(DataSourcePropPanel.this.curListIndex);
                            sequenceSource.setColor(DataSourcePropPanel.this.color);
                        }
                        colorChooserPopup.setVisible(false);
                    }
                });
                colorChooserPopup.show(DataSourcePropPanel.this.btnColor, 0, 0);
            }
        });
        this.cmbMarkStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataSourcePropPanel.this.curListIndex != -1) {
                    DefaultListModel defaultListModel = (DefaultListModel)DataSourcePropPanel.this.lstSources.getModel();
                    SequenceSource sequenceSource = (SequenceSource)defaultListModel.getElementAt(DataSourcePropPanel.this.curListIndex);
                    Integer n = (Integer)DataSourcePropPanel.this.cmbMarkStyle.getSelectedItem();
                    sequenceSource.setMarkStyle(n);
                }
            }
        });
        this.txtName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (DataSourcePropPanel.this.curListIndex != -1) {
                    DefaultListModel defaultListModel = (DefaultListModel)DataSourcePropPanel.this.lstSources.getModel();
                    SequenceSource sequenceSource = (SequenceSource)defaultListModel.getElementAt(DataSourcePropPanel.this.curListIndex);
                    sequenceSource.setName(DataSourcePropPanel.this.txtName.getText());
                }
            }
        });
    }

    public AbstractChartModel updateModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.lstSources.getModel();
        ArrayList arrayList = new ArrayList();
        int n = defaultListModel.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(defaultListModel.elementAt(i));
        }
        this.model.setDataSources(arrayList);
        return this.model;
    }

    public void setModel(AbstractChartModel abstractChartModel) {
        this.model = abstractChartModel;
        this.curListIndex = -1;
        DefaultListModel defaultListModel = (DefaultListModel)this.lstSources.getModel();
        defaultListModel.clear();
        ArrayList arrayList = abstractChartModel.getDataSources();
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultListModel.addElement(arrayList.get(i));
        }
        if (defaultListModel.size() > 0) {
            this.lstSources.setSelectedIndex(0);
        }
    }
}

