/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.data.dbf;

import anl.repast.gis.data.dbf.JDBFException;
import anl.repast.gis.data.dbf.JDBField;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class DBFReader {
    private DataInputStream stream = null;
    private JDBField[] fields = null;
    private byte[] nextRecord = null;

    public DBFReader(String string) throws JDBFException {
        try {
            this.init(new FileInputStream(string.trim()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDBFException(fileNotFoundException);
        }
    }

    public DBFReader(InputStream inputStream) throws JDBFException {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) throws JDBFException {
        try {
            this.stream = new DataInputStream(inputStream);
            int n = this.readHeader();
            this.fields = new JDBField[n];
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                this.fields[i] = this.readFieldHeader();
                n2 += this.fields[i].getLength();
            }
            if (this.stream.read() < 1) {
                throw new JDBFException("Unexpected end of file reached.");
            }
            this.nextRecord = new byte[n2];
            try {
                this.stream.readFully(this.nextRecord);
            }
            catch (EOFException eOFException) {
                this.nextRecord = null;
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            throw new JDBFException(iOException);
        }
    }

    private int readHeader() throws IOException, JDBFException {
        byte[] byArray = new byte[16];
        try {
            this.stream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new JDBFException("Unexpected end of file reached.");
        }
        int n = byArray[8];
        if (n < 0) {
            n += 256;
        }
        n += 256 * byArray[9];
        --n;
        n /= 32;
        --n;
        try {
            this.stream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new JDBFException("Unexpected end of file reached.");
        }
        return n;
    }

    private JDBField readFieldHeader() throws IOException, JDBFException {
        char c;
        byte[] byArray = new byte[16];
        try {
            this.stream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new JDBFException("Unexpected end of file reached.");
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        for (c = '\u0000'; c < '\n' && byArray[c] != 0; ++c) {
            stringBuffer.append((char)byArray[c]);
        }
        c = (char)byArray[11];
        try {
            this.stream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new JDBFException("Unexpected end of file reached.");
        }
        int n = byArray[0];
        int n2 = byArray[1];
        if (n < 0) {
            n += 256;
        }
        if (n2 < 0) {
            n2 += 256;
        }
        return new JDBField(stringBuffer.toString(), c, n, n2);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public JDBField getField(int n) {
        return this.fields[n];
    }

    public boolean hasNextRecord() {
        return this.nextRecord != null;
    }

    public Object[] nextRecord() throws JDBFException {
        if (!this.hasNextRecord()) {
            throw new JDBFException("No more records available.");
        }
        Object[] objectArray = new Object[this.fields.length];
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = this.fields[i].getLength();
            StringBuffer stringBuffer = new StringBuffer(n2);
            stringBuffer.append(new String(this.nextRecord, n, n2));
            objectArray[i] = this.fields[i].parse(stringBuffer.toString());
            n += this.fields[i].getLength();
        }
        try {
            this.stream.readFully(this.nextRecord);
        }
        catch (EOFException eOFException) {
            this.nextRecord = null;
        }
        catch (IOException iOException) {
            throw new JDBFException(iOException);
        }
        return objectArray;
    }
}

