/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloIntToIntFunction;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.yz;

class qc
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;
    protected IloIntToIntFunction _func;
    protected int _min;
    protected int _max;

    qc(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2, IloIntToIntFunction iloIntToIntFunction, int n2, int n3) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
        this._func = iloIntToIntFunction;
        this._min = n2;
        this._max = n3;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        kh kh2 = (kh)this._var1.getExtracted(ilcSolver);
        kh kh3 = (kh)this._var2.getExtracted(ilcSolver);
        return new an(kh2, kh3, this._func, this._min, this._max);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rangedSubsetEq(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(", ");
        stringBuffer.append(this._func);
        stringBuffer.append(", ");
        stringBuffer.append(this._min);
        stringBuffer.append(", ");
        stringBuffer.append(this._max);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSetVar iloIntSetVar = (IloIntSetVar)iloCopyManager.getCopy(this._var1);
        IloIntSetVar iloIntSetVar2 = (IloIntSetVar)iloCopyManager.getCopy(this._var2);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.rangedSubsetEq(iloIntSetVar, iloIntSetVar2, this._func, this._min, this._max);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
    }

    static final class an
    extends IlcPPropagator {
        final kh qbb;
        final kh rbb;
        final IloIntToIntFunction sbb;
        final int tbb;
        final int ubb;

        public an(kh kh2, kh kh3, IloIntToIntFunction iloIntToIntFunction, int n2, int n3) {
            this.qbb = kh2;
            this.rbb = kh3;
            this.sbb = iloIntToIntFunction;
            this.tbb = n2;
            this.ubb = n3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.qbb.whenDomain(ilcDemon);
            this.rbb.whenDomain(ilcDemon);
        }

        public void post() {
            this.qbb.getSolver().add(new yz.pm(this.qbb.getCardinality(), this.rbb.getCardinality()));
            this.qbb.whenDomain(new km());
            this.rbb.whenDomain(new ec());
        }

        public void propagate() {
            IlcIterator ilcIterator = this.qbb.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                int n3 = this.sbb.getValue(n2);
                if (!this.rbb.isDomainPossible(n2)) {
                    this.qbb.removeDomainPossible(n2);
                    continue;
                }
                if (n3 < this.tbb || n3 > this.ubb) {
                    this.qbb.removeDomainPossible(n2);
                    continue;
                }
                if (!this.qbb.isDomainRequired(n2)) continue;
                this.rbb.addDomainRequired(n2);
            }
        }

        public boolean isViolated() {
            IlcIterator ilcIterator = this.qbb.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                int n3 = this.sbb.getValue(n2);
                if (n3 >= this.tbb && n3 <= this.ubb && this.rbb.isDomainPossible(n2)) continue;
                return true;
            }
            return false;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rangedSubsetEq(");
            stringBuffer.append(this.qbb);
            stringBuffer.append(", ");
            stringBuffer.append(this.rbb);
            stringBuffer.append(", ");
            stringBuffer.append(this.sbb);
            stringBuffer.append(", ");
            stringBuffer.append(this.tbb);
            stringBuffer.append(", ");
            stringBuffer.append(this.ubb);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        final class ec
        extends IlcDemon {
            ec() {
            }

            public void propagate() {
                IlcIterator ilcIterator = an.this.rbb.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    an.this.qbb.removeDomainPossible(ilcIterator.nextValue());
                }
            }
        }

        final class km
        extends IlcDemon {
            km() {
            }

            public void propagate() {
                IlcIterator ilcIterator = an.this.qbb.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    int n2 = ilcIterator.nextValue();
                    int n3 = an.this.sbb.getValue(n2);
                    if (n3 < an.this.tbb || n3 > an.this.ubb) {
                        an.this.qbb.getSolver().fail();
                        continue;
                    }
                    an.this.rbb.addDomainRequired(n2);
                }
            }
        }
    }
}

