/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloObjectiveSense;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcObjective;
import ilog.solver.IlcSolver;
import ilog.solver.lab;
import ilog.solver.nm;
import ilog.solver.np;
import ilog.solver.rv;
import ilog.solver.wk;
import ilog.solver.ys;

final class pj
extends IlcObjective {
    private IlcNumExpr wu;
    private IloObjectiveSense xu;
    private double yu;

    pj(IloNumExpr iloNumExpr, IloObjectiveSense iloObjectiveSense, double d2, String string) {
        super(string);
        this.wu = (IlcNumExpr)iloNumExpr;
        this.xu = iloObjectiveSense;
        this.yu = d2;
    }

    public IloObjectiveSense getSense() {
        return this.xu;
    }

    public void setSense(IloObjectiveSense iloObjectiveSense) throws IloException {
        this.xu = iloObjectiveSense;
    }

    public IloNumExpr getExpr() throws IloException {
        return this.wu;
    }

    public void setExpr(IloNumExpr iloNumExpr) throws IloException {
        this.wu = (IlcNumExpr)iloNumExpr;
    }

    public void clearExpr() throws IloException {
        this.wu = null;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        if (this.wu instanceof IlcIntExpr) {
            ys ys2 = ((IlcIntExpr)this.wu).getPIntExp(ilcSolver);
            if (this.xu == IloObjectiveSense.Maximize) {
                return new np.nj(ys2, (int)this.yu);
            }
            return new wk.yr(ys2, (int)this.yu);
        }
        nm nm2 = this.wu.getPNumExp(ilcSolver);
        if (this.xu == IloObjectiveSense.Maximize) {
            return new lab.cz(nm2, this.yu);
        }
        return new rv.ss(nm2, this.yu);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcNumObjective:(");
        stringBuffer.append(this.xu);
        stringBuffer.append(",");
        stringBuffer.append(this.wu);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloNumExpr iloNumExpr = (IloNumExpr)iloCopyManager.getCopy(this.wu);
        if (this.xu == IloObjectiveSense.Maximize) {
            return iloCPModeler.maximize(iloNumExpr);
        }
        return iloCPModeler.minimize(iloNumExpr);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this.wu.needCopy(check);
    }
}

