/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.hg;
import ilog.solver.hy;
import ilog.solver.nm;

final class ml
extends hy {
    final nm[] xx;
    private double yx;
    private final int zx;
    private final int ay;

    public ml(nm[] nmArray, int n2, int n3) throws IlcSolverRuntimeError {
        this.xx = nmArray;
        this.zx = n2;
        this.ay = n3;
        int n4 = nmArray.length;
        if (n4 == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        int n5 = n2;
        while (n5 < n3) {
            nmArray[n5].isUsed(this);
            ++n5;
        }
    }

    public IlcSolver getSolver() {
        return this.xx[this.zx].getSolver();
    }

    protected hg[] getArgs() {
        if (this.zx == 0 && this.ay == this.xx.length) {
            return this.xx;
        }
        hg[] hgArray = new hg[this.ay - this.zx];
        System.arraycopy(this.xx, this.zx, hgArray, 0, this.ay - this.zx);
        return hgArray;
    }

    protected void computeRange() {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.zx;
        while (n2 < this.ay) {
            double d5 = this.xx[n2].getDomainLB();
            double d6 = this.xx[n2].getDomainUB();
            if (this.xx[n2].in()) {
                this.setNaN();
                this.yx = Double.POSITIVE_INFINITY;
                return;
            }
            d2 = IlcFloat.addDown(d2, d5);
            d3 = IlcFloat.addUp(d3, d6);
            double d7 = IlcFloat.addUp(d6, -d5);
            if (d4 < d7) {
                d4 = d7;
            }
            ++n2;
        }
        this.bzb = d2;
        this.czb = d3;
        this.yx = d4;
    }

    protected void setRangeInternal(double d2, double d3) {
        double d4 = IlcFloat.addUp(d2, -this.czb);
        double d5 = IlcFloat.addDown(d3, -this.bzb);
        if (this.yx > -d4 || this.yx > d5) {
            int n2 = this.zx;
            while (n2 < this.ay) {
                nm nm2 = this.xx[n2];
                double d6 = nm2.getDomainLB();
                double d7 = nm2.getDomainUB();
                double d8 = IlcFloat.addDown(d2, -IlcFloat.addUp(this.czb, -d7));
                double d9 = IlcFloat.addUp(d3, -IlcFloat.addDown(this.bzb, -d6));
                nm2.setDomainRange(d8, d9);
                ++n2;
            }
        }
    }

    public synchronized String toString() {
        if (this.vvb != null) {
            return this.vvb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sum([");
        int n2 = this.zx;
        while (n2 < this.ay - 1) {
            stringBuffer.append(this.xx[n2]);
            stringBuffer.append(", ");
            ++n2;
        }
        stringBuffer.append(this.xx[this.ay - 1]);
        stringBuffer.append("])");
        return stringBuffer.toString();
    }
}

