/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.hy;
import ilog.solver.nm;

class fc
extends hy {
    final nm le;
    final nm me;

    public fc(nm nm2, nm nm3) {
        this.le = nm2;
        this.me = nm3;
        nm2.isUsed(this);
        nm3.isUsed(this);
    }

    public final IlcSolver getSolver() {
        return this.le.getSolver();
    }

    protected hg[] getArgs() {
        return new hg[]{this.le, this.me};
    }

    protected void computeRange() {
        double d2 = this.le.getDomainLB();
        double d3 = this.le.getDomainUB();
        double d4 = this.me.getDomainLB();
        double d5 = this.me.getDomainUB();
        if (this.le.in() || this.me.in()) {
            this.setNaN();
        } else {
            double d6 = Double.POSITIVE_INFINITY;
            double d7 = Double.NEGATIVE_INFINITY;
            double d8 = d2 * d4;
            if (Double.isNaN(d8)) {
                d8 = 0.0;
            }
            if (d8 < d6) {
                d6 = d8;
            }
            if (d8 > d7) {
                d7 = d8;
            }
            if (Double.isNaN(d8 = d3 * d5)) {
                d8 = 0.0;
            }
            if (d8 < d6) {
                d6 = d8;
            }
            if (d8 > d7) {
                d7 = d8;
            }
            if (Double.isNaN(d8 = d2 * d5)) {
                d8 = 0.0;
            }
            if (d8 < d6) {
                d6 = d8;
            }
            if (d8 > d7) {
                d7 = d8;
            }
            if (Double.isNaN(d8 = d3 * d4)) {
                d8 = 0.0;
            }
            if (d8 < d6) {
                d6 = d8;
            }
            if (d8 > d7) {
                d7 = d8;
            }
            this.bzb = IlcFloat.roundDown(d6);
            this.czb = IlcFloat.roundUp(d7);
        }
    }

    protected void setRangeInternal(double d2, double d3) {
        if (0.0 < d2) {
            this.xc(d2, d3);
        } else if (d3 < 0.0) {
            this.wc(d2, d3);
        } else {
            this.yc(d2, d3);
        }
    }

    private void xc(double d2, double d3) {
        double d4 = this.le.getDomainLB();
        double d5 = this.le.getDomainUB();
        double d6 = this.me.getDomainLB();
        double d7 = this.me.getDomainUB();
        if (d4 == 0.0 && d5 == 0.0 || d6 == 0.0 && d7 == 0.0) {
            this.fail();
        } else {
            double d8;
            double d9;
            double d10 = d4;
            double d11 = d5;
            double d12 = d6;
            double d13 = d7;
            if (d4 >= 0.0) {
                d12 = IlcFloat.roundDown(d2 / d5);
                if (d4 > 0.0) {
                    d13 = IlcFloat.roundUp(d3 / d4);
                }
            } else if (d5 <= 0.0) {
                d13 = IlcFloat.roundUp(d2 / d4);
                if (d5 < 0.0) {
                    d12 = IlcFloat.roundDown(d3 / d5);
                }
            } else {
                d9 = IlcFloat.roundUp(d2 / d4);
                d8 = IlcFloat.roundDown(d2 / d5);
                if (d9 < d6) {
                    d12 = d8;
                }
                if (d7 < d8) {
                    d13 = d9;
                }
            }
            if (d6 >= 0.0) {
                d10 = IlcFloat.roundDown(d2 / d7);
                if (d6 > 0.0) {
                    d11 = IlcFloat.roundUp(d3 / d6);
                }
            } else if (d7 <= 0.0) {
                d11 = IlcFloat.roundUp(d2 / d6);
                if (d7 < 0.0) {
                    d10 = IlcFloat.roundDown(d3 / d7);
                }
            } else {
                d9 = IlcFloat.roundUp(d2 / d6);
                d8 = IlcFloat.roundDown(d2 / d7);
                if (d9 < d4) {
                    d10 = d8;
                }
                if (d5 < d8) {
                    d11 = d9;
                }
            }
            this.le.setDomainRange(d10, d11);
            this.me.setDomainRange(d12, d13);
        }
    }

    private void wc(double d2, double d3) {
        double d4 = this.le.getDomainLB();
        double d5 = this.le.getDomainUB();
        double d6 = this.me.getDomainLB();
        double d7 = this.me.getDomainUB();
        if (d4 == 0.0 && d5 == 0.0 || d6 == 0.0 && d7 == 0.0) {
            this.fail();
        } else {
            double d8;
            double d9;
            double d10 = d4;
            double d11 = d5;
            double d12 = d6;
            double d13 = d7;
            if (d4 >= 0.0) {
                d13 = IlcFloat.roundUp(d3 / d5);
                if (d4 > 0.0) {
                    d12 = IlcFloat.roundDown(d2 / d4);
                }
            } else if (d5 <= 0.0) {
                d12 = IlcFloat.roundDown(d3 / d4);
                if (d5 < 0.0) {
                    d13 = IlcFloat.roundUp(d2 / d5);
                }
            } else {
                d9 = IlcFloat.roundUp(d3 / d5);
                d8 = IlcFloat.roundDown(d3 / d4);
                if (d9 < d6) {
                    d12 = d8;
                }
                if (d7 < d8) {
                    d13 = d9;
                }
            }
            if (d6 >= 0.0) {
                d11 = IlcFloat.roundUp(d3 / d7);
                if (d6 > 0.0) {
                    d10 = IlcFloat.roundDown(d2 / d6);
                }
            } else if (d7 <= 0.0) {
                d10 = IlcFloat.roundDown(d3 / d6);
                if (d7 < 0.0) {
                    d11 = IlcFloat.roundUp(d2 / d7);
                }
            } else {
                d9 = IlcFloat.roundUp(d3 / d7);
                d8 = IlcFloat.roundDown(d3 / d6);
                if (d9 < d4) {
                    d10 = d8;
                }
                if (d5 < d8) {
                    d11 = d9;
                }
            }
            this.le.setDomainRange(d10, d11);
            this.me.setDomainRange(d12, d13);
        }
    }

    private void yc(double d2, double d3) {
        double d4 = this.le.getDomainLB();
        double d5 = this.le.getDomainUB();
        double d6 = this.me.getDomainLB();
        double d7 = this.me.getDomainUB();
        if (d4 > 0.0) {
            this.me.setDomainRange(IlcFloat.roundDown(d2 / d4), IlcFloat.roundUp(d3 / d4));
        } else if (d5 < 0.0) {
            this.me.setDomainRange(IlcFloat.roundDown(d3 / d5), IlcFloat.roundUp(d2 / d5));
        }
        if (d6 > 0.0) {
            this.le.setDomainRange(IlcFloat.roundDown(d2 / d6), IlcFloat.roundUp(d3 / d6));
        } else if (d7 < 0.0) {
            this.le.setDomainRange(IlcFloat.roundDown(d3 / d7), IlcFloat.roundUp(d2 / d7));
        }
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.le);
        stringBuffer.append(" * ");
        stringBuffer.append(this.me);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

