/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloImply;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kf;
import ilog.solver.vg;

public final class IlcIfThen
extends IlcConstraint
implements IloImply {
    protected IlcConstraint _left = null;
    protected IlcConstraint _right = null;

    IlcIfThen(IloConstraint iloConstraint, IloConstraint iloConstraint2) {
        this._left = (IlcConstraint)iloConstraint;
        this._right = (IlcConstraint)iloConstraint2;
    }

    public IloConstraint getCondition() {
        return this._left;
    }

    public IloConstraint getConsequence() {
        return this._right;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        IlcPPropagator ilcPPropagator = this._left.getPropagator(ilcSolver);
        if (ilcPPropagator.isViolated()) {
            return new kf(ilcSolver);
        }
        IlcPPropagator ilcPPropagator2 = ilcPPropagator.getOpposite();
        IlcPPropagator ilcPPropagator3 = this._right.getPropagator(ilcSolver);
        if (ilcPPropagator2.isViolated()) {
            return ilcPPropagator3;
        }
        if (ilcPPropagator3.isViolated()) {
            return ilcPPropagator2;
        }
        return new vg.co(ilcSolver, ilcPPropagator2, ilcPPropagator3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("imply(");
        stringBuffer.append(this._left);
        stringBuffer.append(", ");
        stringBuffer.append(this._right);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.imply((IloConstraint)iloCopyManager.getCopy(this._left), (IloConstraint)iloCopyManager.getCopy(this._right));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._left.needCopy(check);
        this._right.needCopy(check);
    }
}

