/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolverRuntimeError;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class IlcFloat {
    static final double yt = Double.longBitsToDouble(1L);
    static final double zt = -yt;
    static final double au = Double.longBitsToDouble(0xFFFFFFFFFFFFFL);
    static final double bu = -au;
    static final double cu = Double.longBitsToDouble(0x10000000000000L);
    static final double du = -cu;
    static final double eu = Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL);
    static final double fu = -eu;
    static final double gu = Double.longBitsToDouble(0x7FF0000000000000L);
    static final double hu = -gu;
    static final double iu = Double.longBitsToDouble(Double.doubleToLongBits(1.0) + 1L);
    static final double ju = Double.longBitsToDouble(Double.doubleToLongBits(1.0) - 1L);

    IlcFloat() {
    }

    public static final double addDown(double d2, double d3) {
        double d4 = d2 + d3;
        if (d2 == 0.0 || d3 == 0.0) {
            return d4;
        }
        return IlcFloat.roundDown(d4);
    }

    public static final double addUp(double d2, double d3) {
        double d4 = d2 + d3;
        if (d2 == 0.0 || d3 == 0.0) {
            return d4;
        }
        return IlcFloat.roundUp(d4);
    }

    public static final double roundUp(double d2) {
        return IlcFloat.roundUpBits(d2);
    }

    public static final double roundDown(double d2) {
        return IlcFloat.roundDownBits(d2);
    }

    public static final double roundUpSimpleBits(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        if (d2 >= 0.0) {
            if (Double.isInfinite(d2)) {
                return d2;
            }
            return Double.longBitsToDouble((l2 & Long.MAX_VALUE) + 1L);
        }
        return Double.longBitsToDouble(l2 - 1L);
    }

    public static final double roundDownSimpleBits(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        if (d2 <= 0.0) {
            if (Double.isInfinite(d2)) {
                return d2;
            }
            return Double.longBitsToDouble((l2 | Long.MIN_VALUE) + 1L);
        }
        return Double.longBitsToDouble(l2 - 1L);
    }

    public static final double roundUpBits(double d2) {
        if (d2 == 0.0) {
            return yt;
        }
        if (d2 < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        if (!Double.isInfinite(d2)) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
        }
        return d2;
    }

    public static final double roundDownBits(double d2) {
        if (d2 == 0.0) {
            return zt;
        }
        if (d2 > 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        if (!Double.isInfinite(d2)) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
        }
        return d2;
    }

    public static final double roundUpMult(double d2) {
        if (d2 >= cu) {
            return d2 * iu;
        }
        if (d2 <= du) {
            if (d2 == hu) {
                return fu;
            }
            return d2 * ju;
        }
        if (d2 == 0.0) {
            return yt;
        }
        if (d2 < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
    }

    public static final double roundDownMult(double d2) {
        if (d2 <= du) {
            return d2 * iu;
        }
        if (d2 >= cu) {
            if (d2 == gu) {
                return eu;
            }
            return d2 * ju;
        }
        if (d2 == 0.0) {
            return zt;
        }
        if (d2 > 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
    }

    public static final double roundUpSimpleMult(double d2) {
        return d2 >= 0.0 ? d2 * iu + yt : d2 * ju + yt;
    }

    public static final double roundDownSimpleMult(double d2) {
        return d2 >= 0.0 ? d2 * ju + zt : d2 * iu + zt;
    }

    public static final synchronized String toString_Up(double d2) {
        BigDecimal bigDecimal;
        if (Double.isInfinite(d2)) {
            return Double.toString(d2);
        }
        if (Double.isNaN(d2)) {
            return Double.toString(d2);
        }
        String string = Double.toString(d2);
        BigDecimal bigDecimal2 = new BigDecimal(string);
        if (bigDecimal2.compareTo(bigDecimal = new BigDecimal(d2)) >= 0) {
            return string;
        }
        return Double.toString(IlcFloat.roundUp(d2));
    }

    public static final synchronized String toString_Down(double d2) {
        BigDecimal bigDecimal;
        if (Double.isInfinite(d2)) {
            return Double.toString(d2);
        }
        if (Double.isNaN(d2)) {
            return Double.toString(d2);
        }
        String string = Double.toString(d2);
        BigDecimal bigDecimal2 = new BigDecimal(string);
        if (bigDecimal2.compareTo(bigDecimal = new BigDecimal(d2)) <= 0) {
            return string;
        }
        return Double.toString(IlcFloat.roundDown(d2));
    }

    public static final synchronized String getBit(long l2, int n2) {
        if ((l2 & 1L << n2 - 1) != 0L) {
            return "1";
        }
        return "0";
    }

    public static final synchronized String toString_IEEE(double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = Double.doubleToLongBits(d2);
        stringBuffer.append(IlcFloat.getBit(l2, 64));
        stringBuffer.append("s");
        int n2 = 63;
        while (n2 >= 53) {
            stringBuffer.append(IlcFloat.getBit(l2, n2));
            --n2;
        }
        stringBuffer.append("e");
        int n3 = 52;
        while (n3 >= 1) {
            stringBuffer.append(IlcFloat.getBit(l2, n3));
            --n3;
        }
        stringBuffer.append("m");
        return stringBuffer.toString();
    }

    public static final synchronized String toBitString(long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 64;
        while (n2 >= 1) {
            stringBuffer.append(IlcFloat.getBit(l2, n2));
            --n2;
        }
        return stringBuffer.toString();
    }

    public static final synchronized String toString_exact(double d2) {
        if (Double.isInfinite(d2)) {
            return Double.toString(d2);
        }
        if (Double.isNaN(d2)) {
            return Double.toString(d2);
        }
        BigDecimal bigDecimal = new BigDecimal(d2);
        return bigDecimal.toString();
    }

    public static final synchronized String toString_roundDown(double d2, int n2) {
        if (d2 >= 0.0) {
            return IlcFloat.toString_rounded("", Math.abs(d2), n2, 3);
        }
        return IlcFloat.toString_rounded("-", Math.abs(d2), n2, 2);
    }

    public static final synchronized String toString_roundUp(double d2, int n2) {
        if (d2 >= 0.0) {
            return IlcFloat.toString_rounded("", Math.abs(d2), n2, 2);
        }
        return IlcFloat.toString_rounded("-", Math.abs(d2), n2, 3);
    }

    public static final synchronized String toString_rounded(String string, double d2, int n2, int n3) {
        Object object;
        Object object2;
        if (Double.isInfinite(d2)) {
            return Double.toString(d2);
        }
        if (Double.isNaN(d2)) {
            return Double.toString(d2);
        }
        if (d2 == 0.0) {
            String string2 = "0.";
            int n4 = 0;
            while (n4 < n2 - 1) {
                string2 = string2 + "0";
                ++n4;
            }
            return string2 + "e0";
        }
        BigDecimal bigDecimal = new BigDecimal(Math.abs(d2));
        int n5 = bigDecimal.unscaledValue().toString().length();
        int n6 = bigDecimal.scale() + (n2 - n5);
        if (n6 >= 0) {
            if ((bigDecimal = bigDecimal.setScale(n6, n3)).unscaledValue().toString().length() == n2 + 1) {
                bigDecimal = bigDecimal.setScale(n6 - 1, n3);
            }
        } else {
            object2 = new BigInteger("10");
            bigDecimal = bigDecimal.setScale(0, n3);
            object = new BigDecimal(((BigInteger)object2).pow(-n6));
            bigDecimal = bigDecimal.divide((BigDecimal)object, n3).multiply((BigDecimal)object);
        }
        object2 = bigDecimal.unscaledValue().toString();
        object = Integer.toString(-bigDecimal.scale() + ((String)object2).length() - 1);
        return string + ((String)object2).substring(0, 1) + "." + ((String)object2).substring(1, n2) + "e" + (String)object;
    }

    public static final int bitPrecision(int n2) {
        return (int)Math.ceil(Math.log(10.0) / Math.log(2.0) * (double)n2) + 1;
    }

    public static final int digitPrecision(int n2) {
        int[] nArray = new int[]{1, 5, 8, 11, 15, 18, 21, 25, 28, 31, 35, 38, 41, 45, 48, 51};
        int n3 = 15;
        while (n3 >= 0) {
            if (nArray[n3] <= n2) {
                return n3;
            }
            --n3;
        }
        throw new IlcSolverRuntimeError.hbb("Unknown bit precision.");
    }

    public static final long mapDoubleToLong(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        if (d2 >= 0.0) {
            return l2 & Long.MAX_VALUE;
        }
        return l2 - 1L & Long.MAX_VALUE ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static final double mapLongToDouble(long l2) {
        if (l2 >= 0L) {
            return Double.longBitsToDouble(l2);
        }
        return Double.longBitsToDouble((l2 ^ 0xFFFFFFFFFFFFFFFFL) + 1L | Long.MIN_VALUE);
    }

    public static final double nextUp(double d2, int n2, int n3) {
        return IlcFloat.castUp(IlcFloat.roundUp(d2), n2, n3);
    }

    public static final double nextDown(double d2, int n2, int n3) {
        return IlcFloat.castDown(IlcFloat.roundDown(d2), n2, n3);
    }

    public static final boolean isBound(double d2, double d3, int n2, int n3) {
        return IlcFloat.castUp(IlcFloat.roundUp(d2), n2, n3) >= IlcFloat.castDown(IlcFloat.roundDown(d3), n2, n3);
    }

    public static final boolean isBoundRel(double d2, double d3, int n2) {
        int n3 = 52 - n2;
        long l2 = IlcFloat.mapDoubleToLong(d2);
        long l3 = IlcFloat.mapDoubleToLong(d3);
        return l3 - (1L << n3) <= l2;
    }

    public static final boolean isBoundAbs(double d2, double d3, int n2) {
        double d4 = Double.longBitsToDouble(1023L - (long)n2 << 52);
        return d3 / d4 <= 1.0 + d2 / d4;
    }

    public static final double castUp(double d2, int n2, int n3) {
        double d3 = Double.longBitsToDouble(1023L + (long)(n2 - n3) << 52);
        if (Math.abs(d2) > d3) {
            return IlcFloat.castUpRel(d2, n2);
        }
        return IlcFloat.castUpAbs(d2, n3);
    }

    public static final double castDown(double d2, int n2, int n3) {
        double d3 = Double.longBitsToDouble(1023L + (long)(n2 - n3) << 52);
        if (Math.abs(d2) > d3) {
            return IlcFloat.castDownRel(d2, n2);
        }
        return IlcFloat.castDownAbs(d2, n3);
    }

    public static final double castUpRel(double d2, int n2) {
        long l2;
        int n3 = 52 - n2;
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = l3 & -1L << n3) || d2 < 0.0) {
            return Double.longBitsToDouble(l2);
        }
        if (d2 < Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL & -1L << n3)) {
            return Double.longBitsToDouble(l2 + (1L << n3));
        }
        return gu;
    }

    public static final double castDownRel(double d2, int n2) {
        long l2;
        int n3 = 52 - n2;
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = l3 & -1L << n3) || 0.0 < d2) {
            return Double.longBitsToDouble(l2);
        }
        if (-Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL & -1L << n3) < d2) {
            return Double.longBitsToDouble(l2 + (1L << n3));
        }
        return hu;
    }

    public static final double castUpAbs(double d2, int n2) {
        double d3 = Double.longBitsToDouble(1023L - (long)n2 << 52);
        double d4 = d2 / d3;
        if (Double.isInfinite(d4)) {
            return d2;
        }
        return d3 * Math.ceil(d4);
    }

    public static final double castDownAbs(double d2, int n2) {
        double d3 = Double.longBitsToDouble(1023L - (long)n2 << 52);
        double d4 = d2 / d3;
        if (Double.isInfinite(d4)) {
            return d2;
        }
        return d3 * Math.floor(d4);
    }

    public static final double logDown(double d2) {
        if (d2 == 1.0) {
            return 0.0;
        }
        return IlcFloat.roundDown(Math.log(d2));
    }

    public static final double logUp(double d2) {
        if (d2 == 1.0) {
            return 0.0;
        }
        if (d2 == gu) {
            return gu;
        }
        return IlcFloat.roundUp(Math.log(d2));
    }

    public static final double expDown(double d2) {
        if (d2 == hu) {
            return 0.0;
        }
        return IlcFloat.roundDown(Math.exp(d2));
    }

    public static final double expUp(double d2) {
        if (d2 == gu) {
            return gu;
        }
        return IlcFloat.roundUp(Math.exp(d2));
    }

    public static final double sqrtDown(double d2) {
        if (d2 == 0.0 || d2 == 1.0) {
            return d2;
        }
        return IlcFloat.roundDown(Math.sqrt(d2));
    }

    public static final double sqrtUp(double d2) {
        if (d2 == 0.0 || d2 == 1.0 || d2 == gu) {
            return d2;
        }
        return IlcFloat.roundUp(Math.sqrt(d2));
    }

    public static final double posPowerDown(double d2, double d3) {
        if (d2 == 0.0 || d2 == 1.0) {
            return d2;
        }
        return IlcFloat.roundDown(Math.pow(d2, d3));
    }

    public static final double posPowerUp(double d2, double d3) {
        if (d2 == 0.0 || d2 == 1.0 || d2 == gu) {
            return d2;
        }
        return IlcFloat.roundUp(Math.pow(d2, d3));
    }

    public static final double posPowerDown(double d2, double d3, double d4) {
        if (d2 == 0.0 || d2 == 1.0) {
            return d2;
        }
        if (d2 < 1.0) {
            return IlcFloat.roundDown(Math.pow(d2, d4));
        }
        return IlcFloat.roundDown(Math.pow(d2, d3));
    }

    public static final double posPowerUp(double d2, double d3, double d4) {
        if (d2 == 0.0 || d2 == 1.0) {
            return d2;
        }
        if (d2 < 1.0) {
            return IlcFloat.roundUp(Math.pow(d2, d3));
        }
        return IlcFloat.roundUp(Math.pow(d2, d4));
    }

    public static final double posDivDown(double d2, double d3) {
        if (d3 == gu) {
            return 0.0;
        }
        return IlcFloat.roundDown(d2 / d3);
    }

    public static final double discountedSumUp(double d2, int n2, int n3) {
        if (n2 <= 0) {
            return 0.0;
        }
        double d3 = IlcFloat.roundUp(Math.pow(IlcFloat.roundUp(1.0 / IlcFloat.roundDown(1.0 + d2)), IlcFloat.roundDown(1.0 / (double)n2)));
        if (d3 >= 1.0) {
            return n2;
        }
        double d4 = Math.min((double)n2, IlcFloat.roundUp(IlcFloat.roundUp(1.0 - IlcFloat.roundDown(Math.pow(d3, n2))) / IlcFloat.roundDown(1.0 - d3)));
        return n3 == 0 ? IlcFloat.roundUp(d3 * d4) : d4;
    }

    public static final double discountedSumDown(double d2, int n2, int n3) {
        if (n2 <= 0) {
            return 0.0;
        }
        if (d2 <= 0.0) {
            return n2;
        }
        double d3 = IlcFloat.roundDown(Math.pow(IlcFloat.roundDown(1.0 / IlcFloat.roundUp(1.0 + d2)), IlcFloat.roundUp(1.0 / (double)n2)));
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = IlcFloat.roundDown(IlcFloat.roundDown(1.0 - IlcFloat.roundUp(Math.pow(d3, n2))) / IlcFloat.roundUp(1.0 - d3));
        if (d3 > 0.999) {
            d4 = Math.max(IlcFloat.roundDown((double)n2 - IlcFloat.roundUp((double)(n2 * (n2 - 1) / 2) * IlcFloat.roundUp(1.0 - d3))), d4);
        }
        return n3 == 0 ? IlcFloat.roundDown(d3 * d4) : d4;
    }

    public static final double discountedSumDerivUp(double d2, int n2, int n3) {
        double d3;
        if (n2 <= 0) {
            return 0.0;
        }
        double d4 = IlcFloat.roundDown(Math.pow(IlcFloat.roundDown(1.0 / IlcFloat.roundUp(1.0 + d2)), IlcFloat.roundUp(1.0 / (double)n2)));
        double d5 = IlcFloat.roundUp(Math.pow(IlcFloat.roundUp(1.0 / IlcFloat.roundDown(1.0 + d2)), IlcFloat.roundDown(1.0 / (double)n2)));
        if (d5 >= 1.0) {
            return n3 == 0 ? IlcFloat.roundUp(1.0 + IlcFloat.roundUp((double)(n2 - 1) / 2.0)) : IlcFloat.roundUp((double)(n2 - 1) / 2.0);
        }
        double d6 = IlcFloat.roundUp(1.0 - d4);
        double d7 = IlcFloat.roundDown(1.0 - d5);
        double d8 = IlcFloat.roundDown(d7 * d7);
        if (d6 == 0.0 || d7 == 0.0 || d8 == 0.0) {
            return n3 == 0 ? IlcFloat.roundUp(d5 * IlcFloat.roundUp(1.0 + IlcFloat.roundUp(IlcFloat.roundUp(d5 * (double)(n2 - 1)) / 2.0))) : IlcFloat.roundUp(d5 * IlcFloat.roundUp((double)(n2 - 1) / 2.0));
        }
        double d9 = IlcFloat.roundDown((double)n2 * IlcFloat.roundDown(Math.pow(d4, n2 - 1)) / d6);
        double d10 = IlcFloat.roundUp(1.0 - IlcFloat.roundDown(Math.pow(d4, n2)));
        double d11 = IlcFloat.roundUp(d10 / d8);
        double d12 = IlcFloat.roundUp(d5 * IlcFloat.roundUp(IlcFloat.roundUp(-d9 + d11) / (double)n2));
        if (n3 == 0) {
            double d13 = IlcFloat.roundUp(d10 / d7);
            double d14 = IlcFloat.roundUp(d5 * IlcFloat.roundUp(d13 / (double)n2));
            d3 = IlcFloat.roundUp(d14 + IlcFloat.roundUp(d5 * d12));
            if (d5 >= 0.999) {
                double d15 = IlcFloat.roundUp(d5 * IlcFloat.roundUp(1.0 + IlcFloat.roundUp(IlcFloat.roundUp(d5 * (double)(n2 - 1)) / 2.0)));
                d3 = Math.min(d3, d15);
            }
        } else {
            d3 = d12;
            if (d5 >= 0.999) {
                double d16 = IlcFloat.roundUp(d5 * IlcFloat.roundUp((double)(n2 - 1) / 2.0));
                d3 = Math.min(d3, d16);
            }
        }
        return d3;
    }

    public static final double discountedFactorUp(double d2) {
        return IlcFloat.roundUp(1.0 / IlcFloat.roundDown(1.0 + d2));
    }

    public static final double discountedFactorDown(double d2) {
        return IlcFloat.roundDown(1.0 / IlcFloat.roundUp(1.0 + d2));
    }
}

