/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloAnyExpr;
import ilog.concert.IloException;
import ilog.concert.IloIntEncoder;
import ilog.solver.IlcAnyIterator;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcExtractable;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.oab;
import ilog.solver.ys;
import java.util.Iterator;

public abstract class IlcAnyExpr
extends IlcExtractable
implements IloAnyExpr {
    protected ys _extracted;

    protected IlcAnyExpr() {
    }

    public final ys getPIntExp(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        if (this._extracted instanceof oab) {
            ilcSolver.registerExtracted(this);
            try {
                this._extracted = (ys)this.extract(ilcSolver);
            }
            catch (IloException iloException) {
                throw new IlcSolverRuntimeError.Extraction(iloException.getMessage(), iloException);
            }
        }
        return this._extracted;
    }

    public final Object getExtracted(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        return this.getPIntExp(ilcSolver);
    }

    public void resetExtracted(IlcSolver ilcSolver) {
        this._extracted = new oab(this, ilcSolver);
    }

    public IlcSolver getSolver() {
        return this._extracted.getSolver();
    }

    public IloIntEncoder getIntEncoder() {
        return this.getSolver().getIntEncoder();
    }

    public Object getDomainValue() throws IlcSolverRuntimeError {
        return this.getIntEncoder().intToObject(this._extracted.getDomainValue());
    }

    public boolean isBound() {
        return this._extracted.isBound();
    }

    public void setDomainValue(Object object) {
        this._extracted.setDomainValue(this.getIntEncoder().objectToInt(object));
    }

    public void removeDomainValue(Object object) {
        this._extracted.removeDomainValue(this.getIntEncoder().objectToInt(object));
    }

    public Iterator domainIterator() {
        return new IlcAnyIterator(this._extracted.domainIterator(), this.getIntEncoder());
    }

    public void whenValue(IlcDemon ilcDemon) {
        this._extracted.whenValue(ilcDemon);
    }

    public void whenDomain(IlcDemon ilcDemon) {
        this._extracted.whenDomain(ilcDemon);
    }

    public void whenValue(IlcConstraint ilcConstraint) {
        this._extracted.whenValue(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void whenDomain(IlcConstraint ilcConstraint) {
        this._extracted.whenDomain(ilcConstraint.getPropagator(this.getSolver()));
    }

    public int getDomainSize() {
        return this._extracted.getDomainSize();
    }

    public int getNbOfConstraints() {
        return this._extracted.getNbOfConstraints();
    }

    public boolean hasDomain() {
        return this._extracted.jn();
    }

    public void createDomain() {
        this._extracted.kn();
    }

    public boolean isInDomain(Object object) {
        return this._extracted.isInDomain(this.getIntEncoder().objectToInt(object));
    }

    public Iterator removedIterator() {
        return new IlcAnyIterator(this._extracted.removedIterator(), this.getIntEncoder());
    }

    public Iterator deltaIterator() {
        return new IlcAnyIterator(this._extracted.deltaIterator(), this.getIntEncoder());
    }
}

