/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert.model;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDomain;
import ilog.concert.IloException;
import ilog.concert.IloIntDomain;
import ilog.concert.IloSolverException;
import ilog.concert.model.IlcDomain;
import java.util.Arrays;

public class IlcIntDomain
extends IlcDomain
implements IloIntDomain {
    private int shb = -2147483647;
    private int thb = Integer.MAX_VALUE;
    private int[] uhb = null;

    public int getSize() {
        return this.uhb == null ? (int)Math.min((long)this.thb - (long)this.shb + 1L, Integer.MAX_VALUE) : this.uhb.length;
    }

    public int getMin() {
        return this.shb;
    }

    public void setMin(int n2) throws IloException {
        if (this.uhb == null) {
            this.shb = n2 == Integer.MIN_VALUE ? -2147483647 : n2;
        } else {
            throw new IloSolverException.DomainWrongMode();
        }
    }

    public int getMax() {
        return this.thb;
    }

    public void setMax(int n2) throws IloException {
        if (this.uhb == null) {
            if (n2 == Integer.MIN_VALUE) {
                throw new IloException("Declaring invalid integer interval domain.");
            }
        } else {
            throw new IloSolverException.DomainWrongMode();
        }
        this.thb = n2;
    }

    public int[] getValues() {
        return this.uhb;
    }

    protected IlcIntDomain() {
    }

    public boolean includes(IloDomain iloDomain) throws IloException {
        int[] nArray;
        IloIntDomain iloIntDomain = (IloIntDomain)iloDomain;
        if (this.shb > iloIntDomain.getMin() || this.thb < iloIntDomain.getMax()) {
            return false;
        }
        if (this.uhb != null && (nArray = iloIntDomain.getValues()) != null) {
            int n2 = this.uhb.length;
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = nArray[n4];
                boolean bl2 = false;
                int n6 = 0;
                while (n6 < n2) {
                    if (this.uhb[n6] == n5) {
                        bl2 = true;
                        break;
                    }
                    ++n6;
                }
                if (!bl2) {
                    return false;
                }
                ++n4;
            }
        }
        return true;
    }

    public IlcIntDomain(int n2, int n3) throws IloException {
        if (n2 > n3 || n3 == Integer.MIN_VALUE) {
            throw new IloException("Declare invalid integer interval domain");
        }
        this.shb = Math.max(n2, -2147483647);
        this.thb = n3;
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        if (this.uhb == null) {
            return iloCPModeler.intDomain(this.shb, this.thb);
        }
        return iloCPModeler.intDomain(this.uhb);
    }

    public void setValues(int[] nArray) throws IloException {
        if (nArray == null) {
            throw new IloException("Declare an empty integer domain.");
        }
        int n2 = nArray.length;
        if (n2 > 1) {
            int[] nArray2 = (int[])nArray.clone();
            Arrays.sort(nArray2);
            int n3 = 1;
            int n4 = nArray2[0];
            int n5 = 1;
            while (n5 < n2) {
                if (nArray2[n5] != n4) {
                    nArray2[n3] = n4 = nArray2[n5];
                    ++n3;
                }
                ++n5;
            }
            if (n3 < n2) {
                nArray = new int[n3];
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n6] = nArray2[n6];
                    ++n6;
                }
            } else {
                nArray = nArray2;
            }
        }
        this.dq(nArray);
    }

    void dq(int[] nArray) throws IloException {
        if (nArray.length == 0) {
            throw new IloException("Declare an empty integer domain.");
        }
        int n2 = nArray.length;
        if (n2 == 0) {
            this.shb = Integer.MAX_VALUE;
            this.thb = -2147483647;
        } else {
            if (nArray[0] == Integer.MIN_VALUE) {
                throw new IloException("Invalid domain element of integer domain: " + nArray[0]);
            }
            this.shb = nArray[0];
            this.thb = nArray[n2 - 1];
        }
        this.uhb = nArray;
    }

    public IlcIntDomain(int[] nArray) throws IloException {
        this.setValues(nArray);
    }

    public String printType() {
        return "int";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.uhb != null) {
            int n2 = 0;
            while (n2 < this.uhb.length - 1) {
                stringBuffer.append(this.uhb[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
            if (this.uhb.length > 0) {
                stringBuffer.append(this.uhb[this.uhb.length - 1]);
            }
        } else {
            stringBuffer.append(this.shb);
            if (this.shb != this.thb) {
                stringBuffer.append("..");
                stringBuffer.append(this.thb);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setValue(int n2) throws IloException {
        if (this.uhb == null) {
            if (n2 == Integer.MIN_VALUE) {
                throw new IloException("Declaring invalid integer interval domain: " + n2);
            }
            this.shb = n2;
            this.thb = n2;
        } else {
            this.dq(new int[]{n2});
        }
    }

    public void removeValue(int n2) throws IloException {
        int[] nArray;
        boolean bl2 = false;
        if (this.uhb == null) {
            if (n2 < this.shb || this.thb < n2) {
                return;
            }
            if (this.shb == n2) {
                ++this.shb;
                return;
            }
            if (this.thb == n2) {
                --this.thb;
                return;
            }
            if (Integer.MAX_VALUE == this.getSize()) {
                throw new IloException("IlcIntDomain: Out of Memory.");
            }
            int n3 = this.thb - this.shb;
            nArray = new int[n3];
            int n4 = 0;
            int n5 = this.shb;
            while (n5 < n2) {
                nArray[n4++] = n5++;
            }
            int n6 = n2 + 1;
            while (n6 <= this.thb) {
                nArray[n4++] = n6++;
            }
            bl2 = true;
        } else {
            nArray = new int[this.uhb.length - 1];
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.uhb.length) {
                int n9 = this.uhb[n8];
                if (n9 != n2) {
                    if (n7 < nArray.length) {
                        nArray[n7++] = n9;
                    }
                } else {
                    bl2 = true;
                }
                ++n8;
            }
        }
        if (bl2) {
            this.dq(nArray);
        }
    }

    public void setRange(int n2, int n3) throws IloException {
        if (n2 != this.shb) {
            this.setMin(n2);
        }
        if (n3 != this.thb) {
            this.setMax(n3);
        }
    }

    public void removeInterval(int n2, int n3) throws IloException {
        if (n2 > n3) {
            return;
        }
        if (n2 == n3) {
            this.removeValue(n2);
            return;
        }
        if (this.uhb == null) {
            if (n3 < this.shb || n2 > this.thb) {
                return;
            }
            if (n2 <= this.shb && this.thb <= n3) {
                this.dq(new int[0]);
                return;
            }
            if (n2 <= this.shb) {
                this.shb = n3 + 1;
                return;
            }
            if (n3 >= this.thb) {
                this.thb = n2 - 1;
                return;
            }
            int n4 = n2 - this.shb + (this.thb - n3);
            int[] nArray = new int[n4];
            int n5 = 0;
            int n6 = this.shb;
            while (n6 < n2) {
                nArray[n5++] = n6++;
            }
            int n7 = n3 + 1;
            while (n7 <= this.thb) {
                nArray[n5++] = n7++;
            }
            this.dq(nArray);
            return;
        }
        int n8 = this.uhb.length;
        int n9 = 0;
        while (n9 < this.uhb.length) {
            if (n2 <= this.uhb[n9] && this.uhb[n9] <= n3) {
                --n8;
            }
            ++n9;
        }
        if (n8 < this.uhb.length) {
            int[] nArray = new int[n8];
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.uhb.length) {
                int n12 = this.uhb[n11];
                if (n12 < n2 || n3 < n12) {
                    nArray[n10++] = n12;
                }
                ++n11;
            }
            this.dq(nArray);
        }
    }
}

