/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplet;
import ptolemy.plot.compat.PxgraphParser;

public class PxgraphApplet
extends PlotApplet {
    private PxgraphParser _parser;

    protected void _read(InputStream inputStream) throws IOException {
        this._parser.read(inputStream);
    }

    public String getAppletInfo() {
        return "PxgraphApplet 3.1: A data plotter.\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n Christopher Hylands, cxh@eecs.berkeley.edu\n($Id: PxgraphApplet.java,v 1.5 1999/08/20 02:14:56 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"pxgraphargs", "args", "pxgraph style command line arguments"}};
        return stringArray;
    }

    public void init() {
        super.init();
        this._parser = new PxgraphParser((Plot)this.plot());
        String string = null;
        string = this.getParameter("pxgraphargs");
        if (string != null) {
            try {
                this.showStatus("Reading arguments");
                this._parser.parsePxgraphargs(string, this.getDocumentBase());
                this.showStatus("Done reading arguments");
            }
            catch (CmdLineArgException cmdLineArgException) {
                System.err.println("PxgraphApplet: failed to parse `" + string + "': " + cmdLineArgException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
        }
        this.plot().repaint();
    }
}

