/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloIntSetVar;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.vh;
import ilog.solver.ys;
import ilog.solver.zm;

class xab
extends IlcConstraint {
    protected IlcIntExpr _var;
    protected IlcIntSetVar _setVar;

    xab(IloIntExpr iloIntExpr, IloIntSetVar iloIntSetVar) {
        this._var = (IlcIntExpr)iloIntExpr;
        this._setVar = (IlcIntSetVar)iloIntSetVar;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ys ys2 = this._var.getPIntExp(ilcSolver);
        kh kh2 = (kh)this._setVar.getExtracted(ilcSolver);
        return new ts(ys2, kh2);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("member(");
        stringBuffer.append(this._var);
        stringBuffer.append(", ");
        stringBuffer.append(this._setVar);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.member((IloIntExpr)iloCopyManager.getCopy(this._var), (IloIntSetVar)iloCopyManager.getCopy(this._setVar));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var.needCopy(check);
        this._setVar.needCopy(check);
    }

    static final class ts
    extends IlcPPropagator {
        final ys zmb;
        final kh anb;

        public ts(ys ys2, kh kh2) {
            this.zmb = ys2;
            this.anb = kh2;
            ys2.kn();
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.anb.whenDomain(ilcDemon);
            this.zmb.whenValue(ilcDemon);
        }

        public void post() {
            this.zmb.getSolver().add(new vh.dh(this.anb.getCardinality(), 1));
            gk gk2 = new gk();
            this.zmb.whenValue(gk2);
            this.anb.whenDomain(gk2);
        }

        public void propagate() {
            IlcIterator ilcIterator = this.zmb.domainIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                if (this.anb.isDomainPossible(n2)) continue;
                this.zmb.removeDomainValue(n2);
            }
            if (this.zmb.isBound()) {
                this.anb.addDomainRequired(this.zmb.getDomainMin());
            }
        }

        public boolean isViolated() {
            IlcIterator ilcIterator = this.zmb.domainIterator();
            while (ilcIterator.hasNext()) {
                if (!this.anb.isDomainPossible(ilcIterator.nextValue())) continue;
                return false;
            }
            return true;
        }

        public IlcPPropagator makeOpposite() {
            return new zm.fw(this.zmb, this.anb);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.zmb);
            stringBuffer.append(" in ");
            stringBuffer.append(this.anb);
            return stringBuffer.toString();
        }

        final class gk
        extends IlcDemon {
            gk() {
            }

            public void propagate() {
                if (ts.this.zmb.isBound()) {
                    ts.this.anb.addDomainRequired(ts.this.zmb.getDomainMin());
                    return;
                }
                IlcIterator ilcIterator = ts.this.anb.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    ts.this.zmb.removeDomainValue(ilcIterator.nextValue());
                }
            }
        }
    }
}

