/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloException;
import ilog.concert.model.IlcIntervalUnion;
import ilog.solver.IlcDec;
import ilog.solver.IlcDecVar;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcReversibleAction;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.ed;
import ilog.solver.gbb;
import ilog.solver.in;
import ilog.solver.nm;
import ilog.solver.ot;
import ilog.solver.qbb;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class sv
extends gbb {
    final IlcSolver dtb;
    double etb;
    double ftb;
    double gtb;
    double htb;
    int itb;
    ot jtb;
    qbb ktb;
    boolean ltb;
    IlcDec mtb;
    String ntb;
    IlcIntervalUnion otb;
    IlcIntVar ptb;
    double qtb;

    public sv(IlcSolver ilcSolver, double d2, double d3, int n2) {
        this(ilcSolver, d2, d3, n2, null);
    }

    public sv(IlcSolver ilcSolver, double d2, double d3, int n2, String string) {
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IlcSolverRuntimeError.hu("with NaN bound.");
        }
        if (d2 > d3) {
            throw new IlcSolverRuntimeError.hu("with max < min.");
        }
        if (d2 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
            throw new IlcSolverRuntimeError.hu("instantiated at Infinity.");
        }
        this.dtb = ilcSolver;
        this.dtb.rd();
        this.mtb = new IlcDec(n2);
        double d4 = Math.max(d2, this.mtb.getDecMin());
        double d5 = Math.min(d3, this.mtb.getDecMax());
        this.gtb = this.mtb.unscaledCastUp(d4);
        this.htb = this.mtb.unscaledCastDown(d5);
        if (this.gtb > this.htb) {
            throw new IlcSolverRuntimeError.hu("between " + d2 + " and " + d3);
        }
        this.updateScaledRange();
        this.ktb = new qbb(ilcSolver);
        this.itb = ilcSolver.sj - 1;
        this.jtb = new ot(ilcSolver);
        this.ltb = false;
        this.ntb = string;
    }

    public final void updateScaledRange() {
        this.etb = this.mtb.getScaledLB(this.gtb);
        this.ftb = this.mtb.getScaledUB(this.htb);
    }

    public sv(IlcSolver ilcSolver, IlcIntervalUnion ilcIntervalUnion, int n2) {
        this(ilcSolver, ilcIntervalUnion, n2, null);
    }

    public sv(IlcSolver ilcSolver, IlcIntervalUnion ilcIntervalUnion, int n2, String string) {
        this.dtb = ilcSolver;
        this.dtb.rd();
        this.mtb = new IlcDec(n2);
        double d2 = ilcIntervalUnion.getLB();
        double d3 = ilcIntervalUnion.getUB();
        this.otb = ilcIntervalUnion;
        this.gtb = this.mtb.unscaledCastUp(d2);
        this.htb = this.mtb.unscaledCastDown(d3);
        this.updateScaledRange();
        this.ktb = new qbb(ilcSolver);
        this.itb = ilcSolver.sj - 1;
        this.jtb = new ot(ilcSolver);
        this.ltb = false;
        this.ntb = string;
    }

    public IlcSolver getSolver() {
        return this.dtb;
    }

    boolean jn() {
        return true;
    }

    void kn() {
    }

    public IlcIntervalUnion getIntervals() {
        return this.otb;
    }

    public boolean isIndexVarNull() throws IloException {
        return this.ptb == null;
    }

    public void setIndexVar(IlcIntVar ilcIntVar) throws IloException {
        if (this.ptb != null) {
            throw new IloException("Internal error: index var should be null");
        }
        this.dtb.addReversibleAction(new pn(this));
        this.ptb = ilcIntVar;
    }

    public IlcIntVar getIndexVar(IlcDecVar ilcDecVar) throws IloException {
        if (this.ptb == null) {
            if (!ilcDecVar.isIndexable()) {
                return null;
            }
            int n2 = ilcDecVar.getSize() - 1;
            IlcIntVar ilcIntVar = this.dtb.intVar(0, n2);
            ed ed2 = new ed(ilcDecVar, ilcIntVar);
            ed2.resetExtracted(this.dtb);
            this.dtb.addReversibleAction(new pn(this));
            this.ptb = ilcIntVar;
            this.dtb.add(ed2);
            this.qtb = IlcDec.unscaledCastUp(ilcDecVar.getLB(), ilcDecVar.getScale());
        }
        return this.ptb;
    }

    public double getBoundCastDownMid() {
        double d2 = this.gtb * 0.5 + this.htb * 0.5;
        if (Math.floor(d2) == d2) {
            return this.mtb.getScaled(d2 - 0.5);
        }
        return this.mtb.getScaled(d2);
    }

    public boolean isBound() {
        return this.gtb == this.htb;
    }

    public final boolean isNaN() {
        return false;
    }

    public final boolean in() {
        return false;
    }

    public int getScale() {
        return this.mtb.getPrecision();
    }

    public int getGuardDigits() {
        return 0;
    }

    public double boundCastDown(double d2) {
        return this.mtb.castDown(d2);
    }

    public double boundCastUp(double d2) {
        return this.mtb.castUp(d2);
    }

    public double boundNextDown(double d2) {
        return this.mtb.nextDown(d2);
    }

    public double boundNextUp(double d2) {
        return this.mtb.nextUp(d2);
    }

    public double propagationCastDown(double d2) {
        return this.mtb.castDown(d2);
    }

    public double propagationCastUp(double d2) {
        return this.mtb.castUp(d2);
    }

    public double propagationNextDown(double d2) {
        return this.mtb.nextDown(d2);
    }

    public double propagationNextUp(double d2) {
        return this.mtb.nextUp(d2);
    }

    public void reCompute() {
        this.jtb.gs();
    }

    protected final void isUsed(nm nm2) {
        this.jtb.fs(nm2);
    }

    public double getDomainLB() {
        return this.etb;
    }

    public double getDomainUB() {
        return this.ftb;
    }

    public long getUnscaledDomainLB() {
        return (long)this.gtb;
    }

    public long getUnscaledDomainUB() {
        return (long)this.htb;
    }

    public long getUnscaledDomainValue() throws IlcSolverRuntimeError {
        long l2 = this.getUnscaledDomainUB();
        if (l2 != this.getUnscaledDomainLB()) {
            throw new IlcSolverRuntimeError.ExpressionNotBound();
        }
        return l2;
    }

    public final Iterator unscaledDomainIterator() {
        return new g();
    }

    public double getUnscaledNextHigher(double d2) {
        if (this.otb != null) {
            double d3 = this.mtb.getScaledRoundLB(d2 + 1.0);
            double d4 = this.otb.getIntersectedLB(d3);
            if (d4 > this.ftb) {
                return d2;
            }
            double d5 = this.mtb.unscaledRoundInternal(d4);
            return d5;
        }
        double d6 = d2 + 1.0;
        if (d6 > this.htb) {
            return d2;
        }
        return d6;
    }

    public double getUnscaledNextLower(double d2) {
        if (this.otb != null) {
            double d3 = this.mtb.getScaledRoundLB(d2 - 1.0);
            double d4 = this.otb.getIntersectedUB(d3);
            if (d4 < this.etb) {
                return d2;
            }
            double d5 = this.mtb.unscaledRoundInternal(d4);
            return d5;
        }
        double d6 = d2 - 1.0;
        if (d6 < this.gtb) {
            return d2;
        }
        return d6;
    }

    public double getDomainRoundLB() {
        return this.mtb.getScaledRoundLB(this.gtb);
    }

    public double getDomainRoundUB() {
        return this.mtb.getScaledRoundUB(this.htb);
    }

    public double getDomainRoundStrictLB() {
        return this.mtb.getScaledRoundLB(this.gtb + 1.0);
    }

    public double getDomainRoundStrictUB() {
        return this.mtb.getScaledRoundUB(this.htb - 1.0);
    }

    public void setDomainLB(double d2) {
        this.setDomainRange(d2, this.ftb);
    }

    public void setDomainUB(double d2) {
        this.setDomainRange(this.etb, d2);
    }

    public void setDomainLBNoCast(double d2) {
        this.setDomainRangeNoCast(d2, this.ftb);
    }

    public void setDomainUBNoCast(double d2) {
        this.setDomainRangeNoCast(this.etb, d2);
    }

    private void cu() {
        this.reCompute();
        this.ltb = true;
        if (this.dtb.sj > this.itb) {
            jc jc2 = new jc(this, this.gtb, this.htb);
            this.dtb.addReversibleAction(jc2);
            this.itb = this.dtb.sj;
        }
    }

    public void setUnscaledDomainRange(double d2, double d3) {
        double d4;
        if (d3 < d2 || d3 < this.gtb || this.htb < d2) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (d2 <= this.gtb && this.htb <= d3) {
            return;
        }
        this.cu();
        if (this.gtb < d2) {
            this.gtb = d2;
            this.etb = this.mtb.getScaledLB(this.gtb);
            if (this.otb != null) {
                d4 = this.otb.getIntersectedLB(this.etb);
                if (d4 > this.mtb.getDecMax() || d4 > this.ftb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.etb = d4;
                this.gtb = this.mtb.unscaledCastUp(d4);
            }
        }
        if (d3 < this.htb) {
            this.htb = d3;
            this.ftb = this.mtb.getScaledUB(this.htb);
            if (this.otb != null) {
                d4 = this.otb.getIntersectedUB(this.ftb);
                if (d4 < this.mtb.getDecMin() || d4 < this.etb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.ftb = d4;
                this.htb = this.mtb.unscaledCastDown(d4);
            }
        }
        if (this.dtb.jj) {
            System.out.println("Set Range " + this.mtb.unscaledToString(d2) + " .." + this.mtb.unscaledToString(d3) + " from " + this);
        }
        this.dtb.rj.push(this);
    }

    public void setUnscaledDomainLB(double d2) {
        if (this.htb < d2) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (d2 <= this.gtb) {
            return;
        }
        this.cu();
        this.gtb = d2;
        this.etb = this.mtb.getScaledLB(this.gtb);
        if (this.otb != null) {
            double d3 = this.otb.getIntersectedLB(this.etb);
            if (d3 > this.mtb.getDecMax() || d3 > this.ftb) {
                if (this.dtb.mj) {
                    System.out.println("fail on " + this);
                }
                this.dtb.fail();
            }
            this.etb = d3;
            this.gtb = this.mtb.unscaledCastUp(d3);
        }
        if (this.dtb.jj) {
            System.out.println("Set LB " + this.mtb.unscaledToString(d2) + " from " + this);
        }
        this.dtb.rj.push(this);
    }

    public void setUnscaledDomainUB(double d2) {
        if (d2 < this.gtb) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.htb <= d2) {
            return;
        }
        this.cu();
        this.htb = d2;
        this.ftb = this.mtb.getScaledUB(this.htb);
        if (this.otb != null) {
            double d3 = this.otb.getIntersectedUB(this.ftb);
            if (d3 < this.mtb.getDecMin() || d3 < this.etb) {
                if (this.dtb.mj) {
                    System.out.println("fail on " + this);
                }
                this.dtb.fail();
            }
            this.ftb = d3;
            this.htb = this.mtb.unscaledCastDown(d3);
        }
        if (this.dtb.jj) {
            System.out.println("Set UB " + this.mtb.unscaledToString(d2) + " from " + this);
        }
        this.dtb.rj.push(this);
    }

    public void setUnscaledDomainValue(double d2) {
        double d3;
        if (d2 < this.gtb || this.htb < d2) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        this.cu();
        if (this.gtb < d2) {
            this.gtb = d2;
            this.etb = this.mtb.getScaledLB(this.gtb);
            if (this.otb != null) {
                d3 = this.otb.getIntersectedLB(this.etb);
                if (d3 > this.mtb.getDecMax() || d3 > this.ftb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.etb = d3;
                this.gtb = this.mtb.unscaledCastUp(d3);
            }
        }
        if (d2 < this.htb) {
            this.htb = d2;
            this.ftb = this.mtb.getScaledUB(this.htb);
            if (this.otb != null) {
                d3 = this.otb.getIntersectedUB(this.ftb);
                if (d3 < this.mtb.getDecMin() || d3 < this.etb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.ftb = d3;
                this.htb = this.mtb.unscaledCastDown(d3);
            }
        }
        if (this.dtb.jj) {
            System.out.println("Set Value " + this.mtb.unscaledToString(d2) + " from " + this);
        }
        this.dtb.rj.push(this);
    }

    public void removeUnscaledDomainValue(double d2) {
        double d3;
        if (d2 != this.gtb && d2 != this.htb) {
            return;
        }
        if (this.gtb == this.htb) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        this.cu();
        if (this.gtb == d2) {
            this.gtb += 1.0;
            this.etb = this.mtb.getScaledLB(this.gtb);
            if (this.otb != null) {
                d3 = this.otb.getIntersectedLB(this.etb);
                if (d3 > this.mtb.getDecMax() || d3 > this.ftb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.etb = d3;
                this.gtb = this.mtb.unscaledCastUp(d3);
            }
        }
        if (this.htb == d2) {
            this.htb -= 1.0;
            this.ftb = this.mtb.getScaledUB(this.htb);
            if (this.otb != null) {
                d3 = this.otb.getIntersectedUB(this.ftb);
                if (d3 < this.mtb.getDecMin() || d3 < this.etb) {
                    if (this.dtb.mj) {
                        System.out.println("fail on " + this);
                    }
                    this.dtb.fail();
                }
                this.ftb = d3;
                this.htb = this.mtb.unscaledCastDown(d3);
            }
        }
        if (this.dtb.jj) {
            System.out.println("Remove Value " + this.mtb.unscaledToString(d2) + " from " + this);
        }
        this.dtb.rj.push(this);
    }

    public void removeDomainRoundValue(double d2, double d3) {
        double d4;
        double d5 = Math.max(d2, this.mtb.getDecMin());
        double d6 = Math.min(d3, this.mtb.getDecMax());
        if (d6 <= this.mtb.getDecExtMin() || this.mtb.getDecExtMax() <= d5) {
            return;
        }
        double d7 = this.mtb.unscaledRoundInternal(d5);
        if (d7 != (d4 = this.mtb.unscaledRoundInternal(d6))) {
            return;
        }
        this.removeUnscaledDomainValue(d7);
    }

    public void setDomainRoundStrictLB(double d2) {
        double d3;
        double d4 = Math.max(d2, this.mtb.getDecMin());
        if (this.mtb.getDecExtMax() <= d4) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d3 = this.mtb.roundThresholdDown(d4);
            d4 = this.otb.getIntersectedLB(d3);
        }
        d3 = this.mtb.unscaledRoundInternal(d4) + 1.0;
        this.setUnscaledDomainLB(d3);
    }

    public void setDomainRoundStrictUB(double d2) {
        double d3;
        double d4 = Math.min(d2, this.mtb.getDecMax());
        if (d4 <= this.mtb.getDecExtMin()) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d3 = this.mtb.roundThresholdUp(d4);
            d4 = this.otb.getIntersectedUB(d3);
        }
        d3 = this.mtb.unscaledRoundInternal(d4) - 1.0;
        this.setUnscaledDomainUB(d3);
    }

    public void setDomainRoundLB(double d2) {
        double d3;
        double d4 = Math.max(d2, this.mtb.getDecMin());
        if (this.mtb.getDecExtMax() <= d4) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d3 = this.mtb.roundThresholdDown(d4);
            d4 = this.otb.getIntersectedLB(d3);
        }
        d3 = this.mtb.unscaledRoundInternal(d4);
        this.setUnscaledDomainLB(d3);
    }

    public void setDomainRoundUB(double d2) {
        double d3;
        double d4 = Math.min(d2, this.mtb.getDecMax());
        if (d4 <= this.mtb.getDecExtMin()) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d3 = this.mtb.roundThresholdUp(d4);
            d4 = this.otb.getIntersectedUB(d3);
        }
        d3 = this.mtb.unscaledRoundInternal(d4);
        this.setUnscaledDomainUB(d3);
    }

    public void setDomainRoundRange(double d2, double d3) {
        double d4;
        double d5;
        double d6 = Math.max(d2, this.mtb.getDecMin());
        double d7 = Math.min(d3, this.mtb.getDecMax());
        if (d7 <= this.mtb.getDecExtMin() || this.mtb.getDecExtMax() <= d6) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d5 = this.mtb.roundThresholdDown(d6);
            d4 = this.mtb.roundThresholdUp(d7);
            d6 = this.otb.getIntersectedLB(d5);
            d7 = this.otb.getIntersectedUB(d4);
        }
        d5 = this.mtb.unscaledRoundInternal(d6);
        d4 = this.mtb.unscaledRoundInternal(d7);
        this.setUnscaledDomainRange(d5, d4);
    }

    public void setDomainRange(double d2, double d3) {
        double d4 = Math.max(d2, this.mtb.getDecMin());
        double d5 = Math.min(d3, this.mtb.getDecMax());
        if (d5 <= this.mtb.getDecMin() || this.mtb.getDecMax() <= d4) {
            if (this.dtb.mj) {
                System.out.println("fail on " + this);
            }
            this.dtb.fail();
        }
        if (this.otb != null) {
            d4 = this.otb.getIntersectedLB(d4);
            d5 = this.otb.getIntersectedUB(d5);
            if (d4 > this.mtb.getDecMax() || d5 < this.mtb.getDecMin()) {
                if (this.dtb.mj) {
                    System.out.println("fail on " + this);
                }
                this.dtb.fail();
            }
        }
        double d6 = this.mtb.unscaledCastUp(d4);
        double d7 = this.mtb.unscaledCastDown(d5);
        this.setUnscaledDomainRange(d6, d7);
    }

    public void setDomainRangeNoCast(double d2, double d3) {
        this.setDomainRange(d2, d3);
    }

    public boolean isDomainEnumerated() {
        if (this.otb != null) {
            return true;
        }
        if (this.ptb == null) {
            return false;
        }
        in in2 = (in)this.ptb.getPIntExp(this.dtb);
        return !in2.isRange();
    }

    public int getNbOfConstraints() {
        return this.ktb.vy();
    }

    void kg() {
        if (this.dtb.kj) {
            System.out.println("Processing Var " + this);
        }
        if (this.ltb) {
            this.ltb = false;
            this.ktb.zy(this.dtb);
        }
    }

    public void whenRange(IlcDemon ilcDemon) {
        this.ktb.yy(this.dtb, ilcDemon);
    }

    public void whenValue(IlcDemon ilcDemon) {
        throw new UnsupportedOperationException("whenValue not supported");
    }

    public void whenDomain(IlcDemon ilcDemon) {
        this.whenRange(ilcDemon);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ntb != null) {
            stringBuffer.append(this.ntb);
        }
        stringBuffer.append("[");
        String string = this.mtb.unscaledToString(this.gtb);
        String string2 = this.mtb.unscaledToString(this.htb);
        if (string.equals(string2)) {
            stringBuffer.append(string);
        } else if (this.otb == null) {
            stringBuffer.append(string);
            stringBuffer.append("..");
            stringBuffer.append(string2);
        } else {
            Iterator iterator = this.unscaledDomainIterator();
            String string3 = "";
            while (iterator.hasNext()) {
                long l2 = (Long)iterator.next();
                stringBuffer.append(string3);
                stringBuffer.append(this.mtb.unscaledToString(l2));
                string3 = ", ";
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private final class g
    implements Iterator {
        private double g;
        IlcIterator h = null;

        g() {
            this.g = sv.this.gtb - 1.0;
            if (sv.this.ptb != null) {
                this.h = sv.this.ptb.domainIterator();
            }
        }

        public boolean hasNext() {
            if (this.h == null) {
                return this.g < sv.this.htb;
            }
            return this.h.hasNext();
        }

        public Object next() {
            if (this.h == null) {
                if (this.g >= sv.this.htb) {
                    throw new NoSuchElementException("No more value for " + sv.this.toString());
                }
                this.g = sv.this.otb != null ? sv.this.getUnscaledNextHigher(this.g) : (this.g += 1.0);
                return new Long((long)this.g);
            }
            int n2 = this.h.nextValue();
            if (sv.this.otb != null) {
                double d2 = sv.this.otb.getLBs(n2);
                this.g = sv.this.mtb.unscaledRoundInternal(d2);
                return new Long((long)this.g);
            }
            this.g = sv.this.qtb + (double)n2;
            return new Long((long)this.g);
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator does not implement the remove method");
        }
    }

    static final class jc
    extends IlcReversibleAction {
        sv oe;
        double pe;
        double qe;

        jc(sv sv2, double d2, double d3) {
            this.oe = sv2;
            this.pe = d2;
            this.qe = d3;
        }

        public void restore(IlcSolver ilcSolver) {
            this.oe.gtb = this.pe;
            this.oe.htb = this.qe;
            this.oe.updateScaledRange();
            this.oe.ltb = false;
            this.oe = null;
        }
    }

    static final class pn
    extends IlcReversibleAction {
        sv rdb;

        pn(sv sv2) {
            this.rdb = sv2;
        }

        public void restore(IlcSolver ilcSolver) {
            this.rdb.ptb = null;
        }
    }
}

