/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.hg;
import ilog.solver.uq;
import ilog.solver.ys;
import java.util.Arrays;

final class qu
extends uq {
    final ys[] pqb;
    final int qqb;
    final int rqb;
    final qn[] sqb;
    final qn[] tqb;
    final ys[] uqb;
    final ys vqb;
    final ys wqb;

    protected final hg[] getVars() {
        return this.pqb;
    }

    public qu(int[] nArray, IlcPIntAbstractVar[] ilcPIntAbstractVarArray, ys ys2) throws IlcSolverRuntimeError {
        int n2 = nArray.length;
        if (n2 != ilcPIntAbstractVarArray.length) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        if (n2 == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        if (n2 == Integer.MAX_VALUE) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        this.pqb = new ys[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            this.pqb[n3] = ilcPIntAbstractVarArray[n3];
            nArray2[n3] = nArray[n3];
            ++n3;
        }
        this.pqb[n2] = ys2;
        nArray2[n2] = 0;
        this.wqb = ys.scalProd(nArray2, this.pqb);
        int n4 = 0;
        while (n4 < n2) {
            ilcPIntAbstractVarArray[n4].isUsed(this);
            ++n4;
        }
        this.vqb = ys2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2) {
            if (nArray[n8] > 0) {
                ++n5;
            }
            if (nArray[n8] < 0) {
                ++n6;
            }
            if (nArray[n8] == 0) {
                ++n7;
            }
            ++n8;
        }
        this.sqb = new qn[n5];
        this.tqb = new qn[n6];
        this.uqb = new ys[n7];
        n5 = 0;
        n6 = 0;
        n7 = 0;
        int n9 = 0;
        while (n9 < n2) {
            if (nArray[n9] > 0) {
                this.sqb[n5] = new qn(nArray[n9], ilcPIntAbstractVarArray[n9]);
                ++n5;
            }
            if (nArray[n9] < 0) {
                this.tqb[n6] = new qn(-nArray[n9], ilcPIntAbstractVarArray[n9]);
                ++n6;
            }
            if (nArray[n9] == 0) {
                this.uqb[n7++] = ilcPIntAbstractVarArray[n9];
            }
            ++n9;
        }
        Arrays.sort(this.sqb);
        Arrays.sort(this.tqb);
        this.qqb = n5;
        this.rqb = n6;
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        int n2 = Math.max(this.qqb + this.rqb, this.vqb.getDomainMax());
        int n3 = Integer.MAX_VALUE / n2;
        if (this.vqb.gr()) {
            return false;
        }
        int n4 = 0;
        while (n4 < this.qqb) {
            long l2 = this.sqb[n4].getValue();
            long l3 = this.sqb[n4].getVar().getDomainMax();
            if (this.sqb[n4].getVar().gr() || l2 * l3 > (long)n3) {
                return false;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.rqb) {
            long l4 = this.tqb[n5].getValue();
            long l5 = this.tqb[n5].getVar().getDomainMax();
            if (this.tqb[n5].getVar().gr() || l4 * l5 > (long)n3) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public IlcSolver getSolver() {
        return this.pqb[0].getSolver();
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected int computeMinSum(int n2, qn[] qnArray) {
        int n3 = qnArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            ys ys2 = qnArray[n5].getVar();
            int n6 = ys2.getDomainMax() - ys2.getDomainMin();
            if (n2 <= n6) {
                return n4 + n2 * qnArray[n5].getValue();
            }
            n4 += n6 * qnArray[n5].getValue();
            n2 -= n6;
            ++n5;
        }
        return n4;
    }

    protected void computeRange() {
        int n2;
        int n3;
        int n4;
        this.getSolver();
        if (this.gr()) {
            this.computeRangeLong();
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.vqb.getDomainMin();
        int n10 = this.vqb.getDomainMax();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 < this.qqb) {
            ys ys2 = this.sqb[n13].getVar();
            n4 = this.sqb[n13].getValue();
            n3 = ys2.getDomainMin();
            n2 = ys2.getDomainMax();
            n7 += n3;
            n5 += n4 * n3;
            n8 += n2;
            n6 += n4 * n2;
            ++n13;
        }
        int n14 = 0;
        while (n14 < this.rqb) {
            n4 = this.tqb[n14].getValue();
            if (n4 != 0) {
                ys ys3 = this.tqb[n14].getVar();
                n2 = ys3.getDomainMin();
                int n15 = ys3.getDomainMax();
                n7 += n15;
                n5 -= n4 * n15;
                n8 += n2;
                n6 -= n4 * n2;
            }
            ++n14;
        }
        n4 = 0;
        while (n4 < this.uqb.length) {
            n3 = this.uqb[n4].getDomainMin();
            n2 = this.uqb[n4].getDomainMax();
            n11 += n3;
            n12 += n2;
            ++n4;
        }
        n3 = n9 - n12;
        n2 = n10 - n11;
        if (n7 < n3) {
            n5 += this.computeMinSum(n3 - n7, this.sqb);
        } else if (n7 > n2) {
            n5 += this.computeMinSum(n7 - n2, this.tqb);
        }
        if (n8 < n3) {
            n6 -= this.computeMinSum(n3 - n8, this.tqb);
        } else if (n8 > n2) {
            n6 -= this.computeMinSum(n8 - n2, this.sqb);
        }
        this.ljb = n5;
        this.mjb = n6;
    }

    protected long computeMinSumLong(long l2, qn[] qnArray) {
        int n2 = qnArray.length;
        long l3 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            ys ys2 = qnArray[n3].getVar();
            long l4 = ys2.getDomainMax() - ys2.getDomainMin();
            long l5 = qnArray[n3].getValue();
            if (l2 <= l4) {
                return l3 + (long)ys.safeCastLong(l2 * l5);
            }
            l3 += (long)ys.safeCastLong(l4 * l5);
            l2 -= l4;
            ++n3;
        }
        return l3;
    }

    protected void computeRangeLong() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = this.vqb.getDomainMin();
        long l7 = this.vqb.getDomainMax();
        int n2 = 0;
        while (n2 < this.qqb) {
            ys ys2 = this.sqb[n2].getVar();
            long l8 = this.sqb[n2].getValue();
            long l9 = ys2.getDomainMin();
            long l10 = ys2.getDomainMax();
            l4 += l9;
            l2 += (long)ys.safeCastLong(l8 * l9);
            l5 += l10;
            l3 += (long)ys.safeCastLong(l8 * l10);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.rqb) {
            ys ys3 = this.tqb[n3].getVar();
            long l11 = this.tqb[n3].getValue();
            long l12 = ys3.getDomainMin();
            long l13 = ys3.getDomainMax();
            l4 += l13;
            l2 -= (long)ys.safeCastLong(l11 * l13);
            l5 += l12;
            l3 -= (long)ys.safeCastLong(l11 * l12);
            ++n3;
        }
        if (l4 < l6) {
            l2 += this.computeMinSumLong(l6 - l4, this.sqb);
        } else if (l4 > l7) {
            l2 += this.computeMinSumLong(l4 - l7, this.tqb);
        }
        if (l5 < l6) {
            l3 -= this.computeMinSumLong(l6 - l5, this.tqb);
        } else if (l5 > l7) {
            l3 -= this.computeMinSumLong(l5 - l7, this.sqb);
        }
        this.safeSetBoundsLong(l2, l3);
    }

    protected void setRangeInternal(int n2, int n3) {
        this.wqb.setDomainRange(n2, n3);
    }

    protected void removeValueInternal(int n2) {
    }

    protected void removeIntervalInternal(int n2, int n3) {
    }

    public synchronized String toString() {
        if (this.ojb != null) {
            return this.ojb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.wqb);
        stringBuffer.append(" #");
        stringBuffer.append(this.pqb[this.pqb.length - 1]);
        return stringBuffer.toString();
    }

    final class qn
    implements Comparable {
        final int sdb;
        final ys tdb;

        public qn(int n2, ys ys2) {
            this.sdb = n2;
            this.tdb = ys2;
        }

        public int compareTo(Object object) throws ClassCastException {
            qn qn2 = (qn)object;
            if (this.sdb > qn2.sdb) {
                return 1;
            }
            if (this.sdb < qn2.sdb) {
                return -1;
            }
            return 0;
        }

        public int getValue() {
            return this.sdb;
        }

        public ys getVar() {
            return this.tdb;
        }

        public String toString() {
            return this.tdb + " " + this.sdb;
        }
    }
}

