/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloIntToNumExprFunction;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.nm;
import ilog.solver.ox;
import ilog.solver.yz;

class ok
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;
    protected IloIntToNumExprFunction _func;
    protected double _min;
    protected double _max;

    ok(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2, IloIntToNumExprFunction iloIntToNumExprFunction, double d2, double d3) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
        this._func = iloIntToNumExprFunction;
        this._min = d2;
        this._max = d3;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        kh kh2 = (kh)this._var1.getExtracted(ilcSolver);
        kh kh3 = (kh)this._var2.getExtracted(ilcSolver);
        ox ox2 = new ox(ilcSolver, this._func);
        return new sf(kh2, kh3, ox2, this._min, this._max);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rangedSubsetEq(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(", ");
        stringBuffer.append(this._func);
        stringBuffer.append(", ");
        stringBuffer.append(this._min);
        stringBuffer.append(", ");
        stringBuffer.append(this._max);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSetVar iloIntSetVar = (IloIntSetVar)iloCopyManager.getCopy(this._var1);
        IloIntSetVar iloIntSetVar2 = (IloIntSetVar)iloCopyManager.getCopy(this._var2);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.rangedSubsetEq(iloIntSetVar, iloIntSetVar2, this._func, this._min, this._max);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
    }

    static final class sf
    extends IlcPPropagator {
        final kh em;
        final kh fm;
        final ox gm;
        final double hm;
        final double im;

        public sf(kh kh2, kh kh3, ox ox2, double d2, double d3) {
            this.em = kh2;
            this.fm = kh3;
            this.gm = ox2;
            this.hm = d2;
            this.im = d3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.em.whenDomain(ilcDemon);
            this.fm.whenDomain(ilcDemon);
        }

        public void post() {
            this.em.getSolver().add(new yz.pm(this.em.getCardinality(), this.fm.getCardinality()));
            this.em.whenDomain(new nw());
            this.fm.whenDomain(new gl());
            IlcIterator ilcIterator = this.em.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                nm nm2 = this.gm.getValue(n2);
                nm2.whenRange(new uk(n2, nm2));
            }
        }

        public void propagate() {
            IlcIterator ilcIterator = this.em.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                if (!this.fm.isDomainPossible(n2)) {
                    this.em.removeDomainPossible(n2);
                    continue;
                }
                if (!this.em.isDomainRequired(n2)) continue;
                nm nm2 = this.gm.getValue(n2);
                nm2.setDomainRange(this.hm, this.im);
                this.fm.addDomainRequired(n2);
            }
        }

        public boolean isViolated() {
            IlcIterator ilcIterator = this.em.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                nm nm2 = this.gm.getValue(n2);
                if (!(nm2.getDomainUB() < this.hm) && !(nm2.getDomainLB() > this.im) && this.fm.isDomainPossible(n2)) continue;
                return true;
            }
            return false;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rangedSubsetEq(");
            stringBuffer.append(this.em);
            stringBuffer.append(", ");
            stringBuffer.append(this.fm);
            stringBuffer.append(", ");
            stringBuffer.append(this.gm);
            stringBuffer.append(", ");
            stringBuffer.append(this.hm);
            stringBuffer.append(", ");
            stringBuffer.append(this.im);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        final class uk
        extends IlcDemon {
            final int vw;
            final nm ww;

            uk(int n2, nm nm2) {
                this.vw = n2;
                this.ww = nm2;
            }

            public void propagate() {
                if (this.ww.getDomainUB() < sf.this.hm || this.ww.getDomainLB() > sf.this.im) {
                    sf.this.em.removeDomainPossible(this.vw);
                }
            }
        }

        final class gl
        extends IlcDemon {
            gl() {
            }

            public void propagate() {
                IlcIterator ilcIterator = sf.this.fm.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    sf.this.em.removeDomainPossible(ilcIterator.nextValue());
                }
            }
        }

        final class nw
        extends IlcDemon {
            nw() {
            }

            public void propagate() {
                IlcIterator ilcIterator = sf.this.em.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    int n2 = ilcIterator.nextValue();
                    nm nm2 = sf.this.gm.getValue(n2);
                    nm2.setDomainRange(sf.this.hm, sf.this.im);
                    sf.this.fm.addDomainRequired(n2);
                }
            }
        }
    }
}

