/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.ui;
import ilog.solver.uq;
import ilog.solver.ys;

class mf
extends uq {
    final ys vl;
    final ys wl;

    public mf(ys ys2, ys ys3) {
        this.vl = ys2;
        this.wl = ys3;
        ys2.isUsed(this);
        ys3.isUsed(this);
        this.getSolver();
        this.initOverflow();
    }

    protected final hg[] getVars() {
        return new hg[]{this.vl, this.wl};
    }

    public final IlcSolver getSolver() {
        return this.vl.getSolver();
    }

    protected final boolean isOverflowSafe() {
        int n2 = (int)Math.floor(Math.sqrt(2.147483647E9));
        int n3 = -n2;
        return !this.vl.gr() && !this.wl.gr() && this.vl.getDomainMin() > n3 && this.vl.getDomainMax() < n2 && this.wl.getDomainMin() > n3 && this.wl.getDomainMax() < n2;
    }

    public final int getDomainSizeInternal() {
        if (this.vl.isBound()) {
            return this.wl.getDomainSize();
        }
        if (this.wl.isBound()) {
            return this.vl.getDomainSize();
        }
        return ys.safeCastPosLong((long)this.getDomainMax() - (long)this.getDomainMin() + 1L);
    }

    protected final boolean isInDomainInternal(int n2) {
        if (this.vl.isBound()) {
            int n3 = this.vl.getDomainMin();
            int n4 = n2 / n3;
            if (n4 * n3 == n2) {
                return this.wl.isInDomain(n4);
            }
            return false;
        }
        if (this.wl.isBound()) {
            int n5 = this.wl.getDomainMin();
            int n6 = n2 / n5;
            if (n6 * n5 == n2) {
                return this.vl.isInDomain(n6);
            }
            return false;
        }
        return true;
    }

    protected void computeRange() {
        this.getSolver();
        if (this.gr()) {
            this.computeRangeLong();
            return;
        }
        int n2 = this.vl.getDomainMin();
        int n3 = this.vl.getDomainMax();
        int n4 = this.wl.getDomainMin();
        int n5 = this.wl.getDomainMax();
        int n6 = n2 * n4;
        int n7 = n3 * n5;
        if (n2 >= 0 && n4 >= 0) {
            this.ljb = n6;
            this.mjb = n7;
            return;
        }
        int n8 = n6;
        if (n6 > n7) {
            n6 = n7;
            n7 = n8;
        }
        if ((n8 = n2 * n5) < n6) {
            n6 = n8;
        }
        if (n8 > n7) {
            n7 = n8;
        }
        this.ljb = (n8 = n4 * n3) < n6 ? n8 : n6;
        this.mjb = n8 > n7 ? n8 : n7;
    }

    protected final void computeRangeLong() {
        long l2 = this.vl.getDomainMin();
        long l3 = this.vl.getDomainMax();
        long l4 = this.wl.getDomainMin();
        long l5 = this.wl.getDomainMax();
        long l6 = l2 * l4;
        long l7 = l3 * l5;
        if (l2 >= 0L && l4 >= 0L) {
            this.safeSetBoundsLong(l6, l7);
            return;
        }
        long l8 = l6;
        if (l6 > l7) {
            l6 = l7;
            l7 = l8;
        }
        if ((l8 = l2 * l5) < l6) {
            l6 = l8;
        }
        if (l8 > l7) {
            l7 = l8;
        }
        this.safeSetBoundsLong((l8 = l4 * l3) < l6 ? l8 : l6, l8 > l7 ? l8 : l7);
    }

    protected void setRangeInternal(int n2, int n3) {
        if (n2 > 0) {
            this.pf(n2, n3);
            return;
        }
        if (n3 < 0) {
            this.of(n2, n3);
            return;
        }
        this.nf(n2, n3);
    }

    private void nf(int n2, int n3) {
        int n4 = this.vl.getDomainMin();
        int n5 = this.vl.getDomainMax();
        int n6 = this.wl.getDomainMin();
        int n7 = this.wl.getDomainMax();
        if (n4 > 0) {
            this.wl.setDomainRange(ui.vi(n2, n4), ui.ui(n3, n4));
        }
        if (n5 < 0) {
            this.wl.setDomainRange(ui.vi(n3, n5), ui.ui(n2, n5));
        }
        if (n6 > 0) {
            this.vl.setDomainRange(ui.vi(n2, n6), ui.ui(n3, n6));
        }
        if (n7 < 0) {
            this.vl.setDomainRange(ui.vi(n3, n7), ui.ui(n2, n7));
        }
    }

    private void pf(int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.vl.getDomainMin();
        int n7 = this.vl.getDomainMax();
        int n8 = this.wl.getDomainMin();
        int n9 = this.wl.getDomainMax();
        if (n6 == 0 && n7 == 0 || n8 == 0 && n9 == 0) {
            this.vl.getSolver().fail();
        }
        int n10 = n6;
        int n11 = n7;
        int n12 = n8;
        int n13 = n9;
        if (n6 >= 0) {
            n12 = ui.vi(n2, n7);
            if (n6 > 0) {
                n13 = ui.ui(n3, n6);
            }
        } else if (n7 <= 0) {
            n13 = ui.ui(n2, n6);
            if (n7 < 0) {
                n12 = ui.vi(n3, n7);
            }
        }
        if (n8 >= 0) {
            n10 = ui.vi(n2, n9);
            if (n8 > 0) {
                n11 = ui.ui(n3, n8);
            }
        } else if (n9 <= 0) {
            n11 = ui.ui(n2, n8);
            if (n9 < 0) {
                n10 = ui.vi(n3, n9);
            }
        }
        if (n6 < 0 && 0 < n7) {
            n5 = ui.vi(n2 - 1, n6);
            n4 = ui.ui(n2 - 1, n7);
            this.getSolver();
            if (this.wl.holesOK()) {
                this.wl.removeDomainInterval(n5, n4);
            }
        } else if (n12 > n8 || n13 < n9) {
            this.wl.setDomainRange(n12, n13);
        }
        if (n8 < 0 && 0 < n9) {
            n5 = ui.vi(n2 - 1, n8);
            n4 = ui.ui(n2 - 1, n9);
            this.getSolver();
            if (this.vl.holesOK()) {
                this.vl.removeDomainInterval(n5, n4);
            }
        } else if (n10 > n6 || n11 < n7) {
            this.vl.setDomainRange(n10, n11);
        }
    }

    private void of(int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.vl.getDomainMin();
        int n7 = this.vl.getDomainMax();
        int n8 = this.wl.getDomainMin();
        int n9 = this.wl.getDomainMax();
        if (n6 == 0 && n7 == 0 || n8 == 0 && n9 == 0) {
            this.vl.getSolver().fail();
        }
        int n10 = n6;
        int n11 = n7;
        int n12 = n8;
        int n13 = n9;
        if (n6 >= 0) {
            n13 = ui.ui(n3, n7);
            if (n6 > 0) {
                n12 = ui.vi(n2, n6);
            }
        } else if (n7 <= 0) {
            n12 = ui.vi(n3, n6);
            if (n7 < 0) {
                n13 = ui.ui(n2, n7);
            }
        }
        if (n8 >= 0) {
            n11 = ui.ui(n3, n9);
            if (n8 > 0) {
                n10 = ui.vi(n2, n8);
            }
        } else if (n9 <= 0) {
            n10 = ui.vi(n3, n8);
            if (n9 < 0) {
                n11 = ui.ui(n2, n9);
            }
        }
        if (n6 < 0 && 0 < n7) {
            n5 = ui.vi(n3 + 1, n7);
            n4 = ui.ui(n3 + 1, n6);
            this.getSolver();
            if (this.wl.holesOK()) {
                this.wl.removeDomainInterval(n5, n4);
            }
        } else if (n12 > n8 || n13 < n9) {
            this.wl.setDomainRange(n12, n13);
        }
        if (n8 < 0 && 0 < n9) {
            n5 = ui.vi(n3 + 1, n9);
            n4 = ui.ui(n3 + 1, n8);
            this.getSolver();
            if (this.vl.holesOK()) {
                this.vl.removeDomainInterval(n5, n4);
            }
        } else if (n10 > n6 || n11 < n7) {
            this.vl.setDomainRange(n10, n11);
        }
    }

    protected final void removeValueInternal(int n2) {
        this.getSolver();
        if (this.wl.holesOK()) {
            int n3;
            int n4;
            if (this.vl.isBound() && (n4 = n2 / (n3 = this.vl.getDomainMin())) * n3 == n2) {
                this.wl.removeDomainValue(n4);
            }
            if (this.wl.isBound() && (n4 = n2 / (n3 = this.wl.getDomainMin())) * n3 == n2) {
                this.wl.removeDomainValue(n4);
            }
        }
    }

    protected void removeIntervalInternal(int n2, int n3) {
        int n4 = n2;
        while (n4 <= n3) {
            this.removeDomainValue(n4);
            ++n4;
        }
    }

    public final synchronized String toString() {
        if (this.ojb != null) {
            return this.ojb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.vl);
        stringBuffer.append(" * ");
        stringBuffer.append(this.wl);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

