/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcDec;
import ilog.solver.IlcDemon;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.gbb;
import ilog.solver.nm;

final class iv
extends gbb {
    IlcSolver asb;
    double bsb;
    double csb;
    double dsb;
    IlcDec esb;

    public iv(IlcSolver ilcSolver, double d2, double d3, int n2) {
        double d4;
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IlcSolverRuntimeError.ybb("with NaN bound.");
        }
        if (d2 > d3) {
            throw new IlcSolverRuntimeError.ybb("with max < min.");
        }
        if (d2 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
            throw new IlcSolverRuntimeError.ybb("instantiated at Infinity.");
        }
        this.esb = new IlcDec(n2);
        double d5 = Math.max(d2, this.esb.getDecMin());
        double d6 = Math.min(d3, this.esb.getDecMax());
        double d7 = this.esb.unscaledCastUp(d5);
        if (d7 != (d4 = this.esb.unscaledCastDown(d6))) {
            throw new IlcSolverRuntimeError.hu("between " + d2 + " and " + d3);
        }
        this.dsb = d7;
        this.bsb = this.esb.getScaledLB(this.dsb);
        this.csb = this.esb.getScaledUB(this.dsb);
        this.asb = ilcSolver;
    }

    public IlcSolver getSolver() {
        return this.asb;
    }

    boolean jn() {
        return true;
    }

    void kn() {
    }

    protected final void isUsed(nm nm2) {
    }

    public void whenRange(IlcDemon ilcDemon) {
    }

    public void whenValue(IlcDemon ilcDemon) {
    }

    public void whenDomain(IlcDemon ilcDemon) {
    }

    public boolean isBound() {
        return true;
    }

    public final boolean isNaN() {
        return false;
    }

    public final boolean in() {
        return false;
    }

    public int getNbOfConstraints() {
        return 0;
    }

    public int getScale() {
        return this.esb.getPrecision();
    }

    public double getDomainLB() {
        return this.bsb;
    }

    public double getDomainUB() {
        return this.csb;
    }

    public long getUnscaledDomainLB() {
        return (long)this.dsb;
    }

    public long getUnscaledDomainUB() {
        return (long)this.dsb;
    }

    public long getUnscaledDomainValue() {
        return (long)this.dsb;
    }

    public double getDomainRoundLB() {
        return this.esb.getScaledRoundLB(this.dsb);
    }

    public double getDomainRoundUB() {
        return this.esb.getScaledRoundUB(this.dsb);
    }

    public double getDomainRoundStrictLB() {
        return this.esb.getScaledRoundLB(this.dsb + 1.0);
    }

    public double getDomainRoundStrictUB() {
        return this.esb.getScaledRoundUB(this.dsb - 1.0);
    }

    public void setDomainLB(double d2) {
        if (d2 > this.csb) {
            this.asb.fail();
        }
    }

    public void setDomainUB(double d2) {
        if (d2 < this.bsb) {
            this.asb.fail();
        }
    }

    public void setDomainRange(double d2, double d3) {
        if (d2 > d3 || d3 < this.bsb || this.csb < d2) {
            this.asb.fail();
        }
    }

    public void setUnscaledDomainLB(double d2) {
        if (d2 > this.dsb) {
            this.asb.fail();
        }
    }

    public void setUnscaledDomainUB(double d2) {
        if (d2 < this.dsb) {
            this.asb.fail();
        }
    }

    public void setUnscaledDomainRange(double d2, double d3) {
        if (d2 > d3 || d3 < this.dsb || this.dsb < d2) {
            this.asb.fail();
        }
    }

    public void setUnscaledDomainValue(double d2) {
        if (d2 != this.dsb) {
            this.asb.fail();
        }
    }

    public void removeUnscaledDomainValue(double d2) {
        if (d2 == this.dsb) {
            this.asb.fail();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        String string = this.esb.unscaledToString(this.dsb);
        stringBuffer.append(string);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

