/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloIntToIntFunction;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.kh;
import ilog.solver.rh;
import ilog.solver.xh;
import ilog.solver.ys;

class is
extends rh {
    long wlb;
    long xlb;
    long ylb;
    int zlb;
    int amb;
    final IloIntToIntFunction bmb;

    is(kh kh2, IloIntToIntFunction iloIntToIntFunction) {
        super(kh2);
        this.bmb = iloIntToIntFunction;
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        this.computeInfoLong();
        long l2 = this.gq.getDomainPossibleSize() - this.gq.getDomainRequiredSize();
        long l3 = Math.max(Math.abs(this.zlb), Math.abs(this.amb));
        return l2 * l3 + this.wlb <= 0x3FFFFFFFL;
    }

    protected final void computeInfoLong() {
        if (this.gq.getDomainPossibleSize() == 0) {
            this.wlb = 0L;
            this.xlb = 0L;
            this.ylb = 0L;
            this.zlb = 0;
            this.amb = 0;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        if (this.gq.isBound()) {
            long l2 = 0L;
            IlcIterator ilcIterator = this.gq.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                l2 += (long)this.bmb.getValue(ilcIterator.nextValue());
            }
            this.wlb = l2;
            this.xlb = l2;
            this.ylb = l2;
            this.zlb = 0;
            this.amb = 0;
            this.mjb = this.ljb = ys.safeCastLong(l2);
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = -2147483647;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        IlcIterator ilcIterator = this.gq.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n4 = ilcIterator.nextValue();
            int n5 = this.bmb.getValue(n4);
            if (this.gq.isDomainRequired(n4)) {
                l3 += (long)n5;
                continue;
            }
            if (n5 < 0) {
                l4 += (long)n5;
            } else {
                l5 += (long)n5;
            }
            if (n5 < n2) {
                n2 = n5;
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        this.wlb = l3;
        this.xlb = l3 + l4;
        this.ylb = l3 + l5;
        this.zlb = n2;
        this.amb = n3;
    }

    protected void computeRangeLong() {
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        int n2 = this.gq.getDomainRequiredSize();
        long l2 = ilcPIntAbstractVar.getDomainMin() - n2;
        long l3 = ilcPIntAbstractVar.getDomainMax() - n2;
        long l4 = this.zlb < 0 ? (long)this.zlb * l3 + this.wlb : (long)this.zlb * l2 + this.wlb;
        long l5 = this.amb < 0 ? (long)this.amb * l2 + this.wlb : (long)this.amb * l3 + this.wlb;
        this.safeSetBoundsLong(Math.max(this.xlb, l4), Math.min(this.ylb, l5));
    }

    protected void computeRange() {
        int n2;
        this.getSolver();
        if (this.gr()) {
            this.computeRangeLong();
            return;
        }
        if (this.gq.getDomainPossibleSize() == 0) {
            this.wlb = 0L;
            this.xlb = 0L;
            this.ylb = 0L;
            this.zlb = 0;
            this.amb = 0;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        if (this.gq.isBound()) {
            int n3 = 0;
            IlcIterator ilcIterator = this.gq.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                n3 += this.bmb.getValue(ilcIterator.nextValue());
            }
            this.wlb = n3;
            this.xlb = n3;
            this.ylb = n3;
            this.zlb = 0;
            this.amb = 0;
            this.ljb = n3;
            this.mjb = n3;
            return;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = -2147483647;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        IlcIterator ilcIterator = this.gq.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n9 = ilcIterator.nextValue();
            n2 = this.bmb.getValue(n9);
            if (this.gq.isDomainRequired(n9)) {
                n6 += n2;
                continue;
            }
            if (n2 < 0) {
                n7 += n2;
            } else {
                n8 += n2;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            if (n2 <= n5) continue;
            n5 = n2;
        }
        this.wlb = n6;
        this.xlb = n6 + n7;
        this.ylb = n6 + n8;
        this.zlb = n4;
        this.amb = n5;
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        n2 = this.gq.getDomainRequiredSize();
        int n10 = ilcPIntAbstractVar.getDomainMin() - n2;
        int n11 = ilcPIntAbstractVar.getDomainMax() - n2;
        n4 = n4 < 0 ? n4 * n11 + n6 : n4 * n10 + n6;
        n5 = n5 < 0 ? n5 * n10 + n6 : n5 * n11 + n6;
        this.ljb = Math.max((int)this.xlb, n4);
        this.mjb = Math.min((int)this.ylb, n5);
    }

    protected void setRangeInternal(int n2, int n3) {
        int n4;
        int n5;
        IlcIterator ilcIterator;
        this.getSolver();
        this.fq();
        this.getSolver();
        if (this.gr()) {
            this.setRangeInternalLong(n2, n3);
            return;
        }
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n6 = this.ljb;
        int n7 = this.mjb;
        int n8 = this.zlb;
        int n9 = this.amb;
        int n10 = (int)this.wlb;
        int n11 = n3 - (int)this.xlb;
        if (n11 < 0) {
            this.fail();
        }
        if (n3 < n7) {
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n5 = ilcIterator.nextValue();
                if (xh2.isInSet(n5)) continue;
                n4 = this.bmb.getValue(n5);
                if (n4 > n11) {
                    this.gq.removeDomainPossible(n5);
                    continue;
                }
                if (-n4 <= n11) continue;
                this.gq.addDomainRequired(n5);
                n10 += n4;
            }
            n5 = xh2.getCardinal();
            if (n8 < 0) {
                n4 = (n3 - n10 + n8 + 1) / n8;
                if (n4 > 0) {
                    this.gq.getCardinality().setDomainMin(n5 + n4);
                }
            } else if (n8 > 0 && (n4 = (n3 - n10) / n8) >= 0) {
                this.gq.getCardinality().setDomainMax(n5 + n4);
            }
        }
        if ((n11 = (int)this.ylb - n2) < 0) {
            this.fail();
        }
        if (n2 > n6) {
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n5 = ilcIterator.nextValue();
                if (xh2.isInSet(n5)) continue;
                n4 = this.bmb.getValue(n5);
                if (n4 > n11) {
                    this.gq.addDomainRequired(n5);
                    n10 += n4;
                    continue;
                }
                if (-n4 <= n11) continue;
                this.gq.removeDomainPossible(n5);
            }
            n5 = xh2.getCardinal();
            if (n9 < 0) {
                n4 = (n2 - n10) / n9;
                if (n4 >= 0) {
                    this.gq.getCardinality().setDomainMax(n5 + n4);
                }
            } else if (n9 > 0 && (n4 = (n2 - n10 + n9 - 1) / n9) > 0) {
                this.gq.getCardinality().setDomainMin(n5 + n4);
            }
        }
    }

    protected void setRangeInternalLong(long l2, long l3) {
        int n2;
        IlcIterator ilcIterator;
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n3 = this.ljb;
        int n4 = this.mjb;
        int n5 = this.zlb;
        int n6 = this.amb;
        long l4 = this.wlb;
        long l5 = l3 - this.xlb;
        if (l5 < 0L) {
            this.fail();
        }
        if (l3 < (long)n4) {
            long l6;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                if (xh2.isInSet(n2)) continue;
                int n7 = this.bmb.getValue(n2);
                if ((long)n7 > l5) {
                    this.gq.removeDomainPossible(n2);
                    continue;
                }
                if (-((long)n7) <= l5) continue;
                this.gq.addDomainRequired(n2);
                l4 += (long)n7;
            }
            n2 = xh2.getCardinal();
            if (n5 < 0) {
                long l7 = (l3 - l4 + (long)n5 + 1L) / (long)n5;
                if (l7 > 0L) {
                    this.gq.getCardinality().setDomainMinLong((long)n2 + l7);
                }
            } else if (n5 > 0 && (l6 = (l3 - l4) / (long)n5) > 0L) {
                this.gq.getCardinality().setDomainMaxLong((long)n2 + l6);
            }
        }
        if ((l5 = this.ylb - l2) < 0L) {
            this.fail();
        }
        if (l2 > (long)n3) {
            long l8;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                if (xh2.isInSet(n2)) continue;
                int n8 = this.bmb.getValue(n2);
                if ((long)n8 > l5) {
                    this.gq.addDomainRequired(n2);
                    l4 += (long)n8;
                    continue;
                }
                if (-((long)n8) <= l5) continue;
                this.gq.removeDomainPossible(n2);
            }
            n2 = xh2.getCardinal();
            if (n6 < 0) {
                long l9 = (l2 - l4) / (long)n6;
                if (l9 > 0L) {
                    this.gq.getCardinality().setDomainMaxLong((long)n2 + l9);
                }
            } else if (n6 > 0 && (l8 = (l2 - l4 + (long)n6 - 1L) / (long)n6) > 0L) {
                this.gq.getCardinality().setDomainMinLong((long)n2 + l8);
            }
        }
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected void removeValueInternal(int n2) {
    }

    protected void removeIntervalInternal(int n2, int n3) {
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sum(Set, Int F(x)):[");
        stringBuffer.append(this.getDomainMin());
        stringBuffer.append("..");
        stringBuffer.append(this.getDomainMax());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

