/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.uq;
import ilog.solver.ys;

final class bz
extends uq {
    ys dbc;
    ys ebc;

    public bz(ys ys2, ys ys3) {
        this.dbc = ys2;
        this.ebc = ys3;
        ys2.isUsed(this);
        ys3.isUsed(this);
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        return !this.dbc.gr() && !this.ebc.gr();
    }

    protected final hg[] getVars() {
        return new hg[]{this.dbc, this.ebc};
    }

    private static int yx(int n2, int n3) {
        if (n2 > n3) {
            return n2;
        }
        return n3;
    }

    public IlcSolver getSolver() {
        return this.dbc.getSolver();
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected void computeRange() {
        this.ljb = bz.yx(this.dbc.getDomainMin(), this.ebc.getDomainMin());
        this.mjb = bz.yx(this.dbc.getDomainMax(), this.ebc.getDomainMax());
    }

    protected void setRangeInternal(int n2, int n3) {
        int n4 = this.dbc.getDomainMin();
        int n5 = this.dbc.getDomainMax();
        int n6 = this.ebc.getDomainMin();
        int n7 = this.ebc.getDomainMax();
        if (n5 < n2 || n5 < n6) {
            this.ebc.setDomainRange(n2, n3);
            return;
        }
        if (n7 < n2 || n7 < n4) {
            this.dbc.setDomainRange(n2, n3);
            return;
        }
        this.dbc.setDomainMax(n3);
        this.ebc.setDomainMax(n3);
    }

    protected void removeValueInternal(int n2) {
        int n3 = this.dbc.getDomainMax();
        int n4 = this.ebc.getDomainMax();
        if (n3 < n2 && n2 <= n4) {
            if (this.ebc.holesOK()) {
                this.ebc.removeDomainValue(n2);
            }
            return;
        }
        if (n4 < n2 && n2 <= n3) {
            if (this.dbc.holesOK()) {
                this.dbc.removeDomainValue(n2);
            }
            return;
        }
    }

    protected void removeIntervalInternal(int n2, int n3) {
        int n4 = this.dbc.getDomainMax();
        int n5 = this.ebc.getDomainMax();
        if (n4 < n3 && n3 <= n5) {
            int n6 = bz.yx(n4 + 1, n2);
            if (this.ebc.holesOK()) {
                this.ebc.removeDomainInterval(n6, n3);
            }
            return;
        }
        if (n5 < n3 && n3 <= n4) {
            int n7 = bz.yx(n5 + 1, n2);
            if (this.dbc.holesOK()) {
                this.dbc.removeDomainInterval(n7, n3);
            }
            return;
        }
    }

    public synchronized String toString() {
        if (this.ojb != null) {
            return this.ojb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcPMax:(");
        stringBuffer.append(this.dbc);
        stringBuffer.append(", ");
        stringBuffer.append(this.ebc);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

