/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcIterator;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.kh;
import ilog.solver.rh;
import ilog.solver.xh;
import ilog.solver.ys;

class bi
extends rh {
    long cr = 0L;
    long dr = 0L;
    long er = 0L;

    bi(kh kh2) {
        super(kh2);
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        long l2;
        long l3 = this.gq.getDomainPossibleSize();
        return l3 * (l2 = (long)Math.max(Math.abs(this.gq.getDomainPossibleSet().getDomainMin()), Math.abs(this.gq.getDomainPossibleSet().getDomainMax()))) <= 0x3FFFFFFFL;
    }

    protected void computeRange() {
        this.getSolver();
        if (this.gr()) {
            this.computeRangeLong();
            return;
        }
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        if (xh3.getDomainSize() == 0) {
            this.cr = 0L;
            this.dr = 0L;
            this.er = 0L;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        if (this.gq.isBound()) {
            int n2 = 0;
            IlcIterator ilcIterator = xh2.getIterator();
            while (ilcIterator.hasNext()) {
                n2 += ilcIterator.nextValue();
            }
            this.cr = n2;
            this.dr = n2;
            this.er = n2;
            this.ljb = n2;
            this.mjb = n2;
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        IlcIterator ilcIterator = xh3.getIterator();
        while (ilcIterator.hasNext()) {
            int n6 = ilcIterator.nextValue();
            if (xh2.isInSet(n6)) {
                n3 += n6;
                continue;
            }
            if (n6 < 0) {
                n4 += n6;
                continue;
            }
            n5 += n6;
        }
        this.cr = n3;
        this.dr = n3 + n4;
        this.er = n3 + n5;
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        int n7 = xh2.getCardinal();
        int n8 = ilcPIntAbstractVar.getDomainMin() - n7;
        int n9 = ilcPIntAbstractVar.getDomainMax() - n7;
        int n10 = xh3.getDomainMin();
        n10 = n10 < 0 ? (n10 *= n9) : (n10 *= n8);
        int n11 = xh3.getDomainMax();
        n11 = n11 < 0 ? (n11 *= n8) : (n11 *= n9);
        this.ljb = Math.max((int)this.dr, n10 += n3);
        this.mjb = Math.min((int)this.er, n11 += n3);
    }

    protected void computeRangeLong() {
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        if (xh3.getDomainSize() == 0) {
            this.cr = 0L;
            this.dr = 0L;
            this.er = 0L;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        if (this.gq.isBound()) {
            long l2 = 0L;
            IlcIterator ilcIterator = xh2.getIterator();
            while (ilcIterator.hasNext()) {
                l2 += (long)ilcIterator.nextValue();
            }
            this.cr = l2;
            this.dr = l2;
            this.er = l2;
            this.mjb = this.ljb = ys.safeCastLong(l2);
            return;
        }
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        IlcIterator ilcIterator = xh3.getIterator();
        while (ilcIterator.hasNext()) {
            int n2 = ilcIterator.nextValue();
            if (xh2.isInSet(n2)) {
                l3 += (long)n2;
                continue;
            }
            if (n2 < 0) {
                l4 += (long)n2;
                continue;
            }
            l5 += (long)n2;
        }
        this.cr = l3;
        this.dr = l3 + l4;
        this.er = l3 + l5;
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        int n3 = xh2.getCardinal();
        long l6 = ilcPIntAbstractVar.getDomainMin() - n3;
        long l7 = ilcPIntAbstractVar.getDomainMax() - n3;
        long l8 = xh3.getDomainMin();
        long l9 = l8 < 0L ? l8 * l7 + l3 : l8 * l6 + l3;
        long l10 = xh3.getDomainMax();
        if (l10 < 0L) {
            long l11 = l10 * l6 + l3;
        } else {
            long l12 = l10 * l7 + l3;
        }
        this.safeSetBoundsLong(Math.max(this.dr, l9), Math.min(this.er, l9));
    }

    protected void setRangeInternal(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        this.getSolver();
        this.fq();
        this.getSolver();
        if (this.gr()) {
            this.setRangeInternalLong(n2, n3);
            return;
        }
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n11 = this.ljb;
        int n12 = this.mjb;
        int n13 = (int)this.cr;
        if (n3 < n12) {
            n10 = n3 - (int)this.dr;
            if (n10 < 0) {
                this.getSolver().fail();
            } else {
                n9 = xh3.getCardinal();
                if (n9 == 0) {
                    return;
                }
                n8 = xh3.getDomainMax();
                n7 = 0;
                while (n7 < n9) {
                    if (n8 <= n10) break;
                    if (!xh2.isInSet(n8)) {
                        this.gq.removeDomainPossible(n8);
                    }
                    n8 = xh3.getNextLower(n8);
                    ++n7;
                }
                n8 = xh3.getDomainMin();
                n7 = 0;
                while (n7 < n9) {
                    if (-n8 <= n10) break;
                    if (!xh2.isInSet(n8)) {
                        this.gq.addDomainRequired(n8);
                        n13 += n8;
                    }
                    n8 = xh3.getNextHigher(n8);
                    ++n7;
                }
                n6 = xh2.getCardinal();
                n5 = xh3.getDomainMin();
                if (n5 < 0) {
                    n4 = (n3 - n13 + n5 + 1) / n5;
                    if (n4 > 0) {
                        this.gq.getCardinality().setDomainMin(n6 + n4);
                    }
                } else if (n5 > 0 && (n4 = (n3 - n13) / n5) >= 0) {
                    this.gq.getCardinality().setDomainMax(n6 + n4);
                }
            }
        }
        if (n2 > n11) {
            n10 = (int)this.er - n2;
            if (n10 < 0) {
                this.getSolver().fail();
            } else {
                n9 = xh3.getCardinal();
                if (n9 == 0) {
                    return;
                }
                n8 = xh3.getDomainMax();
                n7 = 0;
                while (n7 < n9) {
                    if (n8 <= n10) break;
                    if (!xh2.isInSet(n8)) {
                        this.gq.addDomainRequired(n8);
                        n13 += n8;
                    }
                    n8 = xh3.getNextLower(n8);
                    ++n7;
                }
                n8 = xh3.getDomainMin();
                n7 = 0;
                while (n7 < n9) {
                    if (-n8 <= n10) break;
                    if (!xh2.isInSet(n8)) {
                        this.gq.removeDomainPossible(n8);
                    }
                    n8 = xh3.getNextHigher(n8);
                    ++n7;
                }
                n6 = xh2.getCardinal();
                n5 = xh3.getDomainMax();
                if (n5 < 0) {
                    n4 = (n2 - n13) / n5;
                    if (n4 >= 0) {
                        this.gq.getCardinality().setDomainMax(n6 + n4);
                    }
                } else if (n5 > 0 && (n4 = (n2 - n13 + n5 - 1) / n5) > 0) {
                    this.gq.getCardinality().setDomainMin(n6 + n4);
                }
            }
        }
    }

    protected void setRangeInternalLong(long l2, long l3) {
        long l4;
        long l5;
        long l6;
        int n2;
        int n3;
        int n4;
        long l7;
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n5 = this.ljb;
        int n6 = this.mjb;
        long l8 = this.cr;
        if (l3 < (long)n6) {
            l7 = l3 - this.dr;
            if (l7 < 0L) {
                this.getSolver().fail();
            } else {
                n4 = xh3.getCardinal();
                if (n4 == 0) {
                    return;
                }
                n3 = xh3.getDomainMax();
                n2 = 0;
                while (n2 < n4) {
                    if ((long)n3 <= l7) break;
                    if (!xh2.isInSet(n3)) {
                        this.gq.removeDomainPossible(n3);
                    }
                    n3 = xh3.getNextLower(n3);
                    ++n2;
                }
                n3 = xh3.getDomainMin();
                n2 = 0;
                while (n2 < n4) {
                    if (-((long)n3) <= l7) break;
                    if (!xh2.isInSet(n3)) {
                        this.gq.addDomainRequired(n3);
                        l8 += (long)n3;
                    }
                    n3 = xh3.getNextHigher(n3);
                    ++n2;
                }
                l6 = xh2.getCardinal();
                l5 = xh3.getDomainMin();
                if (l5 < 0L) {
                    l4 = (l3 - l8 + l5 + 1L) / l5;
                    if (l4 > 0L) {
                        this.gq.getCardinality().setDomainMinLong(l6 + l4);
                    }
                } else if (l5 > 0L && (l4 = (l3 - l8) / l5) > 0L) {
                    this.gq.getCardinality().setDomainMaxLong(l6 + l4);
                }
            }
        }
        if (l2 > (long)n5) {
            l7 = this.er - l2;
            if (l7 < 0L) {
                this.getSolver().fail();
            } else {
                n4 = xh3.getCardinal();
                if (n4 == 0) {
                    return;
                }
                n3 = xh3.getDomainMax();
                n2 = 0;
                while (n2 < n4) {
                    if ((long)n3 <= l7) break;
                    if (!xh2.isInSet(n3)) {
                        this.gq.addDomainRequired(n3);
                        l8 += (long)n3;
                    }
                    n3 = xh3.getNextLower(n3);
                    ++n2;
                }
                n3 = xh3.getDomainMin();
                n2 = 0;
                while (n2 < n4) {
                    if (-((long)n3) <= l7) break;
                    if (!xh2.isInSet(n3)) {
                        this.gq.removeDomainPossible(n3);
                    }
                    n3 = xh3.getNextHigher(n3);
                    ++n2;
                }
                l6 = xh2.getCardinal();
                l5 = xh3.getDomainMax();
                if (l5 < 0L) {
                    l4 = (l2 - l8) / l5;
                    if (l4 > 0L) {
                        this.gq.getCardinality().setDomainMaxLong(l6 + l4);
                    }
                } else if (l5 > 0L && (l4 = (l2 - l8 + l5 - 1L) / l5) > 0L) {
                    this.gq.getCardinality().setDomainMinLong(l6 + l4);
                }
            }
        }
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected void removeValueInternal(int n2) {
    }

    protected void removeIntervalInternal(int n2, int n3) {
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcPSumSet:[");
        stringBuffer.append(this.getDomainMin());
        stringBuffer.append("..");
        stringBuffer.append(this.getDomainMax());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

