/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloNumExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcFloat;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.nm;
import ilog.solver.ys;

final class ag
extends IlcConstraint {
    protected IlcNumExpr _pv;
    protected IlcNumExpr _cv;
    protected IlcNumExpr _rv;
    protected IlcNumExpr _gr;
    protected IlcIntExpr _n;
    protected IlcIntExpr _type;
    protected double _fraction;

    ag(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2, IloNumExpr iloNumExpr3, IloNumExpr iloNumExpr4, IloIntExpr iloIntExpr, IloIntExpr iloIntExpr2, double d2) {
        this._pv = (IlcNumExpr)iloNumExpr;
        this._cv = (IlcNumExpr)iloNumExpr2;
        this._rv = (IlcNumExpr)iloNumExpr3;
        this._gr = (IlcNumExpr)iloNumExpr4;
        this._n = (IlcIntExpr)iloIntExpr;
        this._type = (IlcIntExpr)iloIntExpr2;
        this._fraction = d2;
    }

    public IlcNumExpr getPV() {
        return this._pv;
    }

    public IlcNumExpr getCV() {
        return this._cv;
    }

    public IlcNumExpr getRV() {
        return this._rv;
    }

    public IlcNumExpr getGR() {
        return this._gr;
    }

    public IlcIntExpr getN() {
        return this._n;
    }

    public IlcIntExpr getType() {
        return this._type;
    }

    public double getFraction() {
        return this._fraction;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._pv.getPNumExp(ilcSolver);
        nm nm3 = this._cv.getPNumExp(ilcSolver);
        nm nm4 = this._rv.getPNumExp(ilcSolver);
        nm nm5 = this._gr.getPNumExp(ilcSolver);
        ys ys2 = this._n.getPIntExp(ilcSolver);
        ys ys3 = this._type.getPIntExp(ilcSolver);
        return new dm(nm2, nm3, nm4, nm5, ys2, ys3, this._fraction);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("presentValue(");
        stringBuffer.append(this._pv);
        stringBuffer.append(", ");
        stringBuffer.append(this._cv);
        stringBuffer.append(", ");
        stringBuffer.append(this._rv);
        stringBuffer.append(", ");
        stringBuffer.append(this._gr);
        stringBuffer.append(", ");
        stringBuffer.append(this._n);
        stringBuffer.append(", ");
        stringBuffer.append(this._type);
        stringBuffer.append(", ");
        stringBuffer.append(this._fraction);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.presentValue((IloNumExpr)iloCopyManager.getCopy(this._pv), (IloNumExpr)iloCopyManager.getCopy(this._cv), (IloNumExpr)iloCopyManager.getCopy(this._rv), (IloNumExpr)iloCopyManager.getCopy(this._gr), (IloIntExpr)iloCopyManager.getCopy(this._n), (IloIntExpr)iloCopyManager.getCopy(this._type), this._fraction);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._pv.needCopy(check);
        this._cv.needCopy(check);
        this._rv.needCopy(check);
        this._gr.needCopy(check);
        this._n.needCopy(check);
        this._type.needCopy(check);
    }

    static final class dm
    extends IlcPPropagator {
        final nm tz;
        final nm uz;
        final nm vz;
        final nm wz;
        final ys xz;
        final ys yz;
        final double zz;

        public dm(nm nm2, nm nm3, nm nm4, nm nm5, ys ys2, ys ys3, double d2) {
            this.tz = nm2;
            nm2.kn();
            this.uz = nm3;
            nm3.kn();
            this.vz = nm4;
            nm4.kn();
            this.wz = nm5;
            nm5.kn();
            this.xz = ys2;
            ys2.kn();
            this.yz = ys3;
            ys3.kn();
            this.zz = d2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.tz.whenRange(ilcDemon);
            this.uz.whenRange(ilcDemon);
            this.vz.whenRange(ilcDemon);
            this.wz.whenRange(ilcDemon);
            this.xz.whenRange(ilcDemon);
            this.yz.whenRange(ilcDemon);
        }

        public void post() {
            this.tz.whenRange(this);
            this.uz.whenRange(this);
            this.vz.whenRange(this);
            this.wz.whenRange(this);
            this.xz.whenRange(this);
            this.yz.whenRange(this);
        }

        public void propagate() {
            int n2;
            int n3;
            int n4;
            int n5;
            this.tz.setDomainLB(0.0);
            this.uz.setDomainLB(0.0);
            this.vz.setDomainLB(0.0);
            this.wz.setDomainLB(0.0);
            this.xz.setDomainMin(0);
            this.yz.setDomainMin(0);
            this.yz.setDomainMax(1);
            double d2 = this.tz.getDomainLB();
            double d3 = this.tz.getDomainUB();
            double d4 = this.uz.getDomainLB();
            double d5 = this.uz.getDomainUB();
            double d6 = this.vz.getDomainLB();
            double d7 = this.vz.getDomainUB();
            double d8 = this.wz.getDomainLB();
            double d9 = this.wz.getDomainUB();
            int n6 = this.xz.getDomainMin();
            int n7 = this.xz.getDomainMax();
            int n8 = this.yz.getDomainMin();
            int n9 = this.yz.getDomainMax();
            double d10 = IlcFloat.discountedSumDown(d9, n6, n8);
            double d11 = IlcFloat.discountedFactorDown(d9);
            double d12 = IlcFloat.discountedSumUp(d8, n7, n9);
            double d13 = IlcFloat.discountedFactorUp(d8);
            double d14 = IlcFloat.roundDown(d4 * d10);
            double d15 = IlcFloat.roundDown(d6 * d11);
            double d16 = IlcFloat.roundDown(d14 + d15);
            double d17 = IlcFloat.roundUp(d5 * d12);
            double d18 = IlcFloat.roundUp(d7 * d13);
            double d19 = IlcFloat.roundUp(d17 + d18);
            this.tz.setDomainRange(d16, d19);
            d2 = this.tz.getDomainLB();
            d3 = this.tz.getDomainUB();
            double d20 = IlcFloat.roundDown(d2 - IlcFloat.roundUp(d7 * d13));
            double d21 = IlcFloat.roundDown(d20 / d12);
            double d22 = IlcFloat.roundUp(d3 - IlcFloat.roundDown(d6 * d11));
            double d23 = IlcFloat.roundUp(d22 / d10);
            this.uz.setDomainRange(d21, d23);
            d4 = this.uz.getDomainLB();
            d5 = this.uz.getDomainUB();
            double d24 = IlcFloat.roundDown(d2 - IlcFloat.roundUp(d5 * d12));
            double d25 = IlcFloat.roundDown(d24 / d13);
            double d26 = IlcFloat.roundUp(d3 - IlcFloat.roundDown(d4 * d10));
            double d27 = IlcFloat.roundUp(d26 / d11);
            this.vz.setDomainRange(d25, d27);
            d6 = this.vz.getDomainLB();
            d7 = this.vz.getDomainUB();
            if (!this.xm(d2, d3, d4, d5, d6, d7, d8, d9, n6, n7, n8, n8)) {
                this.yz.setDomainMin(n9);
            }
            if (!this.xm(d2, d3, d4, d5, d6, d7, d8, d9, n6, n7, n9, n9)) {
                this.yz.setDomainMax(n8);
            }
            if (!this.xm(d2, d3, d4, d5, d6, d7, d8, d9, n5 = n6, n4 = n7, n8 = this.yz.getDomainMin(), n9 = this.yz.getDomainMax())) {
                this.xz.getSolver().fail();
            }
            if (this.ym(d2, d5, d7, d8, n5, n9) > 0.0) {
                n3 = n4 - n5;
                do {
                    n3 = n3 <= 1 ? 1 : n3 / 2;
                    n2 = n5;
                    while (n2 + 1 <= n4 && this.ym(d2, d5, d7, d8, n2, n9) > 0.0) {
                        n5 = n2 + 1;
                        n2 += n3;
                    }
                } while (n3 != 1);
            }
            if (this.zm(d3, d4, d6, d9, n4, n8) < 0.0) {
                n3 = n4 - n5;
                do {
                    n3 = n3 <= 1 ? 1 : n3 / 2;
                    n2 = n4;
                    while (n5 <= n2 - 1 && this.zm(d3, d4, d6, d9, n2, n8) < 0.0) {
                        n4 = n2 - 1;
                        n2 -= n3;
                    }
                } while (n3 != 1);
            }
            this.xz.setDomainRange(n5, n4);
            n6 = this.xz.getDomainMin();
            n7 = this.xz.getDomainMax();
            double d28 = d8;
            double d29 = d9;
            double d30 = 1.0;
            if (!this.xm(d2, d3, d4, d5, d6, d7, d28, d29, n6, n7, n8, n9)) {
                this.wz.getSolver().fail();
            }
            double d31 = d29;
            if (this.zm(d3, d4, d6, d28, n6, n8) < 0.0) {
                double d32;
                while (!((d32 = 0.5 * d28 + 0.5 * d31) <= d28) && !(d31 <= d32)) {
                    if (this.zm(d3, d4, d6, d32, n6, n8) < 0.0) {
                        d28 = d32;
                    } else {
                        d31 = d32;
                    }
                    if (!(d31 - d28 < this.zz * (d9 - d8)) && this.wz.propagationCastUp(d28) < this.wz.propagationCastDown(d31)) continue;
                }
            }
            double d33 = d28;
            if (this.ym(d2, d5, d7, d29, n7, n9) > 0.0) {
                double d34;
                while (!((d34 = 0.5 * d33 + 0.5 * d29) <= d33) && !(d29 <= d34)) {
                    if (this.ym(d2, d5, d7, d34, n7, n9) > 0.0) {
                        d29 = d34;
                    } else {
                        d33 = d34;
                    }
                    if (!(d29 - d33 < this.zz * (d9 - d8)) && this.wz.propagationCastUp(d33) < this.wz.propagationCastDown(d29)) continue;
                }
            }
            this.wz.setDomainRange(d28, d29);
        }

        final boolean xm(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2, int n3, int n4, int n5) {
            boolean bl2 = this.ym(d2, d5, d7, d8, n3, n5) <= 0.0 && 0.0 <= this.zm(d3, d4, d6, d9, n2, n4);
            return bl2;
        }

        final double ym(double d2, double d3, double d4, double d5, int n2, int n3) {
            double d6 = IlcFloat.roundUp(d3 * IlcFloat.discountedSumUp(d5, n2, n3));
            double d7 = IlcFloat.roundUp(d4 * IlcFloat.discountedFactorUp(d5));
            return IlcFloat.roundDown(d2 - IlcFloat.roundUp(d6 + d7));
        }

        final double zm(double d2, double d3, double d4, double d5, int n2, int n3) {
            double d6 = IlcFloat.roundDown(d3 * IlcFloat.discountedSumDown(d5, n2, n3));
            double d7 = IlcFloat.roundDown(d4 * IlcFloat.discountedFactorDown(d5));
            return IlcFloat.roundUp(d2 - IlcFloat.roundDown(d6 + d7));
        }

        final double wm(double d2, double d3, double d4, double d5, int n2, int n3) {
            double d6 = IlcFloat.roundDown(1.0 + d5);
            double d7 = IlcFloat.discountedSumDerivUp(d5, n2, n3);
            double d8 = IlcFloat.roundUp(IlcFloat.roundUp(d3 * d7) / d6);
            double d9 = IlcFloat.roundUp(d4 / IlcFloat.roundDown(d6 * d6));
            return IlcFloat.roundUp(d8 + d9);
        }

        public boolean isViolated() {
            int n2;
            int n3;
            int n4;
            int n5;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.tz.getDomainLB();
            return !this.xm(d9, d8 = this.tz.getDomainUB(), d7 = this.uz.getDomainLB(), d6 = this.uz.getDomainUB(), d5 = this.vz.getDomainLB(), d4 = this.vz.getDomainUB(), d3 = this.wz.getDomainLB(), d2 = this.wz.getDomainUB(), n5 = this.xz.getDomainMin(), n4 = this.xz.getDomainMax(), n3 = this.yz.getDomainMin(), n2 = this.yz.getDomainMax());
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("presentValue(");
            stringBuffer.append(this.tz);
            stringBuffer.append(", ");
            stringBuffer.append(this.uz);
            stringBuffer.append(", ");
            stringBuffer.append(this.vz);
            stringBuffer.append(", ");
            stringBuffer.append(this.wz);
            stringBuffer.append(", ");
            stringBuffer.append(this.xz);
            stringBuffer.append(", ");
            stringBuffer.append(this.yz);
            stringBuffer.append(", ");
            stringBuffer.append(this.zz);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

