/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcNum;
import ilog.solver.IlcSolverRuntimeError;
import java.math.BigDecimal;

public final class IlcDec {
    private int rr;
    static final double[] sr = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15};
    static final double tr = 9.99999999999999E14;
    static final double ur = -9.99999999999999E14;

    IlcDec(int n2) {
        this.setPrecision(n2);
    }

    public void setPrecision(int n2) {
        if (n2 < 0) {
            throw new IlcSolverRuntimeError.sr("scale is negative.");
        }
        if (15 < n2) {
            throw new IlcSolverRuntimeError.sr("scale is too high.");
        }
        this.rr = n2;
    }

    public int getPrecision() {
        return this.rr;
    }

    public static final double divide(double d2, double d3) {
        return d2 / d3;
    }

    public static final double divideRoundUp(double d2, double d3) {
        if (d3 == 1.0) {
            return d2;
        }
        if (d3 == -1.0) {
            return -d2;
        }
        return IlcNum.roundUp(d2 / d3);
    }

    public static final double divideRoundDown(double d2, double d3) {
        if (d3 == 1.0) {
            return d2;
        }
        if (d3 == -1.0) {
            return -d2;
        }
        return IlcNum.roundDown(d2 / d3);
    }

    public static final double getValueLB(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n2 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + string);
        }
        return IlcDec.divideRoundDown(d2, sr[n2]);
    }

    public static final double getValueLB(String string, int n2) {
        BigDecimal bigDecimal = new BigDecimal(string).setScale(n2, 1);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n3 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n3) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + string);
        }
        return IlcDec.divideRoundDown(d2, sr[n3]);
    }

    public static final double getValueUB(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n2 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + string);
        }
        return IlcDec.divideRoundUp(d2, sr[n2]);
    }

    public static final double getValueUB(String string, int n2) {
        BigDecimal bigDecimal = new BigDecimal(string).setScale(n2, 1);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n3 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n3) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + string);
        }
        return IlcDec.divideRoundUp(d2, sr[n3]);
    }

    public static final int getValuePrecision(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n2 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + string);
        }
        return n2;
    }

    public static final boolean hasSamePrecision(String[] stringArray) {
        BigDecimal bigDecimal = new BigDecimal(stringArray[0]);
        double d2 = bigDecimal.unscaledValue().doubleValue();
        int n2 = bigDecimal.scale();
        if (Math.abs(d2) > 9.99999999999999E14 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + stringArray[0]);
        }
        int n3 = 1;
        while (n3 < stringArray.length) {
            bigDecimal = new BigDecimal(stringArray[1]);
            d2 = bigDecimal.unscaledValue().doubleValue();
            if (Math.abs(d2) > 9.99999999999999E14) {
                throw new IlcSolverRuntimeError.sr("Decimal too large " + stringArray[n3]);
            }
            if (n2 != bigDecimal.scale()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final double getValueLB(long l2, int n2) {
        double d2 = l2;
        if ((double)Math.abs(l2) > 9.99999999999999E14 || n2 < 0 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Bad Decimal " + l2 + "," + n2);
        }
        return IlcDec.divideRoundDown(l2, sr[n2]);
    }

    public static final double getValueUB(long l2, int n2) {
        double d2 = l2;
        if ((double)Math.abs(l2) > 9.99999999999999E14 || n2 < 0 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Bad Decimal " + l2 + "," + n2);
        }
        return IlcDec.divideRoundUp(l2, sr[n2]);
    }

    public static final String getValueString(double d2, double d3, int n2) {
        String string;
        if (n2 < 0 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Bad Scale " + n2);
        }
        String string2 = IlcDec.toStringUp(d2, n2);
        if (!string2.equals(string = IlcDec.toStringDown(d3, n2))) {
            throw new IlcSolverRuntimeError.sr("Value String: Internal Error");
        }
        return string;
    }

    public final double nextUp(double d2) {
        return IlcDec.castUp(IlcNum.roundUp(d2, 2L), this.rr);
    }

    public static final double nextUp(double d2, int n2) {
        return IlcDec.castUp(IlcNum.roundUp(d2, 2L), n2);
    }

    public final double nextDown(double d2) {
        return IlcDec.castDown(IlcNum.roundDown(d2, 2L), this.rr);
    }

    public static final double nextDown(double d2, int n2) {
        return IlcDec.castDown(IlcNum.roundDown(d2, 2L), n2);
    }

    public final boolean isBound(double d2, double d3) {
        return IlcNum.roundUp(d2, 3L) >= d3;
    }

    public final double getDecMax() {
        return IlcDec.getDecMax(this.rr);
    }

    public static final double getDecMax(int n2) {
        return IlcDec.divideRoundUp(9.99999999999999E14, sr[n2]);
    }

    public final double getDecMin() {
        return IlcDec.getDecMin(this.rr);
    }

    public static final double getDecMin(int n2) {
        return IlcDec.divideRoundDown(-9.99999999999999E14, sr[n2]);
    }

    public final double getDecExtMax() {
        return IlcDec.getDecExtMax(this.rr);
    }

    public static final double getDecExtMax(int n2) {
        return sr[15 - n2];
    }

    public final double getDecExtMin() {
        return IlcDec.getDecExtMin(this.rr);
    }

    public static final double getDecExtMin(int n2) {
        return -sr[15 - n2];
    }

    public final double castUp(double d2) {
        return d2 >= 0.0 ? IlcDec.castUp(d2, this.rr) : -IlcDec.castDown(-d2, this.rr);
    }

    public final double castDown(double d2) {
        return d2 >= 0.0 ? IlcDec.castDown(d2, this.rr) : -IlcDec.castUp(-d2, this.rr);
    }

    public final synchronized String toStringUp(double d2) {
        return IlcDec.toStringUp(d2, this.rr);
    }

    public static final synchronized String toStringUp(double d2, int n2) {
        return d2 >= 0.0 ? IlcDec.toStringUp("", d2, n2) : IlcDec.toStringDown("-", -d2, n2);
    }

    public final synchronized String toStringDown(double d2) {
        return IlcDec.toStringDown(d2, this.rr);
    }

    public static final synchronized String toStringDown(double d2, int n2) {
        return d2 >= 0.0 ? IlcDec.toStringDown("", d2, n2) : IlcDec.toStringUp("-", -d2, n2);
    }

    public static final double castUp(double d2, int n2) {
        double d3 = IlcDec.unscaledCastUp(d2, n2);
        return IlcDec.divideRoundDown(d3, sr[n2]);
    }

    public static final double castDown(double d2, int n2) {
        double d3 = IlcDec.unscaledCastDown(d2, n2);
        return IlcDec.divideRoundUp(d3, sr[n2]);
    }

    public static final int compareExact(double d2, double d3, int n2) {
        BigDecimal bigDecimal = new BigDecimal(d2);
        BigDecimal bigDecimal2 = new BigDecimal(d3);
        return bigDecimal.movePointLeft(n2).compareTo(bigDecimal2);
    }

    public final synchronized String unscaledToString(double d2) {
        return IlcDec.unscaledToString(d2, this.rr);
    }

    public static final synchronized String unscaledToString(double d2, int n2) {
        return d2 >= 0.0 ? IlcDec.toString(d2, n2) : "-" + IlcDec.toString(-d2, n2);
    }

    public final double unscaledCastUp(double d2) {
        return IlcDec.unscaledCastUp(d2, this.rr);
    }

    public static final double unscaledCastUp(double d2, int n2) {
        double d3 = sr[n2];
        double d4 = d2 * d3;
        double d5 = Math.ceil(d4);
        if (d5 == d4 && IlcDec.compareExact(d5, d2, n2) < 0) {
            d5 += 1.0;
        }
        return d5;
    }

    public final double unscaledCastDown(double d2) {
        return IlcDec.unscaledCastDown(d2, this.rr);
    }

    public static final double unscaledCastDown(double d2, int n2) {
        double d3 = sr[n2];
        double d4 = d2 * d3;
        double d5 = Math.floor(d4);
        if (d5 == d4 && IlcDec.compareExact(d5, d2, n2) > 0) {
            d5 -= 1.0;
        }
        return d5;
    }

    public final double getScaled(double d2) {
        return IlcDec.getScaled(d2, this.rr);
    }

    public static final double getScaled(double d2, int n2) {
        return IlcDec.divide(d2, sr[n2]);
    }

    public final double getScaledLB(double d2) {
        return IlcDec.getScaledLB(d2, this.rr);
    }

    public static final double getScaledLB(double d2, int n2) {
        return IlcDec.divideRoundDown(d2, sr[n2]);
    }

    public final double getScaledUB(double d2) {
        return IlcDec.getScaledUB(d2, this.rr);
    }

    public static final double getScaledUB(double d2, int n2) {
        return IlcDec.divideRoundUp(d2, sr[n2]);
    }

    public final double getScaledRoundLB(double d2) {
        return IlcDec.getScaledRoundLB(d2, this.rr);
    }

    public final double getScaledRoundUB(double d2) {
        return IlcDec.getScaledRoundUB(d2, this.rr);
    }

    public static final double getScaledRoundLB(double d2, int n2) {
        double d3 = sr[n2];
        return IlcDec.divideRoundDown(d2 * 10.0 - 5.0, d3 * 10.0);
    }

    public static final double getScaledRoundUB(double d2, int n2) {
        double d3 = sr[n2];
        return IlcDec.divideRoundUp(d2 * 10.0 + 5.0, d3 * 10.0);
    }

    public static final long round(double d2, int n2) {
        if (n2 < 0 || 15 < n2) {
            throw new IlcSolverRuntimeError.sr("Bad scale " + n2);
        }
        double d3 = IlcDec.unscaledRoundInternal(d2, n2);
        if (Math.abs(d3) > 9.99999999999999E14) {
            throw new IlcSolverRuntimeError.sr("Decimal too large " + d2 + "," + n2);
        }
        return (long)d3;
    }

    public final double unscaledRoundInternal(double d2) {
        return IlcDec.unscaledRoundInternal(d2, this.rr);
    }

    public static final double unscaledRoundInternal(double d2, int n2) {
        double d3 = sr[n2];
        double d4 = d2 * d3;
        double d5 = Math.round(d4);
        if (d5 < d4 && d5 != (double)Math.round(IlcNum.roundUp(d4)) || d5 > d4 && d5 != (double)Math.round(IlcNum.roundDown(d4))) {
            BigDecimal bigDecimal = new BigDecimal(d2);
            BigDecimal bigDecimal2 = bigDecimal.signum() > 0 ? bigDecimal.setScale(n2, 4) : bigDecimal.setScale(n2, 5);
            d5 = bigDecimal2.unscaledValue().doubleValue();
        }
        return d5;
    }

    public final double roundThresholdDown(double d2) {
        return IlcDec.roundThresholdDown(d2, this.rr);
    }

    public static final double roundThresholdDown(double d2, int n2) {
        double d3 = sr[n2];
        double d4 = d2 * d3;
        double d5 = Math.round(d4);
        return IlcDec.divideRoundDown(d5 * 10.0 - 5.0, d3 * 10.0);
    }

    public final double roundThresholdUp(double d2) {
        return IlcDec.roundThresholdUp(d2, this.rr);
    }

    public static final double roundThresholdUp(double d2, int n2) {
        double d3 = sr[n2];
        double d4 = d2 * d3;
        double d5 = Math.round(d4);
        return IlcDec.divideRoundUp(d5 * 10.0 + 5.0, d3 * 10.0);
    }

    public static final synchronized String toStringUp(String string, double d2, int n2) {
        double d3 = IlcDec.unscaledCastUp(d2, n2);
        return d3 != 0.0 ? string + IlcDec.toString(d3, n2) : IlcDec.toString(d3, n2);
    }

    public static final synchronized String toStringDown(String string, double d2, int n2) {
        double d3 = IlcDec.unscaledCastDown(d2, n2);
        return d3 != 0.0 ? string + IlcDec.toString(d3, n2) : IlcDec.toString(d3, n2);
    }

    public static final synchronized String toString(double d2, int n2) {
        String string = Long.toString((long)d2);
        int n3 = string.length();
        if (n3 > n2) {
            return string.substring(0, n3 - n2) + "." + string.substring(n3 - n2, n3);
        }
        int n4 = 0;
        while (n4 < n2 - n3) {
            string = "0" + string;
            ++n4;
        }
        return "0." + string;
    }
}

