/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert;

import ilog.concert.IloException;
import ilog.concert.IloStorable;
import java.util.HashMap;
import java.util.Iterator;

public abstract class IloSolution {
    protected HashMap _map = new HashMap();

    public abstract Element makeSolutionElement(IloStorable var1) throws IloException;

    public void add(IloStorable iloStorable) throws IloException {
        this._map.put(iloStorable, this.makeSolutionElement(iloStorable));
    }

    public void add(IloStorable[] iloStorableArray) throws IloException {
        int n2 = 0;
        while (n2 < iloStorableArray.length) {
            this._map.put(iloStorableArray[n2], this.makeSolutionElement(iloStorableArray[n2]));
            ++n2;
        }
    }

    public void remove(IloStorable iloStorable) {
        this._map.remove(iloStorable);
    }

    public Element get(IloStorable iloStorable) {
        return (Element)this._map.get(iloStorable);
    }

    public boolean contains(IloStorable iloStorable) {
        return this._map.containsKey(iloStorable);
    }

    public Iterator storableIterator() {
        return this._map.keySet().iterator();
    }

    public Iterator elementsIterator() {
        return this._map.values().iterator();
    }

    public void store() {
        Iterator iterator = this.elementsIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.store();
        }
    }

    public void restore() {
        Iterator iterator = this.elementsIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.restore();
        }
    }

    public void commit() {
        Iterator iterator = this.elementsIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.commit();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Solution : \n");
        Iterator iterator = this.elementsIterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static interface Element {
        public void store();

        public void restore();

        public void commit();

        public IloStorable getStorable();
    }
}

