/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.CodeBuilder;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.TypeDescriptor;
import com.go.trove.util.ClassInjector;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.codegen.RSClassLoader;
import uchicago.src.sim.analysis.BinDataSource;
import uchicago.src.sim.analysis.DataSource;
import uchicago.src.sim.analysis.NumericDataSource;
import uchicago.src.sim.analysis.Sequence;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.ObjectPicker;
import uchicago.src.sim.engine.StatCalculator;

public class ByteCodeBuilder {
    private static int id = 0;
    public static RSClassLoader loader;

    private static synchronized String getUnqName() {
        return "BAB_SYNTH_" + ++id;
    }

    private static Method getMethod(Class clazz, String string) throws GeneratorException {
        return ByteCodeBuilder.getMethod(clazz, string, null);
    }

    private static Method getMethod(Class clazz, String string, Class clazz2) throws GeneratorException {
        Method method;
        try {
            Class<?> clazz3;
            method = clazz.getMethod(string, new Class[0]);
            if (clazz2 != null && !clazz2.isAssignableFrom(clazz3 = method.getReturnType())) {
                throw new GeneratorException("Method " + string + "() must return a " + clazz2.getName(), null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getMethodRetDouble(Class clazz, String string, Class[] classArray) throws GeneratorException {
        Method method;
        HashSet<Class<Number>> hashSet = new HashSet<Class<Number>>();
        hashSet.add(Integer.TYPE);
        hashSet.add(Long.TYPE);
        hashSet.add(Double.TYPE);
        hashSet.add(Float.TYPE);
        try {
            method = clazz.getMethod(string, classArray);
            Class<?> clazz2 = method.getReturnType();
            if (!hashSet.contains(clazz2)) {
                throw new GeneratorException("Method " + string + "() must return a number", null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getMethodObjDouble(Class clazz, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[]{Object.class});
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            throw new GeneratorException("Method " + string + " must have a " + "single parameter of type Object", null);
        }
        if (!Object.class.isAssignableFrom(classArray[0])) {
            throw new GeneratorException("Method " + string + " must have a " + "single parameter of type Object", null);
        }
        return method;
    }

    private static Method getBasicActionExecMethod() throws GeneratorException {
        Method method;
        try {
            method = BasicAction.class.getMethod("execute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getStatCalculatorExecMethod() throws GeneratorException {
        Method method;
        try {
            method = StatCalculator.class.getMethod("calc", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getObjectPickerExecMethod() throws GeneratorException {
        Method method;
        try {
            method = ObjectPicker.class.getMethod("pickObjects", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getDataSourceExecMethod() throws GeneratorException {
        Method method;
        try {
            method = DataSource.class.getMethod("execute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getNumericDataSourceExecMethod() throws GeneratorException {
        Method method;
        try {
            method = NumericDataSource.class.getMethod("execute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getSequenceSValueMethod() throws GeneratorException {
        Method method;
        try {
            method = Sequence.class.getMethod("getSValue", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    private static Method getBDSBinValueMethod() throws GeneratorException {
        Method method;
        try {
            method = BinDataSource.class.getMethod("getBinValue", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GeneratorException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        return method;
    }

    public static StatCalculator generateMinCalculator(List list, String string) throws GeneratorException {
        Class<?> clazz = list.get(0).getClass();
        return ByteCodeBuilder.generateMinCalculator(clazz, list, string);
    }

    public static StatCalculator generateMinCalculator(Class clazz, List list, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[0]);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), StatCalculator.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(List.class);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invokeSuperConstructor(new TypeDescriptor[]{typeDescriptor});
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getStatCalculatorExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(Double.TYPE);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(Object.class);
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable);
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("min", typeDescriptor3);
        codeBuilder.loadStaticField("java.lang.Double", "MAX_VALUE", typeDescriptor3);
        codeBuilder.storeLocal(localVariable2);
        LocalVariable localVariable3 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable3);
        Label label = codeBuilder.createLabel();
        codeBuilder.branch((Location)label);
        Label label2 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor5, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor4);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.invokeStatic("java.lang.Math", "min", typeDescriptor3, new TypeDescriptor[]{typeDescriptor3, typeDescriptor3});
        codeBuilder.storeLocal(localVariable2);
        codeBuilder.integerIncrement(localVariable3, 1);
        label.setLocation();
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.ifComparisonBranch((Location)label2, "<");
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createStatCalculator(classFile, list);
    }

    public static StatCalculator generateMaxCalculator(List list, String string) throws GeneratorException {
        Class<?> clazz = list.get(0).getClass();
        return ByteCodeBuilder.generateMaxCalculator(clazz, list, string);
    }

    public static StatCalculator generateMaxCalculator(Class clazz, List list, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[0]);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), StatCalculator.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(List.class);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invokeSuperConstructor(new TypeDescriptor[]{typeDescriptor});
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getStatCalculatorExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(Double.TYPE);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(Object.class);
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable);
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("max", typeDescriptor3);
        codeBuilder.loadStaticField("java.lang.Double", "MIN_VALUE", typeDescriptor3);
        codeBuilder.storeLocal(localVariable2);
        LocalVariable localVariable3 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable3);
        Label label = codeBuilder.createLabel();
        codeBuilder.branch((Location)label);
        Label label2 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor5, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor4);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.invokeStatic("java.lang.Math", "max", typeDescriptor3, new TypeDescriptor[]{typeDescriptor3, typeDescriptor3});
        codeBuilder.storeLocal(localVariable2);
        codeBuilder.integerIncrement(localVariable3, 1);
        label.setLocation();
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.ifComparisonBranch((Location)label2, "<");
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createStatCalculator(classFile, list);
    }

    public static StatCalculator generateAvgCalculator(List list, String string) throws GeneratorException {
        Class<?> clazz = list.get(0).getClass();
        return ByteCodeBuilder.generateAvgCalculator(clazz, list, string);
    }

    public static StatCalculator generateAvgCalculator(Class clazz, List list, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[0]);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), StatCalculator.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(List.class);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invokeSuperConstructor(new TypeDescriptor[]{typeDescriptor});
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getStatCalculatorExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(Double.TYPE);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(Object.class);
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable);
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("sum", typeDescriptor3);
        codeBuilder.loadConstant(0.0);
        codeBuilder.storeLocal(localVariable2);
        LocalVariable localVariable3 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable3);
        Label label = codeBuilder.createLabel();
        codeBuilder.branch((Location)label);
        Label label2 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor5, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor4);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.math((byte)99);
        codeBuilder.storeLocal(localVariable2);
        codeBuilder.integerIncrement(localVariable3, 1);
        label.setLocation();
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.ifComparisonBranch((Location)label2, "<");
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.convert(Integer.TYPE, Double.TYPE);
        codeBuilder.math((byte)111);
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createStatCalculator(classFile, list);
    }

    public static ObjectPicker generateMinObjectPicker(List list, String string) throws GeneratorException {
        Class<?> clazz = list.get(0).getClass();
        return ByteCodeBuilder.generateMinObjectPicker(clazz, list, string);
    }

    public static ObjectPicker generateMinObjectPicker(Class clazz, List list, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[0]);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), ObjectPicker.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(List.class);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invokeSuperConstructor(new TypeDescriptor[]{typeDescriptor});
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getObjectPickerExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(Double.TYPE);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(Object.class);
        TypeDescriptor typeDescriptor6 = new TypeDescriptor(ArrayList.class);
        TypeDescriptor typeDescriptor7 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor8 = new TypeDescriptor(Boolean.TYPE);
        codeBuilder = new CodeBuilder(methodInfo2);
        LocalVariable localVariable = codeBuilder.createLocalVariable("retVal", typeDescriptor);
        codeBuilder.newObject(typeDescriptor6);
        codeBuilder.dup();
        codeBuilder.invokeConstructor("java.util.ArrayList", null);
        codeBuilder.storeLocal(localVariable);
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable2);
        LocalVariable localVariable3 = codeBuilder.createLocalVariable("min", typeDescriptor3);
        codeBuilder.loadStaticField("java.lang.Double", "MAX_VALUE", typeDescriptor3);
        codeBuilder.storeLocal(localVariable3);
        LocalVariable localVariable4 = codeBuilder.createLocalVariable("item", typeDescriptor7);
        LocalVariable localVariable5 = codeBuilder.createLocalVariable("val", typeDescriptor3);
        Label label = codeBuilder.createLabel();
        Label label2 = codeBuilder.createLabel();
        LocalVariable localVariable6 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable6);
        Label label3 = codeBuilder.createLabel();
        codeBuilder.branch((Location)label3);
        Label label4 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.loadLocal(localVariable6);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor5, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor4);
        codeBuilder.storeLocal(localVariable4);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.dup2();
        codeBuilder.storeLocal(localVariable5);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.math((byte)-105);
        codeBuilder.ifZeroComparisonBranch((Location)label, ">=");
        codeBuilder.loadLocal(localVariable5);
        codeBuilder.storeLocal(localVariable3);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.invokeInterface("java.util.List", "clear", null, null);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invokeInterface("java.util.List", "add", typeDescriptor8, new TypeDescriptor[]{typeDescriptor5});
        codeBuilder.pop();
        codeBuilder.branch((Location)label2);
        label.setLocation();
        codeBuilder.loadLocal(localVariable5);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.math((byte)-105);
        codeBuilder.ifZeroComparisonBranch((Location)label2, "!=");
        codeBuilder.loadLocal(localVariable);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invokeInterface("java.util.List", "add", typeDescriptor8, new TypeDescriptor[]{typeDescriptor5});
        codeBuilder.pop();
        label2.setLocation();
        codeBuilder.integerIncrement(localVariable6, 1);
        label3.setLocation();
        codeBuilder.loadLocal(localVariable6);
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.ifComparisonBranch((Location)label4, "<");
        codeBuilder.loadLocal(localVariable);
        codeBuilder.returnValue(List.class);
        return ByteCodeBuilder.createObjectPicker(classFile, list);
    }

    public static ObjectPicker generateMaxObjectPicker(List list, String string) throws GeneratorException {
        Class<?> clazz = list.get(0).getClass();
        return ByteCodeBuilder.generateMaxObjectPicker(clazz, list, string);
    }

    public static ObjectPicker generateMaxObjectPicker(Class clazz, List list, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(clazz, string, new Class[0]);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), ObjectPicker.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(List.class);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invokeSuperConstructor(new TypeDescriptor[]{typeDescriptor});
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getObjectPickerExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(Double.TYPE);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(Object.class);
        TypeDescriptor typeDescriptor6 = new TypeDescriptor(ArrayList.class);
        TypeDescriptor typeDescriptor7 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor8 = new TypeDescriptor(Boolean.TYPE);
        codeBuilder = new CodeBuilder(methodInfo2);
        LocalVariable localVariable = codeBuilder.createLocalVariable("retVal", typeDescriptor);
        codeBuilder.newObject(typeDescriptor6);
        codeBuilder.dup();
        codeBuilder.invokeConstructor("java.util.ArrayList", null);
        codeBuilder.storeLocal(localVariable);
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable2);
        LocalVariable localVariable3 = codeBuilder.createLocalVariable("max", typeDescriptor3);
        codeBuilder.loadStaticField("java.lang.Double", "MIN_VALUE", typeDescriptor3);
        codeBuilder.storeLocal(localVariable3);
        LocalVariable localVariable4 = codeBuilder.createLocalVariable("item", typeDescriptor7);
        LocalVariable localVariable5 = codeBuilder.createLocalVariable("val", typeDescriptor3);
        Label label = codeBuilder.createLabel();
        Label label2 = codeBuilder.createLabel();
        LocalVariable localVariable6 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable6);
        Label label3 = codeBuilder.createLabel();
        codeBuilder.branch((Location)label3);
        Label label4 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("items", typeDescriptor);
        codeBuilder.loadLocal(localVariable6);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor5, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor4);
        codeBuilder.storeLocal(localVariable4);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.dup2();
        codeBuilder.storeLocal(localVariable5);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.math((byte)-105);
        codeBuilder.ifZeroComparisonBranch((Location)label, "<=");
        codeBuilder.loadLocal(localVariable5);
        codeBuilder.storeLocal(localVariable3);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.invokeInterface("java.util.List", "clear", null, null);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invokeInterface("java.util.List", "add", typeDescriptor8, new TypeDescriptor[]{typeDescriptor5});
        codeBuilder.pop();
        codeBuilder.branch((Location)label2);
        label.setLocation();
        codeBuilder.loadLocal(localVariable5);
        codeBuilder.loadLocal(localVariable3);
        codeBuilder.math((byte)-105);
        codeBuilder.ifZeroComparisonBranch((Location)label2, "!=");
        codeBuilder.loadLocal(localVariable);
        codeBuilder.loadLocal(localVariable4);
        codeBuilder.invokeInterface("java.util.List", "add", typeDescriptor8, new TypeDescriptor[]{typeDescriptor5});
        codeBuilder.pop();
        label2.setLocation();
        codeBuilder.integerIncrement(localVariable6, 1);
        label3.setLocation();
        codeBuilder.loadLocal(localVariable6);
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.ifComparisonBranch((Location)label4, "<");
        codeBuilder.loadLocal(localVariable);
        codeBuilder.returnValue(List.class);
        return ByteCodeBuilder.createObjectPicker(classFile, list);
    }

    public static BasicAction generateBasicActionForList(List list, String string) throws GeneratorException {
        return ByteCodeBuilder.generateBasicActionForList(list, string, list.get(0).getClass(), false);
    }

    public static BasicAction generateBasicActionForListRnd(List list, String string) throws GeneratorException {
        return ByteCodeBuilder.generateBasicActionForList(list, string, list.get(0).getClass(), true);
    }

    public static BasicAction generateBasicActionForList(List list, String string, Class clazz, boolean bl) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethod(clazz, string);
        ClassFile classFile = new ClassFile(ByteCodeBuilder.getUnqName(), BasicAction.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(list.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getBasicActionExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(clazz);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor(Object.class);
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.invokeInterface("java.util.List", "size", typeDescriptor2, null);
        LocalVariable localVariable = codeBuilder.createLocalVariable("listSize", typeDescriptor2);
        codeBuilder.storeLocal(localVariable);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor(List.class);
        if (bl) {
            codeBuilder.loadThis();
            codeBuilder.loadField("target", typeDescriptor);
            codeBuilder.invokeStatic("uchicago.src.sim.util.SimUtilities", "shuffle", null, new TypeDescriptor[]{typeDescriptor5});
        }
        LocalVariable localVariable2 = codeBuilder.createLocalVariable("i", typeDescriptor2);
        codeBuilder.loadConstant(0);
        codeBuilder.storeLocal(localVariable2);
        Label label = codeBuilder.createLabel();
        codeBuilder.branch((Location)label);
        Label label2 = codeBuilder.createLabel().setLocation();
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.invokeInterface("java.util.List", "get", typeDescriptor4, new TypeDescriptor[]{typeDescriptor2});
        codeBuilder.checkCast(typeDescriptor3);
        codeBuilder.invoke(method);
        codeBuilder.integerIncrement(localVariable2, 1);
        label.setLocation();
        codeBuilder.loadLocal(localVariable2);
        codeBuilder.loadLocal(localVariable);
        codeBuilder.ifComparisonBranch((Location)label2, "<");
        codeBuilder.returnVoid();
        return ByteCodeBuilder.createBasicAction(classFile, list);
    }

    public static BasicAction generateBasicAction(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethod(object.getClass(), string);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2, BasicAction.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(object.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getBasicActionExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.invoke(method);
        codeBuilder.returnVoid();
        return ByteCodeBuilder.createBasicAction(classFile, object);
    }

    public static DataSource generateDataSource(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethod(object.getClass(), string, Object.class);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2);
        classFile.addInterface(DataSource.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(object.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getDataSourceExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.invoke(method);
        codeBuilder.returnValue(Object.class);
        return ByteCodeBuilder.createDataSource(classFile, object);
    }

    public static NumericDataSource generateNumericDataSource(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(object.getClass(), string, null);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2);
        classFile.addInterface(NumericDataSource.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(object.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getNumericDataSourceExecMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createNumericDataSource(classFile, object);
    }

    public static BinDataSource generateNoTargetBinDataSource(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(object.getClass(), string, null);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2);
        classFile.addInterface(BinDataSource.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getBDSBinValueMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.checkCast(new TypeDescriptor(object.getClass()));
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createNoTargetBinDataSource(classFile, object);
    }

    private static BinDataSource createNoTargetBinDataSource(ClassFile classFile, Object object) throws GeneratorException {
        ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
        BinDataSource binDataSource = null;
        try {
            OutputStream outputStream = classInjector.getStream(classFile.getClassName());
            classFile.writeTo(outputStream);
            outputStream.close();
            Class clazz = classInjector.loadClass(classFile.getClassName());
            Constructor constructor = clazz.getConstructor(new Class[0]);
            binDataSource = (BinDataSource)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return binDataSource;
    }

    public static BinDataSource generateBinDataSource(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodObjDouble(object.getClass(), string);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2);
        classFile.addInterface(BinDataSource.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(object.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getBDSBinValueMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createBinDataSource(classFile, object);
    }

    private static BinDataSource createBinDataSource(ClassFile classFile, Object object) throws GeneratorException {
        ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
        BinDataSource binDataSource = null;
        try {
            OutputStream outputStream = classInjector.getStream(classFile.getClassName());
            classFile.writeTo(outputStream);
            outputStream.close();
            Class clazz = classInjector.loadClass(classFile.getClassName());
            Constructor constructor = clazz.getConstructor(object.getClass());
            binDataSource = (BinDataSource)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return binDataSource;
    }

    public static Sequence generateSequence(Object object, String string) throws GeneratorException {
        Method method = ByteCodeBuilder.getMethodRetDouble(object.getClass(), string, new Class[0]);
        String string2 = ByteCodeBuilder.getUnqName();
        ClassFile classFile = new ClassFile(string2);
        classFile.addInterface(Sequence.class);
        classFile.markSynthetic();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(object.getClass());
        classFile.addField(accessFlags, "target", typeDescriptor).markSynthetic();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor};
        MethodInfo methodInfo = classFile.addConstructor(accessFlags2, typeDescriptorArray);
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        codeBuilder.invokeSuperConstructor(null);
        codeBuilder.loadThis();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        codeBuilder.storeField("target", typeDescriptor);
        codeBuilder.returnVoid();
        Method method2 = ByteCodeBuilder.getSequenceSValueMethod();
        MethodInfo methodInfo2 = classFile.addMethod(method2);
        methodInfo2.markSynthetic();
        codeBuilder = new CodeBuilder(methodInfo2);
        codeBuilder.loadThis();
        codeBuilder.loadField("target", typeDescriptor);
        codeBuilder.invoke(method);
        if (!method.getReturnType().equals(Double.TYPE)) {
            codeBuilder.convert(method.getReturnType(), Double.TYPE);
        }
        codeBuilder.returnValue(Double.TYPE);
        return ByteCodeBuilder.createSequence(classFile, object);
    }

    private static Sequence createSequence(ClassFile classFile, Object object) throws GeneratorException {
        ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
        Sequence sequence = null;
        try {
            OutputStream outputStream = classInjector.getStream(classFile.getClassName());
            classFile.writeTo(outputStream);
            outputStream.close();
            Class clazz = classInjector.loadClass(classFile.getClassName());
            Constructor constructor = clazz.getConstructor(object.getClass());
            sequence = (Sequence)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return sequence;
    }

    private static NumericDataSource createNumericDataSource(ClassFile classFile, Object object) throws GeneratorException {
        ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
        NumericDataSource numericDataSource = null;
        try {
            OutputStream outputStream = classInjector.getStream(classFile.getClassName());
            classFile.writeTo(outputStream);
            outputStream.close();
            Class clazz = classInjector.loadClass(classFile.getClassName());
            Constructor constructor = clazz.getConstructor(object.getClass());
            numericDataSource = (NumericDataSource)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return numericDataSource;
    }

    private static DataSource createDataSource(ClassFile classFile, Object object) throws GeneratorException {
        ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
        DataSource dataSource = null;
        try {
            OutputStream outputStream = classInjector.getStream(classFile.getClassName());
            classFile.writeTo(outputStream);
            outputStream.close();
            Class clazz = classInjector.loadClass(classFile.getClassName());
            Constructor constructor = clazz.getConstructor(object.getClass());
            dataSource = (DataSource)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return dataSource;
    }

    private static StatCalculator createStatCalculator(ClassFile classFile, List list) throws GeneratorException {
        StatCalculator statCalculator = null;
        if (loader == null) {
            ClassInjector classInjector = new ClassInjector(list.getClass().getClassLoader());
            try {
                OutputStream outputStream = classInjector.getStream(classFile.getClassName());
                classFile.writeTo(outputStream);
                outputStream.close();
                Class clazz = classInjector.loadClass(classFile.getClassName());
                Constructor constructor = clazz.getConstructor(List.class);
                statCalculator = (StatCalculator)constructor.newInstance(list);
            }
            catch (Exception exception) {
                throw new GeneratorException(exception.getMessage(), exception);
            }
        }
        try {
            loader.addClass(classFile.getClassName(), classFile);
            Class<?> clazz = loader.loadClass(classFile.getClassName());
            Constructor<?> constructor = clazz.getConstructor(List.class);
            statCalculator = (StatCalculator)constructor.newInstance(list);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return statCalculator;
    }

    private static ObjectPicker createObjectPicker(ClassFile classFile, List list) throws GeneratorException {
        ObjectPicker objectPicker = null;
        if (loader == null) {
            ClassInjector classInjector = new ClassInjector(list.getClass().getClassLoader());
            try {
                OutputStream outputStream = classInjector.getStream(classFile.getClassName());
                classFile.writeTo(outputStream);
                outputStream.close();
                Class clazz = classInjector.loadClass(classFile.getClassName());
                Constructor constructor = clazz.getConstructor(List.class);
                objectPicker = (ObjectPicker)constructor.newInstance(list);
            }
            catch (Exception exception) {
                throw new GeneratorException(exception.getMessage(), exception);
            }
        }
        try {
            loader.addClass(classFile.getClassName(), classFile);
            Class<?> clazz = loader.loadClass(classFile.getClassName());
            Constructor<?> constructor = clazz.getConstructor(List.class);
            objectPicker = (ObjectPicker)constructor.newInstance(list);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return objectPicker;
    }

    private static BasicAction createBasicAction(ClassFile classFile, Object object) throws GeneratorException {
        BasicAction basicAction = null;
        if (loader == null) {
            ClassInjector classInjector = new ClassInjector(object.getClass().getClassLoader());
            try {
                OutputStream outputStream = classInjector.getStream(classFile.getClassName());
                classFile.writeTo(outputStream);
                outputStream.close();
                Class clazz = classInjector.loadClass(classFile.getClassName());
                Constructor constructor = clazz.getConstructor(object.getClass());
                basicAction = (BasicAction)constructor.newInstance(object);
            }
            catch (Exception exception) {
                throw new GeneratorException(exception.getMessage(), exception);
            }
        }
        try {
            loader.addClass(classFile.getClassName(), classFile);
            Class<?> clazz = loader.loadClass(classFile.getClassName());
            Constructor<?> constructor = clazz.getConstructor(object.getClass());
            basicAction = (BasicAction)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.getMessage(), exception);
        }
        return basicAction;
    }
}

