/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.util.Vector;
import uchicago.src.sim.space.AbstractNeighborhooder;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.space.Torus;

public class MooreNeighborhooder
extends AbstractNeighborhooder {
    public MooreNeighborhooder(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        this.torus = discrete2DSpace instanceof Torus;
    }

    public Vector getNeighbors(int n, int n2, int[] nArray, boolean bl) {
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Moore neighborhoods require an extents array of 2 integers");
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        Vector<Object> vector = new Vector<Object>(n3 * n4 * 4 + n3 * 2 + n4 * 2);
        int n5 = n3;
        int n6 = n3;
        if (!this.torus) {
            if (n + n6 > this.space.getSizeX() - 1) {
                n6 = this.space.getSizeX() - 1 - n;
            }
            if (n - n5 < 0) {
                n5 = n;
            }
        }
        int n7 = n4;
        int n8 = n4;
        if (!this.torus) {
            if (n2 + n8 > this.space.getSizeY() - 1) {
                n8 = this.space.getSizeY() - 1 - n2;
            }
            if (n2 - n7 < 0) {
                n7 = n2;
            }
        }
        for (int i = n2 - n7; i <= n2 + n8; ++i) {
            for (int j = n - n5; j <= n + n6; ++j) {
                if (i == n2 && j == n) continue;
                Object object = this.space.getObjectAt(j, i);
                if (bl) {
                    vector.add(object);
                    continue;
                }
                if (object == null) continue;
                vector.add(object);
            }
        }
        return vector;
    }
}

