/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.util.Vector;
import uchicago.src.sim.space.AbstractNeighborhooder;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.space.Torus;

public class HexNeighborhooder
extends AbstractNeighborhooder {
    private boolean returnNull = false;
    private static final int[] singleExtent = new int[]{1};
    private int sizeX;
    private int sizeY;

    public HexNeighborhooder(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        this.torus = discrete2DSpace instanceof Torus;
        this.sizeX = discrete2DSpace.getSizeX();
        this.sizeY = discrete2DSpace.getSizeY();
    }

    public Vector getNeighbors(int n, int n2, boolean bl) {
        return this.getNeighbors(n, n2, singleExtent, bl);
    }

    public Vector getNeighbors(int n, int n2, int[] nArray, boolean bl) {
        this.returnNull = bl;
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Hexagonal Neighborhoods take one argument");
        }
        int n3 = nArray[0];
        if (n3 < 1) {
            return new Vector();
        }
        if (n3 == 1) {
            return this.singleExtent(n, n2);
        }
        if (n3 == 2) {
            return this.doubleExtent(n, n2);
        }
        return this.gtTwoExtent(n, n2, n3);
    }

    private Vector gtTwoExtent(int n, int n2, int n3) {
        int n4;
        Vector vector = new Vector(3 * n3 * (n3 + 1));
        if (n % 2 == 0) {
            for (n4 = n3; n4 > 2; --n4) {
                Vector vector2 = this.getEvenRing(n, n2, n4);
                vector.addAll(vector2);
            }
        } else {
            for (n4 = n3; n4 > 2; --n4) {
                Vector vector3 = this.getOddRing(n, n2, n4);
                vector.addAll(vector3);
            }
        }
        Vector vector4 = this.doubleExtent(n, n2);
        vector.addAll(vector4);
        return vector;
    }

    private Vector getEvenRing(int n, int n2, int n3) {
        int n4;
        Vector vector = new Vector(n3 * 6);
        int n5 = n2 - n3;
        this.addXY(vector, n, n5++);
        int n6 = n + n3;
        int n7 = n + 1;
        while (n7 <= n6) {
            this.addXY(vector, n7++, n5);
            if (n7 > n6) {
                ++n5;
                break;
            }
            this.addXY(vector, n7++, n5);
            ++n5;
        }
        n7 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(vector, n7, n5++);
        }
        if (n7 % 2 != 0) {
            int n8 = --n5;
            ++n5;
            this.addXY(vector, --n7, n8);
        }
        --n7;
        while (n7 > n) {
            this.addXY(vector, n7--, n5);
            if (n7 == n) break;
            this.addXY(vector, n7--, n5);
            ++n5;
        }
        n5 = n2 + n3;
        this.addXY(vector, n, n5);
        this.addXY(vector, n - 1, n5);
        --n5;
        n7 = n - 2;
        n6 = n - n3;
        while (n7 >= n6) {
            this.addXY(vector, n7--, n5);
            if (n7 < n6) {
                --n5;
                break;
            }
            this.addXY(vector, n7--, n5);
            --n5;
        }
        n7 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(vector, n7, n5--);
        }
        if (++n7 % 2 != 0) {
            ++n5;
            this.addXY(vector, n7++, n5--);
        }
        while (n7 < n) {
            this.addXY(vector, n7++, n5);
            if (n7 == n) break;
            this.addXY(vector, n7++, n5);
            --n5;
        }
        return vector;
    }

    private Vector getOddRing(int n, int n2, int n3) {
        int n4;
        Vector vector = new Vector(n3 * 6);
        this.addXY(vector, n, n2 - n3);
        this.addXY(vector, n + 1, n2 - n3);
        int n5 = n + 2;
        int n6 = n2 - n3 + 1;
        int n7 = n + n3;
        while (n5 <= n7) {
            this.addXY(vector, n5++, n6);
            if (n5 > n7) {
                ++n6;
                break;
            }
            this.addXY(vector, n5++, n6);
            ++n6;
        }
        n5 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(vector, n5, n6++);
        }
        if (n5 % 2 != 0) {
            int n8 = --n6;
            ++n6;
            this.addXY(vector, --n5, n8);
        }
        --n5;
        while (n5 > n) {
            this.addXY(vector, n5--, n6);
            this.addXY(vector, n5--, n6);
            ++n6;
        }
        this.addXY(vector, n, n2 + n3);
        n6 = n2 + n3 - 1;
        n5 = n - 1;
        n7 = n - n3;
        while (n5 >= n7) {
            this.addXY(vector, n5--, n6);
            if (n5 < n7) {
                --n6;
                break;
            }
            this.addXY(vector, n5--, n6);
            --n6;
        }
        n5 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(vector, n5, n6--);
        }
        if (++n5 % 2 != 0) {
            this.addXY(vector, n5++, ++n6);
            --n6;
        }
        while (n5 < n) {
            this.addXY(vector, n5++, n6);
            if (n5 == n) break;
            this.addXY(vector, n5++, n6);
            --n6;
        }
        return vector;
    }

    private Vector doubleExtent(int n, int n2) {
        Vector vector = new Vector(18);
        if (n % 2 == 0) {
            this.addXY(vector, n, n2 - 2);
            this.addXY(vector, n + 1, n2 - 1);
            this.addXY(vector, n + 2, n2 - 1);
            this.addXY(vector, n + 2, n2);
            this.addXY(vector, n + 2, n2 + 1);
            this.addXY(vector, n + 1, n2 + 2);
            this.addXY(vector, n, n2 + 2);
            this.addXY(vector, n - 1, n2 + 2);
            this.addXY(vector, n - 2, n2 + 1);
            this.addXY(vector, n - 2, n2);
            this.addXY(vector, n - 2, n2 - 1);
            this.addXY(vector, n - 1, n2 - 1);
        } else {
            this.addXY(vector, n, n2 - 2);
            this.addXY(vector, n + 1, n2 - 2);
            this.addXY(vector, n + 2, n2 - 1);
            this.addXY(vector, n + 2, n2);
            this.addXY(vector, n + 2, n2 + 1);
            this.addXY(vector, n + 1, n2 + 1);
            this.addXY(vector, n, n2 + 2);
            this.addXY(vector, n - 1, n2 + 1);
            this.addXY(vector, n - 2, n2 + 1);
            this.addXY(vector, n - 2, n2);
            this.addXY(vector, n - 2, n2 - 1);
            this.addXY(vector, n - 1, n2 - 2);
        }
        vector.addAll(this.singleExtent(n, n2));
        return vector;
    }

    private Vector singleExtent(int n, int n2) {
        Vector vector = new Vector(6);
        if (n % 2 == 0) {
            this.addXY(vector, n, n2 - 1);
            this.addXY(vector, n + 1, n2);
            this.addXY(vector, n + 1, n2 + 1);
            this.addXY(vector, n, n2 + 1);
            this.addXY(vector, n - 1, n2 + 1);
            this.addXY(vector, n - 1, n2);
        } else {
            int n3 = n2 - 1;
            this.addXY(vector, n, n3);
            this.addXY(vector, n + 1, n3);
            this.addXY(vector, n + 1, n2);
            this.addXY(vector, n, n2 + 1);
            this.addXY(vector, n - 1, n2);
            this.addXY(vector, n - 1, n3);
        }
        return vector;
    }

    protected void addXY(Vector vector, int n, int n2) {
        Object object = null;
        if (!this.torus) {
            if (n >= 0 & n < this.sizeX & n2 >= 0 & n2 < this.sizeY) {
                object = this.space.getObjectAt(n, n2);
            }
        } else {
            object = this.space.getObjectAt(n, n2);
        }
        if (this.returnNull) {
            vector.add(object);
        } else if (object != null) {
            vector.add(object);
        }
    }
}

