/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.space.AbstractNeighborhooder;
import uchicago.src.sim.space.IMulti2DGrid;
import uchicago.src.sim.space.ObjectLocation;
import uchicago.src.sim.space.Torus;

public class HexMultiNeighborhooder
extends AbstractNeighborhooder {
    private IMulti2DGrid grid;
    private int sizeX;
    private int sizeY;
    private LocAdder lAdder = new LocAdder();
    private ObjectAdder oAdder = new ObjectAdder();
    private Adder adder;
    private boolean returnNull;

    public HexMultiNeighborhooder(IMulti2DGrid iMulti2DGrid) {
        super(iMulti2DGrid);
        this.grid = iMulti2DGrid;
        this.torus = iMulti2DGrid instanceof Torus;
        this.sizeX = iMulti2DGrid.getSizeX();
        this.sizeY = iMulti2DGrid.getSizeY();
    }

    public int xnorm(int n) {
        if (n > this.sizeX - 1 || n < 0) {
            while (n < 0) {
                n += this.sizeX;
            }
            return n % this.sizeX;
        }
        return n;
    }

    public int ynorm(int n) {
        if (n > this.sizeY - 1 || n < 0) {
            while (n < 0) {
                n += this.sizeY;
            }
            return n % this.sizeY;
        }
        return n;
    }

    public Vector getNeighbors(int n, int n2, int[] nArray, boolean bl) {
        return new Vector(this.getNeighborsList(n, n2, nArray, bl));
    }

    public ArrayList getNeighborsList(int n, int n2, int[] nArray, boolean bl) {
        this.adder = this.oAdder;
        return this.getNeighs(n, n2, nArray, bl);
    }

    public ArrayList getNeighborsLoc(int n, int n2, int[] nArray, boolean bl) {
        this.adder = this.lAdder;
        return this.getNeighs(n, n2, nArray, bl);
    }

    protected ArrayList getNeighs(int n, int n2, int[] nArray, boolean bl) {
        this.returnNull = bl;
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Hexagonal Neighborhoods take one argument");
        }
        int n3 = nArray[0];
        if (n3 < 1) {
            return new ArrayList();
        }
        if (n3 == 1) {
            return this.singleExtent(n, n2);
        }
        if (n3 == 2) {
            return this.doubleExtent(n, n2);
        }
        return this.gtTwoExtent(n, n2, n3);
    }

    private ArrayList gtTwoExtent(int n, int n2, int n3) {
        int n4;
        ArrayList arrayList = new ArrayList(3 * n3 * (n3 + 1));
        if (n % 2 == 0) {
            for (n4 = n3; n4 > 2; --n4) {
                ArrayList arrayList2 = this.getEvenRing(n, n2, n4);
                arrayList.addAll(arrayList2);
            }
        } else {
            for (n4 = n3; n4 > 2; --n4) {
                ArrayList arrayList3 = this.getOddRing(n, n2, n4);
                arrayList.addAll(arrayList3);
            }
        }
        ArrayList arrayList4 = this.doubleExtent(n, n2);
        arrayList.addAll(arrayList4);
        return arrayList;
    }

    private ArrayList getEvenRing(int n, int n2, int n3) {
        int n4;
        ArrayList arrayList = new ArrayList(n3 * 6);
        int n5 = n2 - n3;
        this.addXY(arrayList, n, n5++);
        int n6 = n + n3;
        int n7 = n + 1;
        while (n7 <= n6) {
            this.addXY(arrayList, n7++, n5);
            if (n7 > n6) {
                ++n5;
                break;
            }
            this.addXY(arrayList, n7++, n5);
            ++n5;
        }
        n7 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(arrayList, n7, n5++);
        }
        if (n7 % 2 != 0) {
            int n8 = --n5;
            ++n5;
            this.addXY(arrayList, --n7, n8);
        }
        --n7;
        while (n7 > n) {
            this.addXY(arrayList, n7--, n5);
            if (n7 == n) break;
            this.addXY(arrayList, n7--, n5);
            ++n5;
        }
        n5 = n2 + n3;
        this.addXY(arrayList, n, n5);
        this.addXY(arrayList, n - 1, n5);
        --n5;
        n7 = n - 2;
        n6 = n - n3;
        while (n7 >= n6) {
            this.addXY(arrayList, n7--, n5);
            if (n7 < n6) {
                --n5;
                break;
            }
            this.addXY(arrayList, n7--, n5);
            --n5;
        }
        n7 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(arrayList, n7, n5--);
        }
        if (++n7 % 2 != 0) {
            ++n5;
            this.addXY(arrayList, n7++, n5--);
        }
        while (n7 < n) {
            this.addXY(arrayList, n7++, n5);
            if (n7 == n) break;
            this.addXY(arrayList, n7++, n5);
            --n5;
        }
        return arrayList;
    }

    private ArrayList getOddRing(int n, int n2, int n3) {
        int n4;
        ArrayList arrayList = new ArrayList(n3 * 6);
        this.addXY(arrayList, n, n2 - n3);
        this.addXY(arrayList, n + 1, n2 - n3);
        int n5 = n + 2;
        int n6 = n2 - n3 + 1;
        int n7 = n + n3;
        while (n5 <= n7) {
            this.addXY(arrayList, n5++, n6);
            if (n5 > n7) {
                ++n6;
                break;
            }
            this.addXY(arrayList, n5++, n6);
            ++n6;
        }
        n5 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(arrayList, n5, n6++);
        }
        if (n5 % 2 != 0) {
            int n8 = --n6;
            ++n6;
            this.addXY(arrayList, --n5, n8);
        }
        --n5;
        while (n5 > n) {
            this.addXY(arrayList, n5--, n6);
            this.addXY(arrayList, n5--, n6);
            ++n6;
        }
        this.addXY(arrayList, n, n2 + n3);
        n6 = n2 + n3 - 1;
        n5 = n - 1;
        n7 = n - n3;
        while (n5 >= n7) {
            this.addXY(arrayList, n5--, n6);
            if (n5 < n7) {
                --n6;
                break;
            }
            this.addXY(arrayList, n5--, n6);
            --n6;
        }
        n5 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            this.addXY(arrayList, n5, n6--);
        }
        if (++n5 % 2 != 0) {
            this.addXY(arrayList, n5++, ++n6);
            --n6;
        }
        while (n5 < n) {
            this.addXY(arrayList, n5++, n6);
            if (n5 == n) break;
            this.addXY(arrayList, n5++, n6);
            --n6;
        }
        return arrayList;
    }

    private ArrayList doubleExtent(int n, int n2) {
        ArrayList arrayList = new ArrayList(18);
        if (n % 2 == 0) {
            this.addXY(arrayList, n, n2 - 2);
            this.addXY(arrayList, n + 1, n2 - 1);
            this.addXY(arrayList, n + 2, n2 - 1);
            this.addXY(arrayList, n + 2, n2);
            this.addXY(arrayList, n + 2, n2 + 1);
            this.addXY(arrayList, n + 1, n2 + 2);
            this.addXY(arrayList, n, n2 + 2);
            this.addXY(arrayList, n - 1, n2 + 2);
            this.addXY(arrayList, n - 2, n2 + 1);
            this.addXY(arrayList, n - 2, n2);
            this.addXY(arrayList, n - 2, n2 - 1);
            this.addXY(arrayList, n - 1, n2 - 1);
        } else {
            this.addXY(arrayList, n, n2 - 2);
            this.addXY(arrayList, n + 1, n2 - 2);
            this.addXY(arrayList, n + 2, n2 - 1);
            this.addXY(arrayList, n + 2, n2);
            this.addXY(arrayList, n + 2, n2 + 1);
            this.addXY(arrayList, n + 1, n2 + 1);
            this.addXY(arrayList, n, n2 + 2);
            this.addXY(arrayList, n - 1, n2 + 1);
            this.addXY(arrayList, n - 2, n2 + 1);
            this.addXY(arrayList, n - 2, n2);
            this.addXY(arrayList, n - 2, n2 - 1);
            this.addXY(arrayList, n - 1, n2 - 2);
        }
        arrayList.addAll(this.singleExtent(n, n2));
        return arrayList;
    }

    private ArrayList singleExtent(int n, int n2) {
        ArrayList arrayList = new ArrayList(6);
        if (n % 2 == 0) {
            this.addXY(arrayList, n, n2 - 1);
            this.addXY(arrayList, n + 1, n2);
            this.addXY(arrayList, n + 1, n2 + 1);
            this.addXY(arrayList, n, n2 + 1);
            this.addXY(arrayList, n - 1, n2 + 1);
            this.addXY(arrayList, n - 1, n2);
        } else {
            int n3 = n2 - 1;
            this.addXY(arrayList, n, n3);
            this.addXY(arrayList, n + 1, n3);
            this.addXY(arrayList, n + 1, n2);
            this.addXY(arrayList, n, n2 + 1);
            this.addXY(arrayList, n - 1, n2);
            this.addXY(arrayList, n - 1, n3);
        }
        return arrayList;
    }

    protected void addXY(ArrayList arrayList, int n, int n2) {
        this.adder.add(arrayList, n, n2);
    }

    public class LocAdder
    implements Adder {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void add(ArrayList arrayList, int n, int n2) {
            List list = null;
            if (!HexMultiNeighborhooder.this.torus) {
                if (!(n >= 0 & n < HexMultiNeighborhooder.this.sizeX & n2 >= 0 & n2 < HexMultiNeighborhooder.this.sizeY)) return;
                list = HexMultiNeighborhooder.this.grid.getObjectsAt(n, n2);
                int n3 = list.size();
                if (n3 == 0 && HexMultiNeighborhooder.this.returnNull) {
                    arrayList.add(new ObjectLocation(null, n, n2));
                    return;
                } else {
                    if (n3 <= 0) return;
                    arrayList.addAll(ObjectLocation.makeObjectLocations(list, n, n2));
                }
                return;
            } else {
                list = HexMultiNeighborhooder.this.grid.getObjectsAt(n, n2);
                int n4 = list.size();
                if (n4 == 0 && HexMultiNeighborhooder.this.returnNull) {
                    arrayList.add(new ObjectLocation(null, HexMultiNeighborhooder.this.xnorm(n), HexMultiNeighborhooder.this.xnorm(n2)));
                    return;
                } else {
                    if (n4 <= 0) return;
                    arrayList.addAll(ObjectLocation.makeObjectLocations(list, HexMultiNeighborhooder.this.xnorm(n), HexMultiNeighborhooder.this.ynorm(n2)));
                }
            }
        }
    }

    public class ObjectAdder
    implements Adder {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void add(ArrayList arrayList, int n, int n2) {
            List list = null;
            if (!HexMultiNeighborhooder.this.torus) {
                if (!(n >= 0 & n < HexMultiNeighborhooder.this.sizeX & n2 >= 0 & n2 < HexMultiNeighborhooder.this.sizeY)) return;
                list = HexMultiNeighborhooder.this.grid.getObjectsAt(n, n2);
            } else {
                list = HexMultiNeighborhooder.this.grid.getObjectsAt(n, n2);
            }
            int n3 = list.size();
            if (n3 == 0 && HexMultiNeighborhooder.this.returnNull) {
                arrayList.add(null);
                return;
            } else {
                if (n3 <= 0) return;
                arrayList.addAll(list);
            }
        }
    }

    static interface Adder {
        public void add(ArrayList var1, int var2, int var3);
    }
}

