/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.sim.space.AbsMulti2DGrid;
import uchicago.src.sim.space.Cell;
import uchicago.src.sim.space.MooreMultiNeighborhooder;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.space.VNMultiNeighborhooder;

public abstract class AbsMulti2DTorus
extends AbsMulti2DGrid
implements Torus {
    private VNMultiNeighborhooder vnNeigh = new VNMultiNeighborhooder(this);
    private MooreMultiNeighborhooder mNeigh = new MooreMultiNeighborhooder(this);

    public AbsMulti2DTorus(int n, int n2, boolean bl) {
        super(n, n2, bl);
    }

    public void clear(int n, int n2) {
        this.matrix.remove(this.xnorm(n), this.xnorm(n2));
    }

    public List getObjectsAt(int n, int n2) {
        Cell cell = (Cell)this.matrix.get(this.xnorm(n), this.ynorm(n2));
        if (cell != null) {
            return cell.getList();
        }
        return this.roList;
    }

    public Iterator getIteratorAt(int n, int n2) {
        Cell cell = (Cell)this.matrix.get(this.xnorm(n), this.ynorm(n2));
        if (cell != null) {
            return cell.iterator();
        }
        return this.roIter;
    }

    public Cell getCellAt(int n, int n2) {
        return (Cell)this.matrix.get(this.xnorm(n), this.ynorm(n2));
    }

    public ArrayList getVNNeighborsLoc(int n, int n2, boolean bl) {
        return this.getVNNeighborsLoc(n, n2, 1, 1, bl);
    }

    public ArrayList getVNNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
        n = this.xnorm(n);
        n2 = this.ynorm(n2);
        int[] nArray = new int[]{n3, n4};
        return this.vnNeigh.getNeighborsLoc(n, n2, nArray, bl);
    }

    public ArrayList getMooreNeighborsLoc(int n, int n2, boolean bl) {
        return this.getMooreNeighborsLoc(n, n2, 1, 1, bl);
    }

    public ArrayList getMooreNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.mNeigh.getNeighborsLoc(n, n2, nArray, bl);
    }

    public ArrayList getVNNeighbors(int n, int n2, boolean bl) {
        return this.getVNNeighbors(n, n2, 1, 1, bl);
    }

    public ArrayList getVNNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        n = this.xnorm(n);
        n2 = this.ynorm(n2);
        int[] nArray = new int[]{n3, n4};
        return this.vnNeigh.getNeighborsList(n, n2, nArray, bl);
    }

    public ArrayList getMooreNeighbors(int n, int n2, boolean bl) {
        return this.getMooreNeighbors(n, n2, 1, 1, bl);
    }

    public ArrayList getMooreNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.mNeigh.getNeighborsList(n, n2, nArray, bl);
    }

    public int getCellSizeAt(int n, int n2) {
        Cell cell = (Cell)this.matrix.get(this.xnorm(n), this.ynorm(n2));
        if (cell != null) {
            return cell.size();
        }
        return 0;
    }

    public void removeObjectAt(int n, int n2, Object object) {
        Cell cell = (Cell)this.matrix.get(this.xnorm(n), this.ynorm(n2));
        if (cell != null) {
            cell.remove(object);
        }
    }

    public Object getObjectAt(int n, int n2) {
        return this.matrix.get(this.xnorm(n), this.ynorm(n2));
    }

    public double getValueAt(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public abstract void putObjectAt(int var1, int var2, Object var3);

    public void putValueAt(int n, int n2, double d) {
        throw new UnsupportedOperationException();
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }

    public void trim() {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                int n = this.getCellSizeAt(i, j);
                if (n != 0) continue;
                this.matrix.remove(i, j);
            }
        }
        this.matrix.trim();
    }

    public int xnorm(int n) {
        if (n > this.xSize - 1 || n < 0) {
            while (n < 0) {
                n += this.xSize;
            }
            return n % this.xSize;
        }
        return n;
    }

    public int ynorm(int n) {
        if (n > this.ySize - 1 || n < 0) {
            while (n < 0) {
                n += this.ySize;
            }
            return n % this.ySize;
        }
        return n;
    }
}

