/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.beans.IntrospectionException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class ParameterUtility {
    private static Set floatingTypes = new HashSet();
    private ParameterSetter params;
    private static ParameterUtility instance;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public static void createInstance(ParameterSetter parameterSetter) {
        instance = new ParameterUtility(parameterSetter);
    }

    public static void createInstance() {
        instance = new ParameterUtility(null);
    }

    public static ParameterUtility getInstance() {
        return instance;
    }

    private ParameterUtility(ParameterSetter parameterSetter) {
        if (parameterSetter != null) {
            this.params = parameterSetter;
        }
    }

    public boolean isDefaultParam(String string) {
        return this.params.isParameter(string);
    }

    public boolean isConstantDefaultParam(String string) {
        return this.params.isConstant(string);
    }

    public ArrayList getDynamicParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.params.getDynamicParameterNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(string.toLowerCase());
        }
        return arrayList;
    }

    public Hashtable getDefaultParameters(SimModel simModel) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        return this.params.getDefaultModelParameters(simModel);
    }

    public ParameterSetter createParameters(Object object, String[] stringArray) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        return new DefaultParameterSetter(object, stringArray);
    }

    public Hashtable getModelProperties(SimModel simModel) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Hashtable hashtable = new Hashtable(23);
        simModel.clearPropertyListeners();
        String[] stringArray = simModel.getInitParam();
        Introspector introspector = new Introspector();
        introspector.introspect(simModel, stringArray);
        hashtable = introspector.getPropValues();
        return hashtable;
    }

    public void makeParameterFileFromCurVals(Object object, String[] stringArray, String string) throws IntrospectionException, IllegalAccessException, InvocationTargetException, RepastException, IOException {
        ParameterSetter parameterSetter = this.createParameters(object, stringArray);
        StringBuffer stringBuffer = new StringBuffer("runs: 1" + SimUtilities.newLine);
        Object object2 = parameterSetter.parameterNames();
        while (object2.hasNext()) {
            String string2 = (String)object2.next();
            String string3 = parameterSetter.getParameterValue(string2, null).toString();
            if (string3 == null) {
                throw new RepastException(null, "Illegal Parameter type");
            }
            Class clazz = ((DefaultParameterSetter)parameterSetter).getParameterType(string2);
            String string4 = "set: ";
            if (clazz.equals(class$java$lang$Boolean == null ? ParameterUtility.class$("java.lang.Boolean") : class$java$lang$Boolean) || clazz.equals(Boolean.TYPE)) {
                string4 = "set_boolean: ";
            } else if (clazz.equals(class$java$lang$String == null ? ParameterUtility.class$("java.lang.String") : class$java$lang$String)) {
                string4 = "set_string: ";
            }
            string3 = string4 + string3;
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append("{");
            stringBuffer.append(SimUtilities.newLine);
            stringBuffer.append("  ");
            stringBuffer.append(string3);
            stringBuffer.append(SimUtilities.newLine);
            stringBuffer.append("}");
            stringBuffer.append(SimUtilities.newLine);
            stringBuffer.append(SimUtilities.newLine);
        }
        object2 = null;
        try {
            object2 = new PrintWriter(new FileOutputStream(string));
            ((PrintWriter)object2).println(stringBuffer.toString());
            ((PrintWriter)object2).flush();
        }
        catch (IOException iOException) {
            if (object2 != null) {
                ((PrintWriter)object2).close();
            }
            throw iOException;
        }
    }

    public String getPropertyNamesHeader(SimModel simModel) {
        Hashtable hashtable = null;
        try {
            hashtable = this.getModelProperties(simModel);
        }
        catch (IntrospectionException introspectionException) {
            SimUtilities.showError("Error getting model parameters", introspectionException);
            System.exit(0);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error getting model parameters", illegalAccessException);
            System.exit(0);
        }
        catch (InvocationTargetException invocationTargetException) {
            SimUtilities.showError("Error getting model parameters", invocationTargetException);
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(hashtable.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object k = arrayList.get(i);
            stringBuffer.append(k).append("\t");
            stringBuffer.append(hashtable.get(k));
            stringBuffer.append(SimUtilities.newLine);
        }
        return stringBuffer.toString();
    }

    public String getPropertyValues(SimModel simModel) {
        Hashtable hashtable = null;
        try {
            hashtable = this.getModelProperties(simModel);
        }
        catch (IntrospectionException introspectionException) {
            SimUtilities.showError("Error getting model parameters", introspectionException);
            System.exit(0);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error getting model parameters", illegalAccessException);
            System.exit(0);
        }
        catch (InvocationTargetException invocationTargetException) {
            SimUtilities.showError("Error getting model parameters", invocationTargetException);
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(hashtable.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object k = arrayList.get(i);
            stringBuffer.append(hashtable.get(k)).append("\t");
        }
        return stringBuffer.toString();
    }

    static {
        floatingTypes.add(Double.TYPE);
        floatingTypes.add(Float.TYPE);
        floatingTypes.add(Double.class);
        floatingTypes.add(Float.TYPE);
    }
}

