/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import uchicago.src.collection.RangeMap;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.network.ProbabilityRule;
import uchicago.src.sim.util.Random;

public class Linker {
    private ProbabilityRule probRule;
    private RangeMap map = new RangeMap();

    public Linker(ProbabilityRule probabilityRule) {
        this.probRule = probabilityRule;
        this.init();
    }

    public void setProbabilityRule(ProbabilityRule probabilityRule) {
        this.probRule = probabilityRule;
    }

    public void init() {
        this.map = this.probRule.makeProbabilityMap(this.map);
    }

    public Object getNodeForLink() {
        double d = Random.uniform.nextDoubleFromTo(0.0, 1.0);
        return this.map.get(d);
    }

    public RangeMap getMap() {
        return this.map;
    }

    public void update(Object object) {
        this.probRule.update(object);
    }

    public void update(Object object, float f) {
        this.probRule.update(object, f);
    }

    public double getProbabilityFor(Object object) {
        return this.probRule.getProbability(object);
    }

    public Node makeLink(Node node, Edge edge) {
        return this.makeLink(node, edge, 1.0f);
    }

    public Node makeLink(Node node, Edge edge, float f) {
        Node node2 = (Node)this.getNodeForLink();
        edge.setFrom(node);
        edge.setTo(node2);
        node.addOutEdge(edge);
        this.update(node2, f);
        return node2;
    }
}

