/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import uchicago.src.collection.ByteMatrix2D;
import uchicago.src.sim.network.AdjacencyByteMatrix;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class DegNetGenerator {
    private int degree;
    private ByteMatrix2D matrix;
    private int size;
    private HashSet remainingRows;
    private Hashtable allRows;
    private double avgDensity;
    private Vector colNums;
    int matrixNum = 0;

    public DegNetGenerator(int n, float f, int n2) {
        this.degree = n;
        this.matrix = new ByteMatrix2D(n2, n2);
        this.size = n2;
        this.avgDensity = n2 / n;
        this.remainingRows = new HashSet(n2);
        this.colNums = new Vector(n2);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = new Integer(i);
            this.remainingRows.add(n3);
            this.colNums.add(n3);
        }
        Random.createNormal(n, f);
        Random.createUniform();
        this.initAllRows();
    }

    private void initAllRows() {
        int n;
        this.allRows = new Hashtable(this.size);
        Vector<Integer> vector = new Vector<Integer>(this.size);
        for (n = 0; n < this.size; ++n) {
            vector.add(new Integer(n));
        }
        SimUtilities.shuffle(vector, Random.uniform);
        for (n = 0; n < vector.size(); ++n) {
            int n2 = (Integer)vector.get(n);
            int n3 = (int)Math.floor(Random.normal.nextDouble());
            if (n3 < 1) {
                n3 = 1;
            }
            Row row = new Row(n2, n3);
            this.allRows.put(new Integer(n2), row);
        }
    }

    public AdjacencyMatrix getMatrix(int n, float[] fArray, boolean bl) {
        Collection collection = this.makeSeedRows(n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.makeRow(row);
            this.remainingRows.remove(new Integer(row.rowNum));
        }
        boolean bl2 = true;
        while (bl2) {
            Row row;
            int n2;
            collection = bl ? this.makeLinkedRows(collection, fArray[0], this.matrix) : this.makeSymmetric(collection);
            ByteMatrix2D byteMatrix2D = this.matrix.copy();
            ByteMatrix2D[] byteMatrix2DArray = new ByteMatrix2D[fArray.length - 1];
            for (n2 = 0; n2 < fArray.length - 1; ++n2) {
                byteMatrix2D = byteMatrix2D.zMult(this.matrix);
                byteMatrix2DArray[n2] = byteMatrix2D.copy();
            }
            this.makeLinkedRowsFromPower(fArray, byteMatrix2DArray, bl);
            n2 = 1;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                this.makeRow(row);
                this.remainingRows.remove(new Integer(row.rowNum));
                if (row.rowsToDo.size() <= 0) continue;
                n2 = 0;
            }
            if (n2 == 0) continue;
            if (this.remainingRows.size() == 0) {
                bl2 = false;
                this.makeSymmetric(collection);
                continue;
            }
            collection = this.makeSeedRows(n);
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                this.makeRow(row);
                this.remainingRows.remove(new Integer(row.rowNum));
            }
        }
        return new AdjacencyByteMatrix(this.matrix);
    }

    private Collection makeSeedRows(int n) {
        if (n > this.size) {
            throw new IllegalArgumentException("number of rows to seed is greater than size of matrix");
        }
        if (n > this.remainingRows.size()) {
            n = this.remainingRows.size();
        }
        Vector<Row> vector = new Vector<Row>(n);
        Object[] objectArray = this.remainingRows.toArray();
        for (int i = 0; i < n; ++i) {
            int n2 = Random.uniform.nextIntFromTo(0, objectArray.length - 1);
            Integer n3 = (Integer)objectArray[n2];
            Row row = (Row)this.allRows.get(n3);
            while (vector.contains(row)) {
                n2 = Random.uniform.nextIntFromTo(0, objectArray.length - 1);
                n3 = (Integer)objectArray[n2];
                row = (Row)this.allRows.get(n3);
            }
            vector.add(row);
        }
        return vector;
    }

    private Collection makeSymmetric(Collection collection) {
        Hashtable<Integer, Row> hashtable = new Hashtable<Integer, Row>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (int i = 0; i < this.size; ++i) {
                byte by = this.matrix.get(row.rowNum, i);
                if (by <= 0 || this.matrix.get(i, row.rowNum) == by) continue;
                this.matrix.set(i, row.rowNum, by);
                Row row2 = (Row)hashtable.get(new Integer(i));
                if (row2 == null) {
                    row2 = (Row)this.allRows.get(new Integer(i));
                    hashtable.put(new Integer(i), row2);
                }
                ++row2.rowSum;
            }
        }
        return hashtable.values();
    }

    private Collection makeLinkedRows(Collection collection, float f, ByteMatrix2D byteMatrix2D) {
        Hashtable<Integer, Row> hashtable = new Hashtable<Integer, Row>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Vector vector = row.rowsToDo;
            SimUtilities.shuffle(vector, Random.uniform);
            for (int i = 0; i < vector.size(); ++i) {
                float f2;
                int n = (Integer)vector.get(i);
                byte by = byteMatrix2D.get(row.rowNum, n);
                if (by <= 0 || !((f2 = Random.uniform.nextFloatFromTo(0.0f, 1.0f)) <= f) || this.matrix.get(n, row.rowNum) == 1) continue;
                Row row2 = (Row)hashtable.get(new Integer(n));
                if (row2 == null) {
                    row2 = (Row)this.allRows.get(new Integer(n));
                    hashtable.put(new Integer(n), row2);
                }
                if (row2.rowSum >= row2.degree) continue;
                this.matrix.set(n, row.rowNum, (byte)1);
                ++row2.rowSum;
            }
        }
        return hashtable.values();
    }

    private void makeLinkedRowsFromPower(float[] fArray, ByteMatrix2D[] byteMatrix2DArray, boolean bl) {
        float[] fArray2 = new float[fArray.length - 1];
        System.arraycopy(fArray, 1, fArray2, 0, fArray.length - 1);
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            f += fArray2[i];
        }
        double d = this.avgDensity * (double)(1.0f - f);
        for (int i = 0; i < this.size; ++i) {
            Row row = (Row)this.allRows.get(new Integer(i));
            double d2 = row.degree / this.degree;
            SimUtilities.shuffle(this.colNums, Random.uniform);
            for (int j = 0; j < this.colNums.size(); ++j) {
                Integer n = (Integer)this.colNums.get(j);
                int n2 = n;
                if (i == n2) continue;
                if (bl) {
                    if (this.matrix.get(i, n2) >= 1 || row.rowSum >= row.degree || !this.hasLinkFromPower(fArray2, byteMatrix2DArray, d2, d, i, n2)) continue;
                    this.matrix.set(i, n2, (byte)1);
                    ++row.rowSum;
                    continue;
                }
                Row row2 = (Row)this.allRows.get(n);
                if (this.matrix.get(i, n2) >= 1 || row.rowSum >= row.degree || row2.rowSum >= row2.degree || !this.hasLinkFromPower(fArray2, byteMatrix2DArray, d2, d, i, n2)) continue;
                this.matrix.set(i, n2, (byte)1);
                ++row.rowSum;
                this.matrix.set(n2, i, (byte)1);
                ++row2.rowSum;
            }
        }
    }

    private boolean hasLinkFromPower(float[] fArray, ByteMatrix2D[] byteMatrix2DArray, double d, double d2, int n, int n2) {
        double d3 = 0.0;
        for (int i = 0; i < byteMatrix2DArray.length; ++i) {
            double d4 = byteMatrix2DArray[i].get(n, n2);
            d3 += d4 * (double)fArray[0];
        }
        double d5 = d * (d2 + d3);
        float f = Random.uniform.nextFloatFromTo(0.0f, 1.0f);
        return d5 >= (double)f;
    }

    private void makeRow(Row row) {
        row.rowsToDo = null;
        int n = row.degree;
        if (row.rowSum >= n) {
            row.rowsToDo = new Vector();
            return;
        }
        int n2 = row.rowNum;
        if ((n -= row.rowSum) >= this.size - row.rowSum) {
            RowDetails rowDetails = this.setRowToOne(n2);
            row.rowsToDo = rowDetails.rowsToDo;
            row.rowSum += rowDetails.count;
        } else {
            byte by = 1;
            if (n > (this.size - row.rowSum) / 2) {
                RowDetails rowDetails = this.setRowToOne(n2);
                row.rowsToDo = rowDetails.rowsToDo;
                row.rowSum += rowDetails.count;
                by = 0;
                n = this.size - n - 1;
            } else {
                row.rowsToDo = new Vector();
            }
            for (int i = 0; i < n; ++i) {
                int n3 = Random.uniform.nextIntFromTo(0, this.size - 1);
                while (this.matrix.get(n2, n3) == by || n3 == n2) {
                    n3 = Random.uniform.nextIntFromTo(0, this.size - 1);
                }
                this.matrix.set(n2, n3, by);
                if (by == 1) {
                    if (this.remainingRows.contains(new Integer(n3))) {
                        row.rowsToDo.add(new Integer(n3));
                    }
                    ++row.rowSum;
                    continue;
                }
                row.rowsToDo.remove(new Integer(n3));
                --row.rowSum;
            }
        }
    }

    private RowDetails setRowToOne(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (i == n || this.matrix.get(n, i) == 1) continue;
            Integer n3 = new Integer(i);
            if (this.remainingRows.contains(n3)) {
                vector.add(n3);
            }
            this.matrix.set(n, i, (byte)1);
            ++n2;
        }
        return new RowDetails(n2, vector);
    }

    class RowDetails {
        int count = 0;
        Vector rowsToDo;

        public RowDetails(int n, Vector vector) {
            this.count = n;
            this.rowsToDo = vector;
        }
    }

    class Row {
        int rowSum = 0;
        int rowNum;
        int degree = 0;
        Vector rowsToDo = new Vector();

        public Row(int n, int n2) {
            this.rowNum = n;
            this.degree = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Row) {
                Row row = (Row)object;
                return this.rowNum == row.rowNum;
            }
            return false;
        }
    }
}

