/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.util.ArrayList;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.DoubleMatrix;
import uchicago.src.sim.gui.ColorMap;
import uchicago.src.sim.gui.Display2D;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.ProbeableNumber;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.space.Discrete2DSpace;

public class Value2DDisplay
extends Display2D
implements Probeable {
    private ColorMap colorMap;
    private int mapping = 1;
    private int mappingColor = 0;
    private boolean zeroTrans = false;
    private boolean view = true;
    private Drawer drawer = new Drawer();

    public Value2DDisplay(Discrete2DSpace discrete2DSpace, ColorMap colorMap) {
        super(discrete2DSpace);
        this.colorMap = colorMap;
    }

    public void setDisplayMapping(int n, int n2) {
        this.mapping = n;
        this.mappingColor = n2;
    }

    public void setZeroTransparent(boolean bl) {
        this.zeroTrans = bl;
        this.drawer = bl ? new TransDrawer() : new Drawer();
    }

    public boolean isZeroTransparent() {
        return this.zeroTrans;
    }

    public void drawDisplay(SimGraphics simGraphics) {
        if (!this.view) {
            return;
        }
        BaseMatrix baseMatrix = this.grid.getMatrix();
        if (baseMatrix instanceof DoubleMatrix) {
            DoubleMatrix doubleMatrix = (DoubleMatrix)baseMatrix;
            for (int i = 0; i < this.grid.getSizeX(); ++i) {
                for (int j = 0; j < this.grid.getSizeY(); ++j) {
                    double d = doubleMatrix.getDoubleAt(i, j);
                    int n = (int)(d / (double)this.mapping + (double)this.mappingColor);
                    this.drawer.draw(simGraphics, i, j, n);
                }
            }
        } else {
            for (int i = 0; i < this.grid.getSizeX(); ++i) {
                for (int j = 0; j < this.grid.getSizeY(); ++j) {
                    Number number = (Number)baseMatrix.get(i, j);
                    int n = (int)(number.doubleValue() / (double)this.mapping + (double)this.mappingColor);
                    this.drawer.draw(simGraphics, i, j, n);
                }
            }
        }
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("", -1, this));
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        this.view = viewEvent.showView();
    }

    public ArrayList getObjectsAt(int n, int n2) {
        if (n2 != 0) {
            n2 /= SimGraphics.getInstance().getCellHeightScale();
        }
        if (n != 0) {
            n /= SimGraphics.getInstance().getCellWidthScale();
        }
        ArrayList<ProbeableNumber> arrayList = new ArrayList<ProbeableNumber>();
        Object object = this.grid.getObjectAt(n, n2);
        if (object != null) {
            arrayList.add(new ProbeableNumber(n, n2, this.grid, object));
        }
        return arrayList;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        moveable.setX(n / SimGraphics.getInstance().getCellWidthScale());
        moveable.setY(n2 / SimGraphics.getInstance().getCellHeightScale());
    }

    private class TransDrawer
    extends Drawer {
        private TransDrawer() {
        }

        public void draw(SimGraphics simGraphics, int n, int n2, int n3) {
            if (n3 != 0) {
                simGraphics.setDrawingCoordinates(n * simGraphics.getCellWidthScale(), n2 * simGraphics.getCellHeightScale(), 0.0f);
                simGraphics.drawFastRect(Value2DDisplay.this.colorMap.getColor(n3));
            }
        }
    }

    private class Drawer {
        private Drawer() {
        }

        public void draw(SimGraphics simGraphics, int n, int n2, int n3) {
            simGraphics.setDrawingCoordinates(n * simGraphics.getCellWidthScale(), n2 * simGraphics.getCellHeightScale(), 0.0f);
            simGraphics.drawFastRect(Value2DDisplay.this.colorMap.getColor(n3));
        }
    }
}

