/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sourceforge.indigosim.GUI.CopyPrintStream;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.util.SimUtilities;

public class RepastConsole
extends WindowAdapter
implements WindowListener,
Runnable {
    private JFrame frame = FrameFactory.createFrame("RePast Output");
    private JTextArea textArea;
    private Thread reader;
    private boolean quit;
    private boolean stdoutOn = true;
    private boolean stderrOn = true;
    protected static final PrintStream oldStdout = System.out;
    protected static final PrintStream oldStderr = System.err;
    protected static PrintStream newStdout;
    protected static PrintStream newStderr;
    protected static ByteArrayOutputStream byteStream;

    public RepastConsole(boolean bl, boolean bl2) {
        Rectangle rectangle = FrameFactory.getBounds("RePast Output");
        if (rectangle == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = new Dimension(dimension.width - 40, 180);
            int n = 20;
            int n2 = dimension.height - 220;
            this.frame.setBounds(n, n2, dimension2.width, dimension2.height);
        }
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.frame.addWindowListener(this);
        newStdout = new CopyPrintStream((OutputStream)new PrintStream(byteStream), oldStdout);
        newStderr = new CopyPrintStream((OutputStream)new PrintStream(byteStream), oldStderr);
        this.setStdoutOn(bl);
        this.setStderrOn(bl2);
        this.quit = false;
        this.display();
    }

    public void display() {
        this.frame.setVisible(true);
        if (this.stdoutOn | this.stderrOn) {
            this.reader = new Thread(this);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public boolean isStdoutOn() {
        return this.stdoutOn;
    }

    public void setStdoutOn(boolean bl) {
        this.stdoutOn = bl;
        if (bl) {
            System.setOut(newStdout);
        } else {
            System.setOut(oldStdout);
        }
    }

    public boolean isStderrOn() {
        return this.stderrOn;
    }

    public void setStderrOn(boolean bl) {
        this.stderrOn = bl;
        if (bl) {
            System.setErr(newStderr);
        } else {
            System.setErr(oldStderr);
        }
    }

    public synchronized void dispose() {
        this.quit = true;
        this.frame.dispose();
    }

    public synchronized void windowClosed(WindowEvent windowEvent) {
        this.quit = true;
        this.notifyAll();
        this.quit = true;
        this.notifyAll();
        System.setErr(oldStderr);
        System.setOut(oldStdout);
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public synchronized void run() {
        try {
            this.copyOutputToConsole();
        }
        catch (Exception exception) {
            SimUtilities.showError("Error displaying message", exception);
        }
    }

    protected synchronized void copyOutputToConsole() throws Exception {
        Cat cat = new Cat();
        do {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (byteStream.size() <= 0) continue;
            String string = byteStream.toString();
            byteStream.reset();
            SwingUtilities.invokeAndWait(cat.set(string));
        } while (!this.quit);
    }

    public static void main(String[] stringArray) {
        new RepastConsole(true, true);
        System.out.println("This is my message");
        System.err.println("This is a test of err");
        System.out.println("This is my log message");
    }

    static {
        byteStream = new ByteArrayOutputStream();
    }

    protected class Cat
    implements Runnable {
        String message;

        protected Cat() {
        }

        Cat set(String string) {
            this.message = string;
            return this;
        }

        public void run() {
            RepastConsole.this.textArea.append(this.message);
            RepastConsole.this.textArea.setCaretPosition(RepastConsole.this.textArea.getDocument().getLength());
        }
    }
}

