/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.RGBFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.util.ImageToBuffer;
import uchicago.src.sim.gui.BufferDataSource;
import uchicago.src.sim.util.SimUtilities;

public class MovieMaker
implements ControllerListener,
DataSinkListener {
    private Processor p;
    private BufferDataSource source;
    private Object waitSync = new Object();
    private Object waitFileSync = new Object();
    private boolean fileDone = false;
    boolean stateTransitionOK = true;
    private MediaLocator outML;
    private DataSink sink;
    private String movieType;
    private int frameRate;
    private boolean init = false;
    private int width;
    private int height;

    public MovieMaker(int n, int n2, int n3, String string, String string2) {
        Object object;
        this.movieType = string2;
        this.frameRate = n3;
        this.width = n;
        this.height = n2;
        try {
            object = new File(string);
            string = ((File)object).getCanonicalPath();
            System.out.println(string);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to create file for movie", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        object = "file:/" + string;
        this.outML = new MediaLocator((String)object);
    }

    public boolean init(RGBFormat rGBFormat) {
        this.source = new BufferDataSource(this.width, this.height, this.frameRate, rGBFormat);
        try {
            this.p = Manager.createProcessor((DataSource)this.source);
        }
        catch (Exception exception) {
            SimUtilities.showError("Failed to create processor for movie", exception);
            exception.printStackTrace();
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.configure();
        if (!this.waitForState(this.p, 180)) {
            System.err.println("Failed to configure the processor");
            return false;
        }
        this.p.setContentDescriptor(new ContentDescriptor(this.movieType));
        TrackControl[] trackControlArray = this.p.getTrackControls();
        Format[] formatArray = trackControlArray[0].getSupportedFormats();
        if (formatArray == null || formatArray.length <= 0) {
            System.err.println("The mux does not support the input format: " + trackControlArray[0].getFormat());
            return false;
        }
        trackControlArray[0].setFormat(formatArray[0]);
        this.p.realize();
        if (!this.waitForState(this.p, 300)) {
            System.err.println("Failed to Realize processor");
            return false;
        }
        boolean bl = this.createDataSink();
        if (!bl) {
            return false;
        }
        this.sink.addDataSinkListener((DataSinkListener)this);
        try {
            this.p.start();
            this.sink.start();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Movie error", iOException);
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void addImageAsFrame(Image image) {
        this.addImageAsFrame(image, 40);
    }

    public void addImageAsFrame(Image image, int n) {
        Buffer buffer = ImageToBuffer.createBuffer((Image)image, (float)this.frameRate);
        if (!this.init) {
            boolean bl = this.init((RGBFormat)buffer.getFormat());
            if (!bl) {
                System.err.println("Failed to setup movie capture");
            }
            this.init = true;
        }
        this.source.addBuffer(buffer);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForState(Processor processor, int n) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (processor.getState() < n && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.stateTransitionOK;
    }

    public void cleanUp() {
        this.source.cleanUp();
        this.waitForFileDone();
        try {
            this.sink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.p.removeControllerListener((ControllerListener)this);
        SimUtilities.showMessage("Movie capture has finished");
        System.out.println("Movie done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.sink.close();
            }
        }
    }

    private boolean createDataSink() {
        DataSource dataSource = this.p.getDataOutput();
        try {
            this.sink = Manager.createDataSink((DataSource)dataSource, (MediaLocator)this.outML);
            this.sink.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            System.out.println("End of Media Event");
            controllerEvent.getSourceController().stop();
            controllerEvent.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
        if (dataSinkEvent instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (dataSinkEvent instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
    }
}

