/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uchicago.src.sim.engine.Controller;
import uchicago.src.sim.util.SimUtilities;

public class FrameFactory {
    private static HashMap dataMap = new HashMap();

    private FrameFactory() {
    }

    public static void load(String string) {
        String string2 = System.getProperty("user.home");
        String string3 = string2 + File.separator + ".repast" + File.separator + string.replace('.', File.separatorChar);
        String string4 = string3 + File.separator + "frame_props.xml";
        File file = new File(string4);
        if (file.exists()) {
            FrameFactory.loadXML(string4);
        }
    }

    private static void loadXML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new FileInputStream(string), string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("frame_property");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("name");
                int n = Integer.parseInt(element2.getAttribute("x"));
                int n2 = Integer.parseInt(element2.getAttribute("y"));
                int n3 = Integer.parseInt(element2.getAttribute("width"));
                int n4 = Integer.parseInt(element2.getAttribute("height"));
                FrameData frameData = new FrameData(string2, new Rectangle(n, n2, n3, n4), null);
                dataMap.put(string2, frameData);
            }
        }
        catch (Exception exception) {
            SimUtilities.showError("Error loading persistent frame size and positions", exception);
            exception.printStackTrace();
        }
    }

    public static JFrame createFrame(String string) {
        JFrame jFrame = new JFrame(string);
        FrameData frameData = (FrameData)dataMap.get(string);
        if (frameData != null) {
            jFrame.setBounds(frameData.bounds);
            frameData.frame = jFrame;
        } else {
            frameData = new FrameData(string, null, jFrame);
            dataMap.put(string, frameData);
        }
        jFrame.setIconImage(new ImageIcon(Controller.class.getResource("/uchicago/src/sim/images/RepastSmall.gif")).getImage());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                String string = jFrame.getTitle();
                Rectangle rectangle = jFrame.getBounds();
                if (string.length() > 0) {
                    FrameData frameData = (FrameData)dataMap.get(string);
                    if (frameData == null) {
                        frameData = new FrameData(string, rectangle, jFrame);
                        dataMap.put(string, frameData);
                    } else {
                        frameData.bounds = rectangle;
                    }
                }
            }
        });
        return jFrame;
    }

    public static Rectangle getBounds(String string) {
        FrameData frameData = (FrameData)dataMap.get(string);
        if (frameData != null) {
            return frameData.bounds;
        }
        return null;
    }

    public static void saveFrameData(String string) {
        String string2 = System.getProperty("user.home");
        String string3 = string2 + File.separator + ".repast" + File.separator + string.replace('.', File.separatorChar);
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string4 = string3 + File.separator + "frame_props.xml";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string4));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!-- RePast Frame Properties File -->");
            bufferedWriter.newLine();
            bufferedWriter.write("<RePast:FrameProps xmlns:RePast=\"http://src.uchicago.edu/repast/\" >");
            bufferedWriter.newLine();
            Iterator iterator = dataMap.values().iterator();
            while (iterator.hasNext()) {
                FrameData frameData = (FrameData)iterator.next();
                frameData.resetBounds();
                bufferedWriter.write("  ");
                bufferedWriter.write(frameData.toXML());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</RePast:FrameProps>");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error storing persistent frame size and positions", iOException);
            iOException.printStackTrace();
        }
    }

    static class FrameData {
        String name;
        Rectangle bounds = new Rectangle();
        JFrame frame;

        public FrameData(String string, Rectangle rectangle, JFrame jFrame) {
            this.bounds = rectangle;
            this.name = string;
            this.frame = jFrame;
        }

        public void resetBounds() {
            if (this.frame != null) {
                this.bounds = this.frame.getBounds();
            }
        }

        public String toXML() {
            StringBuffer stringBuffer = new StringBuffer("<frame_property name=\"");
            StringBuffer stringBuffer2 = new StringBuffer(this.name);
            int n = 0;
            while (stringBuffer2.indexOf("&", n) > 0) {
                n = stringBuffer2.indexOf("&", n) + 1;
                stringBuffer2.replace(n - 1, n, "&amp;");
            }
            n = 0;
            while (stringBuffer2.indexOf(">", n) > 0) {
                n = stringBuffer2.indexOf(">", n) + 1;
                stringBuffer2.replace(n - 1, n, "&gt;");
            }
            n = 0;
            while (stringBuffer2.indexOf("<", n) > 0) {
                n = stringBuffer2.indexOf("<", n) + 1;
                stringBuffer2.replace(n - 1, n, "&lt;");
            }
            this.name = stringBuffer2.toString();
            stringBuffer.append(this.name);
            stringBuffer.append("\" x=\"");
            stringBuffer.append(this.bounds.x);
            stringBuffer.append("\" y=\"");
            stringBuffer.append(this.bounds.y);
            stringBuffer.append("\" width=\"");
            stringBuffer.append(this.bounds.width);
            stringBuffer.append("\" height=\"");
            stringBuffer.append(this.bounds.height);
            stringBuffer.append("\" />\n");
            return stringBuffer.toString();
        }
    }
}

