/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui.components;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.gui.model.ConstantParameter;
import uchicago.src.sim.engine.gui.model.DataParameter;
import uchicago.src.sim.engine.gui.model.IncrementParameter;
import uchicago.src.sim.engine.gui.model.ListParameter;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.Parameter;

public class ParameterData {
    private ArrayList inputParameterList;
    private ArrayList outputParameterList;
    private ArrayList parameterList = new ArrayList();
    private boolean changed;
    private String outputLocation;
    ArrayList rootNodes = null;
    private ArrayList configuredParameterList;

    public ParameterData() {
        this.inputParameterList = new ArrayList();
        this.outputParameterList = new ArrayList();
        this.configuredParameterList = new ArrayList();
        this.rootNodes = new ArrayList();
    }

    public ParameterData(String string) {
        this();
        this.outputLocation = string;
        DefaultParameterSetter defaultParameterSetter = new DefaultParameterSetter();
        try {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode;
            defaultParameterSetter.init(string);
            Iterator iterator = defaultParameterSetter.parameterNames();
            Hashtable<String, DefaultMutableTreeNode> hashtable = new Hashtable<String, DefaultMutableTreeNode>();
            DataParameter dataParameter = null;
            String string2 = null;
            Parameter parameter = null;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            Vector vector = null;
            String[] stringArray = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                parameter = (Parameter)defaultParameterSetter.getParameter(string2);
                if (parameter != null) {
                    dataParameter = new DataParameter(string2, parameter.getValue().getClass().toString().replaceFirst("class ", ""), parameter.isInput());
                    this.getParameterList().add(dataParameter);
                }
                dataParameter = this.createParameterNode(parameter);
                defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
                hashtable.put(parameter.getName(), defaultMutableTreeNode);
                if (parameter.getParent() == null) {
                    this.rootNodes.add(defaultMutableTreeNode);
                }
                if ((vector = parameter.getChildren()) == null || vector.size() <= 0) continue;
                for (n = 0; n < vector.size(); ++n) {
                    stringArray = new String[]{parameter.getName(), ((Parameter)vector.elementAt(n)).getName()};
                    arrayList.add(stringArray);
                }
            }
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray = (String[])arrayList.get(n);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashtable.get(stringArray[0]);
                defaultMutableTreeNode = (DefaultMutableTreeNode)hashtable.get(stringArray[1]);
                defaultMutableTreeNode2.insert(defaultMutableTreeNode, defaultMutableTreeNode2.getChildCount());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ParameterData(SimModel simModel) {
        this();
        Hashtable hashtable = null;
        try {
            hashtable = this.getModelProperties(simModel);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        DataParameter dataParameter = null;
        Enumeration enumeration = hashtable.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v == null) continue;
            dataParameter = new DataParameter(string, v.getClass().toString().replaceFirst("class ", ""), true);
            this.getParameterList().add(dataParameter);
        }
    }

    private Hashtable getModelProperties(SimModel simModel) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Hashtable hashtable = new Hashtable(23);
        simModel.clearPropertyListeners();
        String[] stringArray = simModel.getInitParam();
        Introspector introspector = new Introspector();
        introspector.introspect(simModel, stringArray);
        hashtable = introspector.getPropValues();
        return hashtable;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setInputParameterList(ArrayList arrayList) {
        this.inputParameterList = arrayList;
    }

    public ArrayList getInputParameterList() {
        return this.inputParameterList;
    }

    public void setOutputParameterList(ArrayList arrayList) {
        this.outputParameterList = arrayList;
    }

    public ArrayList getOutputParameterList() {
        return this.outputParameterList;
    }

    public void setParameterList(ArrayList arrayList) {
        this.parameterList = arrayList;
    }

    public ArrayList getParameterList() {
        return this.parameterList;
    }

    public void reloadInputOutput() {
        this.inputParameterList.clear();
        this.outputParameterList.clear();
        DataParameter dataParameter = null;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            dataParameter = (DataParameter)this.parameterList.get(i);
            if (dataParameter.isInput()) {
                this.inputParameterList.add(dataParameter);
                continue;
            }
            this.outputParameterList.add(dataParameter);
        }
    }

    public ArrayList getConfiguredParameterList() {
        return this.configuredParameterList;
    }

    public void setConfiguredParameterList(ArrayList arrayList) {
        this.configuredParameterList = arrayList;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String string) {
        this.outputLocation = string;
    }

    private DataParameter createParameterNode(Parameter parameter) {
        String string = null;
        String string2 = null;
        boolean bl = true;
        if (parameter != null) {
            string = parameter.getName();
            string2 = parameter.getValue().getClass().toString().replaceFirst("class ", "");
        }
        int n = (int)parameter.getNumRuns();
        if (parameter.isIncrement()) {
            Object object = parameter.getStart();
            Object object2 = parameter.getEnd();
            Object object3 = parameter.getIncr();
            IncrementParameter incrementParameter = null;
            incrementParameter = new IncrementParameter(n, string, string2, bl, object, object2, object3);
            return incrementParameter;
        }
        if (parameter.isConstant()) {
            Object object = parameter.getValue();
            ConstantParameter constantParameter = null;
            constantParameter = new ConstantParameter(n, string, string2, bl, object);
            return constantParameter;
        }
        if (parameter.isList()) {
            Object[] objectArray = parameter.getList().toArray();
            ListParameter listParameter = null;
            listParameter = new ListParameter(n, string, string2, bl, objectArray);
            return listParameter;
        }
        return null;
    }

    public ArrayList getRootNodes() {
        return this.rootNodes;
    }
}

