/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.engine.ParameterFileListener;
import uchicago.src.sim.engine.gui.components.GUIControllerAbstract;
import uchicago.src.sim.engine.gui.components.ParameterData;
import uchicago.src.sim.engine.gui.components.ParameterWizardPanel;
import uchicago.src.sim.parameter.XMLParameterFileWriter;

public class ParameterWizard
extends GUIControllerAbstract {
    private ParameterWizardPanel paramWizardPanel = new ParameterWizardPanel(this);
    private JDialog dialog;
    private ParameterData aParameterData;
    private ParameterFileListener parameterListener;

    public ParameterWizard(ParameterFileListener parameterFileListener) {
        this.parameterListener = parameterFileListener;
    }

    public void display() {
        this.dialog = new JDialog((Frame)new JFrame(), true);
        this.dialog.setTitle("Parameter Wizard");
        Container container = this.dialog.getContentPane();
        container.add(this.paramWizardPanel);
        this.dialog.pack();
        GuiUtilities.centerComponentOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("INPUT_OUTPUT_CHANGED")) {
            this.aParameterData.reloadInputOutput();
            this.setAParameterData(this.aParameterData);
        } else if (string.equals("CHANGED_OUTPUT_LOCATION")) {
            this.aParameterData.setOutputLocation(this.paramWizardPanel.getOutputLocation());
        } else if (string.equals("EXIT")) {
            this.dialog.setVisible(false);
        } else if (string.equals("RUN_SIMULATION")) {
            this.parameterListener.setParameterFile(this.aParameterData.getOutputLocation());
            XMLParameterFileWriter xMLParameterFileWriter = new XMLParameterFileWriter();
            xMLParameterFileWriter.write(this.aParameterData.getOutputLocation(), this.paramWizardPanel.getTreeTop(), this.aParameterData.getOutputParameterList());
            this.dialog.setVisible(false);
        }
    }

    public ParameterData getAParameterData() {
        return this.aParameterData;
    }

    public void setAParameterData(ParameterData parameterData) {
        this.aParameterData = parameterData;
        this.paramWizardPanel.setParameterData(this.aParameterData);
    }

    public ParameterWizardPanel getParamWizardPanel() {
        return this.paramWizardPanel;
    }

    public void setParamWizardPanel(ParameterWizardPanel parameterWizardPanel) {
        this.paramWizardPanel = parameterWizardPanel;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }
}

