/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.gui.MediaProducer;

public class MovieScheduler {
    private MediaProducer producer;
    private BasicAction frameCapture;
    private BasicAction cleanUp;
    private String fileName;

    public MovieScheduler(String string, MediaProducer mediaProducer) {
        this.producer = mediaProducer;
        this.frameCapture = new FrameCapture(string);
        this.fileName = string;
        this.cleanUp = new BasicAction(){

            public void execute() {
                MovieScheduler.this.producer.closeMovie();
            }
        };
    }

    private void initProducer() {
        this.producer.setMovieName(this.fileName, "video.quicktime");
    }

    public void scheduleAtPauseAndEnd(Schedule schedule) {
        this.initProducer();
        schedule.scheduleActionAtPause(this.frameCapture);
        schedule.scheduleActionAtEnd(this.frameCapture);
        schedule.scheduleActionAtEnd(this.cleanUp);
    }

    public void scheduleAtInterval(Schedule schedule, int n) {
        this.initProducer();
        schedule.scheduleActionAtInterval((double)n, this.frameCapture, Schedule.LAST);
        schedule.scheduleActionAtEnd(this.cleanUp);
    }

    public void scheduleAtEveryTick(Schedule schedule) {
        this.initProducer();
        schedule.scheduleActionAt(0.0, this.frameCapture, Schedule.LAST);
        schedule.scheduleActionAtInterval(1.0, this.frameCapture, Schedule.LAST);
        schedule.scheduleActionAtEnd(this.cleanUp);
    }

    class FrameCapture
    extends BasicAction {
        String fileName;
        boolean nameSet = false;

        public FrameCapture(String string) {
            this.fileName = string;
        }

        public void execute() {
            MovieScheduler.this.producer.addMovieFrame();
        }
    }
}

