/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import uchicago.src.sim.analysis.DataRecorder;
import uchicago.src.sim.analysis.ObjectDataSource;
import uchicago.src.sim.engine.ActionUtilities;
import uchicago.src.sim.engine.BaseController;
import uchicago.src.sim.engine.BatchEvent;
import uchicago.src.sim.engine.BatchListener;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterUtility;
import uchicago.src.sim.util.SimUtilities;

public class BatchController
extends BaseController {
    protected String[] pArray;
    protected long batchCount = 0L;
    protected ArrayList nameList;
    protected ArrayList dynNameList;
    protected Hashtable nameParam = new Hashtable(5);
    protected ArrayList batchListeners = new ArrayList();
    protected volatile boolean finished = false;
    protected boolean stopped;
    protected DataRecorder recorder;
    protected boolean autoRecording = false;
    private Object appMonitor = new Object();

    BatchController() {
        this.params = new DefaultParameterSetter();
    }

    public BatchController(ParameterSetter parameterSetter) {
        this.params = parameterSetter;
        ParameterUtility.createInstance(this.params);
    }

    public void setModel(SimModel simModel) {
        super.setModel(simModel);
        this.params.setModelParameters(simModel);
        simModel.addSimEventListener(this);
    }

    public long getRunCount() {
        return this.batchCount;
    }

    public boolean doWriteHeader(String string) {
        Boolean bl = (Boolean)this.persistentObj.get(string = string + "_WRITE_HEADER");
        if (bl == null) {
            bl = Boolean.TRUE;
            this.persistentObj.put(string, bl);
        }
        return bl;
    }

    public void setWriteHeader(String string, boolean bl) {
        this.persistentObj.put(string + "_WRITE_HEADER", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onTickCountUpdate() {
        this.fireBatchEvent(new BatchEvent(this, BatchEvent.TICK_CHANGED, this.getCurrentTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                while (!BatchController.this.finished && !BatchController.this.stopped) {
                    BatchController.this.start();
                    object = BatchController.this.monitor;
                    synchronized (object) {
                        while (!BatchController.this.runFinished) {
                            try {
                                BatchController.this.monitor.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    BatchController.this.stopRun();
                }
                object = BatchController.this.appMonitor;
                synchronized (object) {
                    BatchController.this.appMonitor.notify();
                }
            }
        };
        this.stopped = false;
        Thread thread = new Thread(runnable);
        thread.start();
        Object object = this.appMonitor;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.appMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.exitSim();
    }

    public void start() {
        this.incrementBatchCount();
        System.out.println("Run: " + this.getRunCount());
        this.listenerList.clear();
        if (this.autoRecording) {
            this.setupRecorder();
        }
        this.startSim();
    }

    public boolean isAutoRecording() {
        return this.autoRecording;
    }

    public void setAutoRecording(boolean bl) {
        this.autoRecording = bl;
    }

    private void setupRecorder() {
        this.recorder = new DataRecorder(this.model.getName() + ".out", this.getModel());
        this.addSourcesFromInitParams(this.recorder, this.model);
        this.model.getSchedule().scheduleActionAtEnd(this.recorder, "record");
        this.model.getSchedule().scheduleActionAtEnd(this.recorder, "writeToFile");
    }

    private void addSourcesFromInitParams(DataRecorder dataRecorder, SimModel simModel) {
        if (this.model == null || dataRecorder == null) {
            return;
        }
        String[] stringArray = simModel.getInitParam();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSourceFromInitParam(dataRecorder, simModel, stringArray[i]);
        }
    }

    private void addSourceFromInitParam(DataRecorder dataRecorder, SimModel simModel, String string) {
        if (this.model == null || dataRecorder == null || string == null) {
            return;
        }
        String string2 = "get" + SimUtilities.capitalize(string);
        try {
            Method method = ActionUtilities.getNoArgMethod(simModel, string2);
            if (method.getReturnType().isPrimitive() && method.getReturnType() != Boolean.TYPE) {
                dataRecorder.createNumericDataSource(string, simModel, string2);
            } else if (method.getReturnType().isPrimitive() && method.getReturnType() == Boolean.TYPE) {
                dataRecorder.addObjectDataSource(string, new ObjectDataSource(string, (Object)simModel, string2));
            } else {
                dataRecorder.createObjectDataSource(string, simModel, string2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void stopRun() {
        this.model.generateNewSeed();
        this.model.setup();
        this.runThread = null;
        this.params.setNextModelParameters(this.model);
        this.finished = !this.params.hasNext();
        this.runFinished = false;
        this.fireBatchEvent(new BatchEvent(this, BatchEvent.RUN_ENDED));
    }

    public void simEventPerformed(SimEvent simEvent) {
        if (simEvent.getId() == 0) {
            this.stopSim();
        }
    }

    public void endSim() {
        this.stopped = true;
        super.stopSim();
        this.exitSim();
    }

    public void exitSim() {
        System.out.println("Batch Done");
        this.fireSimEvent(new SimEvent(this, 2));
        if (this.exitOnExit) {
            System.exit(0);
        }
        this.fireBatchEvent(new BatchEvent(this, BatchEvent.BATCH_FINISHED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBatchEvent(BatchEvent batchEvent) {
        ArrayList arrayList = this.batchListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.batchListeners.clone();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                BatchListener batchListener = (BatchListener)iterator.next();
                batchListener.batchEventPerformed(batchEvent);
            }
        }
    }

    public void incrementBatchCount() {
        ++this.batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatchListener(BatchListener batchListener) {
        ArrayList arrayList = this.batchListeners;
        synchronized (arrayList) {
            this.batchListeners.add(batchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatchListener(BatchListener batchListener) {
        ArrayList arrayList = this.batchListeners;
        synchronized (arrayList) {
            this.batchListeners.remove(batchListener);
        }
    }

    public boolean isBatch() {
        return true;
    }

    public boolean isGUI() {
        return false;
    }
}

