/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimEventListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterUtility;
import uchicago.src.sim.util.SimUtilities;

public abstract class BaseController
implements SimEventListener,
IController {
    protected Schedule schedule = null;
    protected Runnable simRun = null;
    protected double time = 0.0;
    protected volatile Thread runThread;
    protected volatile boolean go = false;
    protected volatile boolean pauseSim = false;
    protected boolean done = false;
    protected volatile boolean doStep = false;
    protected volatile boolean runFinished = false;
    protected int sleepValue = 5;
    protected SimModel model;
    protected boolean pauseActionsExecuted = false;
    protected boolean isGui = false;
    protected Hashtable persistentObj = new Hashtable();
    protected ParameterSetter params = null;
    protected int pauseAt = -1;
    protected boolean executeBegin = true;
    protected Object monitor = new Object();
    protected ArrayList listenerList = new ArrayList();
    protected boolean exitOnExit = true;
    protected BasicAction pauseAtAction = new PauseAction();

    public BaseController() {
        ParameterUtility.createInstance();
    }

    public void setModel(SimModel simModel) {
        this.model = simModel;
        if (simModel != null) {
            simModel.setup();
        }
    }

    public SimModel getModel() {
        return this.model;
    }

    public int getCellWidth() {
        return DisplayConstants.CELL_WIDTH;
    }

    public void setCellWidth(int n) {
        if (this.runThread == null) {
            DisplayConstants.CELL_WIDTH = n;
        }
    }

    public int getCellHeight() {
        return DisplayConstants.CELL_HEIGHT;
    }

    public void setCellHeight(int n) {
        if (this.runThread == null) {
            DisplayConstants.CELL_HEIGHT = n;
        }
    }

    public int getCellDepth() {
        return DisplayConstants.CELL_DEPTH;
    }

    public void setCellDepth(int n) {
        if (this.runThread == null) {
            DisplayConstants.CELL_DEPTH = n;
        }
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.setupSchedule();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public double getCurrentTime() {
        return this.time;
    }

    protected abstract void onTickCountUpdate();

    public void setRandomSeed(long l) {
        this.fireSimEvent(new SimEvent(this, 3));
        this.model.setRngSeed(l);
    }

    public long getRandomSeed() {
        return this.model.getRngSeed();
    }

    protected void beginModel() {
        this.model.begin();
    }

    public void startSim() {
        this.setPauseAt(this.pauseAt);
        this.fireSimEvent(new SimEvent(this, 4));
        if (this.runThread == null) {
            if (this.executeBegin) {
                this.beginModel();
            }
            this.schedule = this.model.getSchedule();
            this.setupSchedule();
        }
        if (this.schedule == null) {
            SimUtilities.showMessage("No schedule to run");
            System.exit(0);
        } else if (!this.go) {
            this.go = true;
            this.pauseSim = false;
            this.doStep = false;
            if (this.runThread == null) {
                this.runThread = new Thread(this.simRun);
                this.runThread.start();
            }
        } else if (this.go) {
            this.pauseSim = false;
            this.doStep = false;
            this.notifyMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMonitor() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    protected void setupSchedule() {
        this.simRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Toolkit toolkit = null;
                EventQueue eventQueue = null;
                if (BaseController.this.isGui) {
                    toolkit = Toolkit.getDefaultToolkit();
                    eventQueue = toolkit.getSystemEventQueue();
                }
                while (BaseController.this.go) {
                    BaseController.this.schedule.preExecute();
                    BaseController.this.time = BaseController.this.schedule.getCurrentTime();
                    BaseController.this.schedule.execute();
                    BaseController.this.onTickCountUpdate();
                    if (BaseController.this.doStep) {
                        BaseController.this.doStep = false;
                        BaseController.this.pauseSim = true;
                    }
                    if (BaseController.this.pauseSim) {
                        try {
                            Object object;
                            if (!BaseController.this.pauseActionsExecuted) {
                                object = BaseController.this.schedule.getPauseActions();
                                for (int i = 0; i < ((Vector)object).size(); ++i) {
                                    BasicAction basicAction = (BasicAction)((Vector)object).elementAt(i);
                                    basicAction.execute();
                                }
                                BaseController.this.pauseActionsExecuted = true;
                                BaseController.this.fireSimEvent(new SimEvent(this, 1));
                                BaseController.this.model.fireSimEvent(new SimEvent(this, 1));
                            }
                            object = BaseController.this.monitor;
                            synchronized (object) {
                                while (BaseController.this.pauseSim) {
                                    BaseController.this.monitor.wait();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            BaseController.this.go = false;
                            BaseController.this.pauseSim = false;
                            BaseController.this.doStep = false;
                        }
                        finally {
                            BaseController.this.pauseActionsExecuted = true;
                        }
                    }
                    BaseController.this.pauseActionsExecuted = false;
                    try {
                        if (!BaseController.this.isGui) continue;
                        while (eventQueue.peekEvent() != null && BaseController.this.go) {
                            Thread.sleep(BaseController.this.sleepValue);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        BaseController.this.go = false;
                        BaseController.this.pauseSim = false;
                        BaseController.this.doStep = false;
                    }
                }
                BaseController.this.schedule.executeEndActions();
                BaseController.this.fireSimEvent(new SimEvent(this, 0));
                BaseController.this.model.fireSimEvent(new SimEvent(this, 0));
                BaseController.this.time = 0.0;
                BaseController.this.runFinished = true;
                BaseController.this.notifyMonitor();
                BaseController.this.model.clearPropertyListeners();
            }
        };
        this.runThread = null;
    }

    public Hashtable getModelParameters() {
        Hashtable hashtable = new Hashtable(23);
        if (this.model != null) {
            try {
                hashtable = ParameterUtility.getInstance().getModelProperties(this.model);
            }
            catch (Exception exception) {
                SimUtilities.showError("Error retrieving model properties", exception);
                System.exit(0);
            }
        }
        return hashtable;
    }

    public Hashtable getDefaultModelParameters() {
        return this.params.getDefaultModelParameters(this.model);
    }

    public void pauseSim() {
        this.pauseSim = true;
    }

    public void stopSim() {
        this.go = false;
        this.doStep = false;
        this.pauseSim = false;
        this.notifyMonitor();
    }

    public boolean isBatch() {
        return false;
    }

    public void addSimEventListener(SimEventListener simEventListener) {
        this.listenerList.add(simEventListener);
    }

    public void removeSimEventListener(SimEventListener simEventListener) {
        this.listenerList.remove(simEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSimEvent(SimEvent simEvent) {
        ArrayList arrayList;
        ArrayList arrayList2 = this.listenerList;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listenerList.clone();
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            SimEventListener simEventListener = (SimEventListener)arrayList.get(i);
            simEventListener.simEventPerformed(simEvent);
        }
    }

    public void putPersistentObj(Object object, Object object2) {
        this.persistentObj.put(object, object2);
    }

    public Object getPersistentObj(Object object) {
        return this.persistentObj.get(object);
    }

    public void setPauseAt(int n) {
        this.pauseAt = n;
        if (n > 0) {
            if (this.model != null) {
                if (this.pauseAtAction != null) {
                    this.model.getSchedule().removeAction(this.pauseAtAction);
                }
                this.pauseAtAction = this.model.getSchedule().scheduleActionAt(this.pauseAt, this.pauseAtAction);
            }
        } else if (this.model != null && this.model.getSchedule() != null && this.pauseAtAction != null) {
            this.model.getSchedule().removeAction(this.pauseAtAction);
        }
    }

    public int getPauseAt() {
        return this.pauseAt;
    }

    public void setExitOnExit(boolean bl) {
        this.exitOnExit = bl;
    }

    public boolean getExitOnExit() {
        return this.exitOnExit;
    }

    class PauseAction
    extends BasicAction {
        PauseAction() {
        }

        public void execute() {
            BaseController.this.pauseSim();
        }
    }
}

