/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.io.Serializable;
import java.lang.reflect.Method;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.IAsynchAgent;
import uchicago.src.sim.engine.Schedule;

public class AsynchSchedule
extends Schedule
implements Serializable {
    private double delta = 1.0E-8;
    private double startTime = Double.NaN;
    private boolean notingCaller = true;

    public AsynchSchedule() {
    }

    public AsynchSchedule(double d) {
        super(d);
    }

    public BasicAction scheduleNow(IAsynchAgent iAsynchAgent, String string) {
        return this.scheduleNow(iAsynchAgent, string, null, null, null);
    }

    public BasicAction scheduleNow(IAsynchAgent iAsynchAgent, String string, Object object) {
        return this.scheduleNow(iAsynchAgent, string, object, null, null);
    }

    public BasicAction scheduleNow(IAsynchAgent iAsynchAgent, String string, Object object, Object object2) {
        return this.scheduleNow(iAsynchAgent, string, object, object2, null);
    }

    public BasicAction scheduleNow(IAsynchAgent iAsynchAgent, String string, Object object, Object object2, Object object3) {
        double d = this.getCurrentTime() + this.getDelta();
        return this.schedule(d, iAsynchAgent, string, object, object2, object3);
    }

    public BasicAction scheduleWhenAvailable(IAsynchAgent iAsynchAgent, String string) {
        return this.scheduleWhenAvailable(iAsynchAgent, string, null, null, null);
    }

    public BasicAction scheduleWhenAvailable(IAsynchAgent iAsynchAgent, String string, Object object) {
        return this.scheduleWhenAvailable(iAsynchAgent, string, object, null, null);
    }

    public BasicAction scheduleWhenAvailable(IAsynchAgent iAsynchAgent, String string, Object object, Object object2) {
        return this.scheduleWhenAvailable(iAsynchAgent, string, object, object2, null);
    }

    public BasicAction scheduleWhenAvailable(IAsynchAgent iAsynchAgent, String string, Object object, Object object2, Object object3) {
        double d = iAsynchAgent.getNextAvailableTime();
        return this.schedule(d, iAsynchAgent, string, object, object2, object3);
    }

    public BasicAction scheduleAt(double d, IAsynchAgent iAsynchAgent, String string) {
        return this.scheduleAt(d, iAsynchAgent, string, null, null, null);
    }

    public BasicAction scheduleAt(double d, IAsynchAgent iAsynchAgent, String string, Object object) {
        return this.scheduleAt(d, iAsynchAgent, string, object, null, null);
    }

    public BasicAction scheduleAt(double d, IAsynchAgent iAsynchAgent, String string, Object object, Object object2) {
        return this.scheduleAt(d, iAsynchAgent, string, object, object2, null);
    }

    public BasicAction scheduleAt(double d, IAsynchAgent iAsynchAgent, String string, Object object, Object object2, Object object3) {
        return this.schedule(d, iAsynchAgent, string, object, object2, object3);
    }

    public BasicAction scheduleAfterWaiting(IAsynchAgent iAsynchAgent, String string) {
        return this.scheduleAfterWaiting(iAsynchAgent, string, null, null, null);
    }

    public BasicAction scheduleAfterWaiting(IAsynchAgent iAsynchAgent, String string, Object object) {
        return this.scheduleAfterWaiting(iAsynchAgent, string, object, null, null);
    }

    public BasicAction scheduleAfterWaiting(IAsynchAgent iAsynchAgent, String string, Object object, Object object2) {
        return this.scheduleAfterWaiting(iAsynchAgent, string, object, object2, null);
    }

    public BasicAction scheduleAfterWaiting(IAsynchAgent iAsynchAgent, String string, Object object, Object object2, Object object3) {
        double d = iAsynchAgent.findNextTaskCompletionTime();
        return this.schedule(d, iAsynchAgent, string, object, object2, object3);
    }

    public BasicAction schedule(double d, final IAsynchAgent iAsynchAgent, final String string, Object object, Object object2, Object object3) {
        Exception exception;
        Object[] objectArray;
        if (object == null) {
            objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
        } else if (object2 == null) {
            objectArray = new Object[]{object};
            Class[] classArray = new Class[]{object.getClass()};
        } else if (object3 == null) {
            objectArray = new Object[]{object, object2};
            Class[] classArray = new Class[]{object.getClass(), object2.getClass()};
        } else {
            objectArray = new Object[3];
            objectArray[0] = object;
            objectArray[0] = object2;
            objectArray[0] = object3;
            Class[] classArray = new Class[]{object.getClass(), object2.getClass(), object3.getClass()};
        }
        if (this.isNotingCaller()) {
            try {
                throw new Exception();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        } else {
            exception = null;
        }
        if (Double.isNaN(this.getStartTime()) || d < this.getStartTime()) {
            this.setStartTime(d);
        }
        return this.scheduleActionAt(d, new BasicAction(){

            public void execute() {
                int n;
                Method[] methodArray = null;
                Class<?>[] classArray = null;
                try {
                    int n2;
                    methodArray = iAsynchAgent.getClass().getMethods();
                    boolean bl = false;
                    for (n = 0; n < methodArray.length; ++n) {
                        classArray = methodArray[n].getParameterTypes();
                        if (string.equals(methodArray[n].getName()) && classArray.length == objectArray.length) {
                            bl = true;
                            for (n2 = 0; n2 < classArray.length; ++n2) {
                                if (classArray[n2].isInstance(objectArray[n2])) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (bl) break;
                    }
                    if (bl) {
                        methodArray[n].invoke((Object)iAsynchAgent, objectArray);
                    } else {
                        System.err.println("Manual method resolution to work around Java Bug Database entries 4287725, 4301875, 4401287, and 4651775 failed to find a match.");
                        System.err.println("Tried to setup a call for:");
                        System.err.print("    " + iAsynchAgent + "." + string + "(");
                        for (n2 = 0; n2 < objectArray.length; ++n2) {
                            if (n2 > 0) {
                                System.err.print(", ");
                            }
                            System.err.print("" + objectArray[n2]);
                        }
                        System.err.println(")");
                        if (exception == null) {
                            System.err.println("No context available.  Please set CallbackScheduler.setNotingCaller(true) for context.");
                        } else {
                            System.err.print("The context was:");
                            exception.printStackTrace();
                        }
                        System.err.println("The available methods where:");
                        for (n = 0; n < methodArray.length; ++n) {
                            classArray = methodArray[n].getParameterTypes();
                            System.err.print(methodArray[n].getName() + "(");
                            for (n2 = 0; n2 < classArray.length; ++n2) {
                                if (n2 > 0) {
                                    System.err.print(", ");
                                }
                                System.err.print(classArray[n2].getName());
                            }
                            System.err.println(")");
                        }
                    }
                }
                catch (Exception exception3) {
                    try {
                        System.err.println("Tried to call:");
                        if (methodArray != null && methodArray.length > n) {
                            System.err.print("    " + iAsynchAgent + "." + methodArray[n].getName() + "(");
                            if (classArray != null) {
                                for (int i = 0; i < objectArray.length; ++i) {
                                    if (i > 0) {
                                        System.err.print(", ");
                                    }
                                    System.err.print("" + objectArray[i]);
                                }
                            }
                            System.err.println(")");
                        } else {
                            System.err.println("    " + iAsynchAgent + ".?(...)");
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    exception3.printStackTrace();
                }
            }
        });
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double d) {
        this.delta = d;
    }

    public double getTotalTime() {
        if (Double.isNaN(this.getStartTime())) {
            return 0.0;
        }
        return this.getCurrentTime() - this.getStartTime();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double d) {
        this.startTime = d;
    }

    public boolean isNotingCaller() {
        return this.notingCaller;
    }

    public void setNotingCaller(boolean bl) {
        this.notingCaller = bl;
    }
}

