/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import uchicago.src.sim.util.SimUtilities;

public class ObjectData {
    private Vector data = new Vector();
    private String dataHeader;
    private String fileName;
    private String modelHeader;
    private boolean isBatch;
    private boolean nothingWritten = true;

    public ObjectData(String string, String string2, String string3, boolean bl) {
        this.fileName = string;
        this.modelHeader = string2;
        this.isBatch = bl;
        this.dataHeader = string3;
    }

    public void addData(Object object) {
        this.data.add(object);
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            if (this.isBatch) {
                string = string + ".bak";
            }
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }

    public void writeToFile() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.nothingWritten) {
                this.renameFile();
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                bufferedWriter.write(this.modelHeader);
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.write(this.dataHeader);
                bufferedWriter.newLine();
            }
            this.nothingWritten = false;
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            for (int i = 0; i < this.data.size(); ++i) {
                bufferedWriter.write(this.data.get(i).toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            this.data.clear();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write data to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

